/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.api.gax.grpc;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.CallOptions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCall;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ForwardingClientCallListener;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ManagedChannel;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Metadata;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.MethodDescriptor;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.Status;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

class SafeShutdownManagedChannel
extends ManagedChannel {
    private final ManagedChannel delegate;
    private final AtomicInteger outstandingCalls = new AtomicInteger(0);
    private volatile boolean isShutdownSafely = false;

    SafeShutdownManagedChannel(ManagedChannel managedChannel) {
        this.delegate = managedChannel;
    }

    void shutdownSafely() {
        this.isShutdownSafely = true;
        if (this.outstandingCalls.get() == 0) {
            this.delegate.shutdown();
        }
    }

    @Override
    public ManagedChannel shutdown() {
        this.delegate.shutdown();
        return this;
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public ManagedChannel shutdownNow() {
        this.delegate.shutdownNow();
        return this;
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    private void onClientCallClose() {
        if (this.outstandingCalls.decrementAndGet() == 0 && this.isShutdownSafely) {
            this.shutdownSafely();
        }
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Preconditions.checkState(!this.isShutdownSafely);
        ClientCallProxy<RequestT, ResponseT> clientCall = new ClientCallProxy<RequestT, ResponseT>(this.delegate.newCall(methodDescriptor, callOptions));
        this.outstandingCalls.incrementAndGet();
        return clientCall;
    }

    @Override
    public String authority() {
        return this.delegate.authority();
    }

    private class ClientCallProxy<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        ClientCallProxy(ClientCall<ReqT, RespT> delegate) {
            super(delegate);
        }

        @Override
        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            super.start(new DecrementOutstandingCalls<RespT>(responseListener), headers);
        }
    }

    private class DecrementOutstandingCalls<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        DecrementOutstandingCalls(ClientCall.Listener<RespT> delegate) {
            super(delegate);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            try {
                super.onClose(status, trailers);
            }
            finally {
                SafeShutdownManagedChannel.this.onClientCallClose();
            }
        }
    }
}

