/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.auto.value.AutoValue;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.AutoValue_GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class GoogleCloudStorageOptions {
    public static final boolean ENABLE_GRPC_DEFAULT = false;
    public static final String STORAGE_ROOT_URL_DEFAULT = "https://storage.googleapis.com/";
    public static final boolean AUTO_REPAIR_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final boolean INFER_IMPLICIT_DIRECTORIES_DEFAULT = true;
    public static final int MAX_WAIT_MILLIS_FOR_EMPTY_OBJECT_CREATION = 3000;
    public static final long MAX_LIST_ITEMS_PER_CALL_DEFAULT = 1024L;
    public static final long MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int BATCH_THREADS_DEFAULT = 0;
    public static final int MAX_HTTP_REQUEST_RETRIES = 10;
    public static final int HTTP_REQUEST_CONNECT_TIMEOUT = 20000;
    public static final int HTTP_REQUEST_READ_TIMEOUT = 20000;
    public static final boolean COPY_WITH_REWRITE_DEFAULT = false;
    public static final int MAX_BYTES_REWRITTEN_PER_CALL_DEFAULT = 0;
    public static final long COPY_MAX_REQUESTS_PER_BATCH_DEFAULT = 30L;
    public static final int COPY_BATCH_THREADS_DEFAULT = 0;
    public static final ImmutableMap<String, String> HTTP_REQUEST_HEADERS_DEFAULT = ImmutableMap.of();
    public static final GoogleCloudStorageOptions DEFAULT = GoogleCloudStorageOptions.builder().build();

    @Deprecated
    public static Builder newBuilder() {
        return GoogleCloudStorageOptions.builder();
    }

    public static Builder builder() {
        return new AutoValue_GoogleCloudStorageOptions.Builder().setGrpcEnabled(false).setStorageRootUrl(STORAGE_ROOT_URL_DEFAULT).setAutoRepairImplicitDirectoriesEnabled(true).setInferImplicitDirectoriesEnabled(true).setMaxWaitMillisForEmptyObjectCreation(3000).setMaxListItemsPerCall(1024L).setMaxRequestsPerBatch(30L).setBatchThreads(0).setMaxHttpRequestRetries(10).setHttpRequestConnectTimeout(20000).setHttpRequestReadTimeout(20000).setTransportType(HttpTransportFactory.DEFAULT_TRANSPORT_TYPE).setCopyWithRewriteEnabled(false).setMaxBytesRewrittenPerCall(0L).setCopyMaxRequestsPerBatch(30L).setCopyBatchThreads(0).setReadChannelOptions(GoogleCloudStorageReadOptions.DEFAULT).setWriteChannelOptions(AsyncWriteChannelOptions.DEFAULT).setRequesterPaysOptions(RequesterPaysOptions.DEFAULT).setCooperativeLockingOptions(CooperativeLockingOptions.DEFAULT).setHttpRequestHeaders(HTTP_REQUEST_HEADERS_DEFAULT);
    }

    public abstract boolean isGrpcEnabled();

    public abstract String getStorageRootUrl();

    @Nullable
    public abstract String getProjectId();

    @Nullable
    public abstract String getAppName();

    public abstract boolean isAutoRepairImplicitDirectoriesEnabled();

    public abstract boolean isInferImplicitDirectoriesEnabled();

    public abstract int getMaxWaitMillisForEmptyObjectCreation();

    public abstract long getMaxListItemsPerCall();

    public abstract long getMaxRequestsPerBatch();

    public abstract int getBatchThreads();

    public abstract long getCopyMaxRequestsPerBatch();

    public abstract int getCopyBatchThreads();

    public abstract int getMaxHttpRequestRetries();

    public abstract int getHttpRequestConnectTimeout();

    public abstract int getHttpRequestReadTimeout();

    public abstract HttpTransportFactory.HttpTransportType getTransportType();

    @Nullable
    public abstract String getProxyAddress();

    @Nullable
    public abstract String getProxyUsername();

    @Nullable
    public abstract String getProxyPassword();

    public abstract boolean isCopyWithRewriteEnabled();

    public abstract long getMaxBytesRewrittenPerCall();

    public abstract GoogleCloudStorageReadOptions getReadChannelOptions();

    public abstract AsyncWriteChannelOptions getWriteChannelOptions();

    public abstract RequesterPaysOptions getRequesterPaysOptions();

    public abstract CooperativeLockingOptions getCooperativeLockingOptions();

    public abstract ImmutableMap<String, String> getHttpRequestHeaders();

    public abstract Builder toBuilder();

    public void throwIfNotValid() {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(this.getAppName()), "appName must not be null or empty");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setGrpcEnabled(boolean var1);

        public abstract Builder setStorageRootUrl(String var1);

        public abstract Builder setProjectId(String var1);

        public abstract Builder setAppName(String var1);

        public abstract Builder setAutoRepairImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setInferImplicitDirectoriesEnabled(boolean var1);

        public abstract Builder setMaxWaitMillisForEmptyObjectCreation(int var1);

        public abstract Builder setMaxListItemsPerCall(long var1);

        public abstract Builder setMaxRequestsPerBatch(long var1);

        public abstract Builder setBatchThreads(int var1);

        public abstract Builder setMaxHttpRequestRetries(int var1);

        public abstract Builder setHttpRequestConnectTimeout(int var1);

        public abstract Builder setHttpRequestReadTimeout(int var1);

        public abstract Builder setTransportType(HttpTransportFactory.HttpTransportType var1);

        public abstract Builder setProxyAddress(String var1);

        public abstract Builder setProxyUsername(String var1);

        public abstract Builder setProxyPassword(String var1);

        public abstract Builder setCopyWithRewriteEnabled(boolean var1);

        public abstract Builder setMaxBytesRewrittenPerCall(long var1);

        public abstract Builder setCopyMaxRequestsPerBatch(long var1);

        public abstract Builder setCopyBatchThreads(int var1);

        public abstract Builder setReadChannelOptions(GoogleCloudStorageReadOptions var1);

        public abstract Builder setWriteChannelOptions(AsyncWriteChannelOptions var1);

        public abstract Builder setRequesterPaysOptions(RequesterPaysOptions var1);

        public abstract Builder setCooperativeLockingOptions(CooperativeLockingOptions var1);

        public abstract Builder setHttpRequestHeaders(Map<String, String> var1);

        abstract GoogleCloudStorageOptions autoBuild();

        public GoogleCloudStorageOptions build() {
            GoogleCloudStorageOptions instance = this.autoBuild();
            Preconditions.checkArgument(instance.getMaxBytesRewrittenPerCall() <= 0L || instance.getMaxBytesRewrittenPerCall() % 0x100000L == 0L, "maxBytesRewrittenPerCall must be an integral multiple of 1 MiB (1048576), but was: %s", instance.getMaxBytesRewrittenPerCall());
            Preconditions.checkArgument(instance.getProxyAddress() != null || instance.getProxyUsername() == null && instance.getProxyPassword() == null, "if proxyAddress is null then proxyUsername and proxyPassword should be null too");
            Preconditions.checkArgument(instance.getProxyUsername() == null == (instance.getProxyPassword() == null), "both proxyUsername and proxyPassword should be null or not null together");
            return instance;
        }
    }
}

