/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateObjectOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StringPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationDelete;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CoopLockOperationRename;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.LazyExecutorService;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.Futures;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ListeningExecutorService;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.MoreExecutors;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class GoogleCloudStorageFileSystem {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("gcsfs-thread-%d").setDaemon(true).build();
    public static final String SCHEME = "gs";
    public static final URI GCS_ROOT = URI.create("gs:/");
    private GoogleCloudStorage gcs;
    private final GoogleCloudStorageFileSystemOptions options;
    private ExecutorService cachedExecutor = GoogleCloudStorageFileSystem.createCachedExecutor();
    @VisibleForTesting
    static final Comparator<URI> PATH_COMPARATOR = Comparator.comparing(URI::toString, (as, bs) -> as.length() == bs.length() ? as.compareTo((String)bs) : Integer.compare(as.length(), bs.length()));
    @VisibleForTesting
    static final Comparator<FileInfo> FILE_INFO_PATH_COMPARATOR = Comparator.comparing(FileInfo::getPath, PATH_COMPARATOR);

    public GoogleCloudStorageFileSystem(Credential credential, GoogleCloudStorageFileSystemOptions options) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GoogleCloudStorageFileSystem(options: %s)", options);
        options.throwIfNotValid();
        Preconditions.checkArgument(credential != null, "credential must not be null");
        this.options = options;
        this.gcs = new GoogleCloudStorageImpl(options.getCloudStorageOptions(), credential);
        if (options.isPerformanceCacheEnabled()) {
            this.gcs = new PerformanceCachingGoogleCloudStorage(this.gcs, options.getPerformanceCacheOptions());
        }
    }

    @VisibleForTesting
    public GoogleCloudStorageFileSystem(GoogleCloudStorage gcs) {
        this(gcs, GoogleCloudStorageFileSystemOptions.builder().setCloudStorageOptions(gcs.getOptions()).build());
    }

    @VisibleForTesting
    public GoogleCloudStorageFileSystem(GoogleCloudStorage gcs, GoogleCloudStorageFileSystemOptions options) {
        this.gcs = gcs;
        this.options = options;
    }

    private static ExecutorService createCachedExecutor() {
        ThreadPoolExecutor service = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("gcsfs-misc-%d").setDaemon(true).build());
        service.allowCoreThreadTimeOut(true);
        return service;
    }

    public GoogleCloudStorageFileSystemOptions getOptions() {
        return this.options;
    }

    public static CreateObjectOptions objectOptionsFromFileOptions(CreateFileOptions options) {
        return new CreateObjectOptions(options.overwriteExisting(), options.getContentType(), options.getAttributes());
    }

    public WritableByteChannel create(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("create(path: %s)", path);
        return this.create(path, CreateFileOptions.DEFAULT);
    }

    public WritableByteChannel create(URI path, CreateFileOptions options) throws IOException {
        URI parentPath;
        ((GoogleLogger.Api)logger.atFine()).log("create(path: %s, options: %s)", (Object)path, (Object)options);
        Preconditions.checkNotNull(path, "path could not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isDirectory()) {
            throw new IOException(String.format("Cannot create a file whose name looks like a directory: '%s'", resourceId));
        }
        if (options.checkNoDirectoryConflict() && this.getFileInfoInternal(resourceId.toDirectoryId(), this.gcs.getOptions().isInferImplicitDirectoriesEnabled()).exists()) {
            throw new FileAlreadyExistsException("A directory with that name exists: " + path);
        }
        if (options.ensureParentDirectoriesExist() && (parentPath = UriPaths.getParentPath(path)) != null) {
            this.mkdirs(parentPath);
        }
        if (options.getExistingGenerationId() != -1L) {
            resourceId = new StorageResourceId(resourceId.getBucketName(), resourceId.getObjectName(), options.getExistingGenerationId());
        }
        return this.gcs.create(resourceId, GoogleCloudStorageFileSystem.objectOptionsFromFileOptions(options));
    }

    public SeekableByteChannel open(URI path) throws IOException {
        return this.open(path, GoogleCloudStorageReadOptions.DEFAULT);
    }

    public SeekableByteChannel open(URI path, GoogleCloudStorageReadOptions readOptions) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("open(path: %s, readOptions: %s)", (Object)path, (Object)readOptions);
        Preconditions.checkNotNull(path, "path should not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, false);
        Preconditions.checkArgument(!resourceId.isDirectory(), "Cannot open a directory for reading: %s", (Object)path);
        return this.gcs.open(resourceId, readOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI path, boolean recursive) throws IOException {
        List<Object> itemsToDelete;
        Preconditions.checkNotNull(path, "path can not be null");
        Preconditions.checkArgument(!path.equals(GCS_ROOT), "Cannot delete root path (%s)", (Object)path);
        ((GoogleLogger.Api)logger.atFine()).log("delete(path: %s, recursive: %b)", (Object)path, recursive);
        FileInfo fileInfo = this.getFileInfo(path);
        if (!fileInfo.exists()) {
            throw new FileNotFoundException("Item not found: " + path);
        }
        Future<GoogleCloudStorageItemInfo> parentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId parentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(path), true);
            parentInfoFuture = this.cachedExecutor.submit(() -> this.getFileInfoInternal(parentId, false));
        }
        Optional<CoopLockOperationDelete> coopLockOp = this.options.isCooperativeLockingEnabled() && fileInfo.isDirectory() ? Optional.of(CoopLockOperationDelete.create(this.gcs, fileInfo.getPath())) : Optional.empty();
        coopLockOp.ifPresent(CoopLockOperationDelete::lock);
        if (fileInfo.isDirectory()) {
            List<FileInfo> list = itemsToDelete = recursive ? this.listAllFileInfoForPrefix(fileInfo.getPath()) : this.listFileInfo(fileInfo.getPath());
            if (!itemsToDelete.isEmpty() && !recursive) {
                throw new DirectoryNotEmptyException("Cannot delete a non-empty directory.");
            }
        } else {
            itemsToDelete = new ArrayList();
        }
        ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>();
        (fileInfo.getItemInfo().isBucket() ? bucketsToDelete : itemsToDelete).add(fileInfo);
        coopLockOp.ifPresent(o -> o.persistAndScheduleRenewal(itemsToDelete, bucketsToDelete));
        try {
            this.deleteInternal(itemsToDelete, bucketsToDelete);
            coopLockOp.ifPresent(CoopLockOperationDelete::unlock);
        }
        finally {
            coopLockOp.ifPresent(CoopLockOperationDelete::cancelRenewal);
        }
        this.repairImplicitDirectory(parentInfoFuture);
    }

    private void deleteInternal(List<FileInfo> itemsToDelete, List<FileInfo> bucketsToDelete) throws IOException {
        itemsToDelete.sort(FILE_INFO_PATH_COMPARATOR.reversed());
        if (!itemsToDelete.isEmpty()) {
            ArrayList<StorageResourceId> objectsToDelete = new ArrayList<StorageResourceId>(itemsToDelete.size());
            for (FileInfo fileInfo : itemsToDelete) {
                objectsToDelete.add(new StorageResourceId(fileInfo.getItemInfo().getBucketName(), fileInfo.getItemInfo().getObjectName(), fileInfo.getItemInfo().getContentGeneration()));
            }
            this.gcs.deleteObjects(objectsToDelete);
        }
        if (!bucketsToDelete.isEmpty()) {
            ArrayList<String> bucketNames = new ArrayList<String>(bucketsToDelete.size());
            for (FileInfo bucketInfo : bucketsToDelete) {
                bucketNames.add(bucketInfo.getItemInfo().getResourceId().getBucketName());
            }
            if (this.options.isBucketDeleteEnabled()) {
                this.gcs.deleteBuckets(bucketNames);
            } else {
                ((GoogleLogger.Api)logger.atInfo()).log("Skipping deletion of buckets because enableBucketDelete is false: %s", bucketNames);
            }
        }
    }

    public boolean exists(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("exists(path: %s)", path);
        return this.getFileInfo(path).exists();
    }

    public void mkdirs(URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("mkdirs(path: %s)", path);
        Preconditions.checkNotNull(path, "path should not be null");
        this.mkdirsInternal(StorageResourceId.fromUriPath(path, true));
    }

    public void mkdirsInternal(StorageResourceId resourceId) throws IOException {
        if (resourceId.isRoot()) {
            return;
        }
        resourceId = resourceId.toDirectoryId();
        List<String> subdirs = GoogleCloudStorageFileSystem.getSubDirs(resourceId.getObjectName());
        ArrayList<StorageResourceId> itemIds = new ArrayList<StorageResourceId>(subdirs.size() * 2 + 1);
        for (String subdir : subdirs) {
            itemIds.add(new StorageResourceId(resourceId.getBucketName(), subdir));
            if (Strings.isNullOrEmpty(subdir)) continue;
            itemIds.add(new StorageResourceId(resourceId.getBucketName(), StringPaths.toFilePath(subdir)));
        }
        itemIds.add(new StorageResourceId(resourceId.getBucketName()));
        ((GoogleLogger.Api)logger.atFiner()).log("mkdirs: going to create dirs with %s paths", itemIds);
        List<GoogleCloudStorageItemInfo> itemInfos = this.gcs.getItemInfos(itemIds);
        GoogleCloudStorageItemInfo bucketInfo = null;
        ArrayList<StorageResourceId> subdirsToCreate = new ArrayList<StorageResourceId>(subdirs.size());
        for (GoogleCloudStorageItemInfo info : itemInfos) {
            if (info.isBucket()) {
                Preconditions.checkState(bucketInfo == null, "bucketInfo should be null");
                bucketInfo = info;
                continue;
            }
            if (info.getResourceId().isDirectory() && !info.exists()) {
                subdirsToCreate.add(info.getResourceId());
                continue;
            }
            if (info.getResourceId().isDirectory() || !info.exists()) continue;
            throw new FileAlreadyExistsException("Cannot create directories because of existing file: " + info.getResourceId());
        }
        if (!((GoogleCloudStorageItemInfo)Preconditions.checkNotNull(bucketInfo, "bucketInfo should not be null")).exists()) {
            this.gcs.create(bucketInfo.getBucketName());
        }
        this.gcs.createEmptyObjects(subdirsToCreate);
    }

    public void rename(URI src, URI dst) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("rename(src: %s, dst: %s)", (Object)src, (Object)dst);
        Preconditions.checkNotNull(src);
        Preconditions.checkNotNull(dst);
        Preconditions.checkArgument(!src.equals(GCS_ROOT), "Root path cannot be renamed.");
        URI dstParent = UriPaths.getParentPath(dst);
        ArrayList<URI> paths = new ArrayList<URI>();
        paths.add(src);
        paths.add(dst);
        if (dstParent != null) {
            paths.add(dstParent);
        }
        List<FileInfo> fileInfos = this.getFileInfos(paths);
        FileInfo srcInfo = fileInfos.get(0);
        FileInfo dstInfo = fileInfos.get(1);
        src = srcInfo.getPath();
        dst = dstInfo.getPath();
        if (!srcInfo.exists()) {
            throw new FileNotFoundException("Item not found: " + src);
        }
        Optional<CoopLockOperationRename> coopLockOp = this.options.isCooperativeLockingEnabled() && src.getAuthority().equals(dst.getAuthority()) && srcInfo.isDirectory() ? Optional.of(CoopLockOperationRename.create(this.gcs, src, dst)) : Optional.empty();
        coopLockOp.ifPresent(CoopLockOperationRename::lock);
        if (coopLockOp.isPresent()) {
            fileInfos = this.getFileInfos(paths);
            srcInfo = fileInfos.get(0);
            dstInfo = fileInfos.get(1);
            if (!srcInfo.exists()) {
                coopLockOp.ifPresent(CoopLockOperationRename::unlock);
                throw new FileNotFoundException("Item not found: " + src);
            }
            if (!srcInfo.isDirectory()) {
                coopLockOp.ifPresent(CoopLockOperationRename::unlock);
                coopLockOp = Optional.empty();
            }
        }
        FileInfo dstParentInfo = dstParent == null ? null : fileInfos.get(2);
        try {
            dst = this.getDstUri(srcInfo, dstInfo, dstParentInfo);
        }
        catch (IOException e) {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            throw e;
        }
        if (src.equals(dst)) {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            return;
        }
        Future<GoogleCloudStorageItemInfo> srcParentInfoFuture = null;
        if (this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled()) {
            StorageResourceId srcParentId = StorageResourceId.fromUriPath(UriPaths.getParentPath(src), true);
            srcParentInfoFuture = this.cachedExecutor.submit(() -> this.getFileInfoInternal(srcParentId, false));
        }
        if (srcInfo.isDirectory()) {
            this.renameDirectoryInternal(srcInfo, dst, coopLockOp);
        } else {
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
            StorageResourceId srcResourceId = StorageResourceId.fromUriPath(src, true);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(dst, true);
            this.gcs.copy(srcResourceId.getBucketName(), ImmutableList.of(srcResourceId.getObjectName()), dstResourceId.getBucketName(), ImmutableList.of(dstResourceId.getObjectName()));
            this.gcs.deleteObjects(ImmutableList.of(new StorageResourceId(srcInfo.getItemInfo().getBucketName(), srcInfo.getItemInfo().getObjectName(), srcInfo.getItemInfo().getContentGeneration())));
        }
        this.repairImplicitDirectory(srcParentInfoFuture);
    }

    private URI getDstUri(FileInfo srcInfo, FileInfo dstInfo, @Nullable FileInfo dstParentInfo) throws IOException {
        URI src = srcInfo.getPath();
        URI dst = dstInfo.getPath();
        if (!srcInfo.isDirectory() && dst.equals(GCS_ROOT)) {
            throw new IOException("A file cannot be created in root.");
        }
        if (dstInfo.exists() && !dstInfo.isDirectory() && (srcInfo.isDirectory() || !dst.equals(src))) {
            throw new IOException("Cannot overwrite an existing file: " + dst);
        }
        if (dstParentInfo != null && !dstParentInfo.exists()) {
            throw new IOException("Cannot rename because path does not exist: " + dstParentInfo.getPath());
        }
        String srcItemName = this.getItemName(src);
        if (srcInfo.isDirectory()) {
            if (!dstInfo.isDirectory()) {
                dst = UriPaths.toDirectory(dst);
                dstInfo = this.getFileInfo(dst);
            }
            if (src.equals(dst)) {
                throw new IOException("Rename dir to self is forbidden");
            }
            URI dstRelativeToSrc = src.relativize(dst);
            if (!dstRelativeToSrc.equals(dst)) {
                throw new IOException("Rename to subdir is forbidden");
            }
            if (dstInfo.exists()) {
                dst = dst.equals(GCS_ROOT) ? UriPaths.fromStringPathComponents(srcItemName, null, true) : UriPaths.toDirectory(dst.resolve(srcItemName));
            }
        } else if (dstInfo.isDirectory()) {
            if (!dstInfo.exists()) {
                throw new IOException("Cannot rename because path does not exist: " + dstInfo.getPath());
            }
            dst = dst.resolve(srcItemName);
        } else {
            URI dstDir = UriPaths.toDirectory(dst);
            FileInfo dstDirInfo = this.getFileInfo(dstDir);
            if (dstDirInfo.exists()) {
                dst = dstDir.resolve(srcItemName);
            }
        }
        return dst;
    }

    public void compose(List<URI> sources, URI destination, String contentType) throws IOException {
        StorageResourceId destResource = StorageResourceId.fromStringPath(destination.toString());
        List<String> sourceObjects = Lists.transform(sources, uri -> StorageResourceId.fromStringPath(uri.toString()).getObjectName());
        this.gcs.compose(destResource.getBucketName(), sourceObjects, destResource.getObjectName(), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameDirectoryInternal(FileInfo srcInfo, URI dst, Optional<CoopLockOperationRename> coopLockOp) throws IOException {
        Preconditions.checkArgument(srcInfo.isDirectory(), "'%s' should be a directory", (Object)srcInfo);
        Preconditions.checkArgument(dst.toString().endsWith("/"), "'%s' should be a directory", (Object)dst);
        URI src = srcInfo.getPath();
        TreeMap<FileInfo, URI> srcToDstItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        TreeMap<FileInfo, URI> srcToDstMarkerItemNames = new TreeMap<FileInfo, URI>(FILE_INFO_PATH_COMPARATOR);
        List<FileInfo> srcItemInfos = this.listAllFileInfoForPrefix(src);
        Pattern markerFilePattern = this.options.getMarkerFilePattern();
        String prefix = src.toString();
        for (FileInfo srcItemInfo : srcItemInfos) {
            String relativeItemName = srcItemInfo.getPath().toString().substring(prefix.length());
            URI dstItemName = dst.resolve(relativeItemName);
            if (markerFilePattern != null && markerFilePattern.matcher(relativeItemName).matches()) {
                srcToDstMarkerItemNames.put(srcItemInfo, dstItemName);
                continue;
            }
            srcToDstItemNames.put(srcItemInfo, dstItemName);
        }
        coopLockOp.ifPresent(o -> o.persistAndScheduleRenewal(srcToDstItemNames, srcToDstMarkerItemNames));
        try {
            this.mkdir(dst);
            this.copyInternal(srcToDstItemNames);
            this.copyInternal(srcToDstMarkerItemNames);
            coopLockOp.ifPresent(CoopLockOperationRename::checkpoint);
            ArrayList<FileInfo> bucketsToDelete = new ArrayList<FileInfo>(1);
            ArrayList<FileInfo> srcItemsToDelete = new ArrayList<FileInfo>(srcToDstItemNames.size() + 1);
            srcItemsToDelete.addAll(srcToDstItemNames.keySet());
            if (srcInfo.getItemInfo().isBucket()) {
                bucketsToDelete.add(srcInfo);
            } else {
                srcItemsToDelete.add(srcInfo);
            }
            this.deleteInternal(new ArrayList<FileInfo>(srcToDstMarkerItemNames.keySet()), new ArrayList<FileInfo>());
            this.deleteInternal(srcItemsToDelete, bucketsToDelete);
            coopLockOp.ifPresent(CoopLockOperationRename::unlock);
        }
        finally {
            coopLockOp.ifPresent(CoopLockOperationRename::cancelRenewal);
        }
    }

    private void copyInternal(Map<FileInfo, URI> srcToDstItemNames) throws IOException {
        if (srcToDstItemNames.isEmpty()) {
            return;
        }
        String srcBucketName = null;
        String dstBucketName = null;
        ArrayList<String> srcObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        ArrayList<String> dstObjectNames = new ArrayList<String>(srcToDstItemNames.size());
        for (Map.Entry<FileInfo, URI> srcToDstItemName : srcToDstItemNames.entrySet()) {
            StorageResourceId srcResourceId = srcToDstItemName.getKey().getItemInfo().getResourceId();
            srcBucketName = srcResourceId.getBucketName();
            String srcObjectName = srcResourceId.getObjectName();
            srcObjectNames.add(srcObjectName);
            StorageResourceId dstResourceId = StorageResourceId.fromUriPath(srcToDstItemName.getValue(), true);
            dstBucketName = dstResourceId.getBucketName();
            String dstObjectName = dstResourceId.getObjectName();
            dstObjectNames.add(dstObjectName);
        }
        this.gcs.copy(srcBucketName, srcObjectNames, dstBucketName, dstObjectNames);
    }

    public List<URI> listFileNames(FileInfo fileInfo) throws IOException {
        return this.listFileNames(fileInfo, false);
    }

    public List<URI> listFileNames(FileInfo fileInfo, boolean recursive) throws IOException {
        Preconditions.checkNotNull(fileInfo);
        URI path = fileInfo.getPath();
        ((GoogleLogger.Api)logger.atFiner()).log("listFileNames(path: %s, recursive: %s)", (Object)path, recursive);
        ArrayList<URI> paths = new ArrayList<URI>();
        if (fileInfo.isDirectory()) {
            if (fileInfo.exists()) {
                if (fileInfo.isGlobalRoot()) {
                    List<String> childNames = this.gcs.listBucketNames();
                    for (String childName : childNames) {
                        URI childPath = UriPaths.fromStringPathComponents(childName, null, true);
                        paths.add(childPath);
                        ((GoogleLogger.Api)logger.atFinest()).log("listFileNames: added %s path", childPath);
                    }
                } else {
                    String delimiter = recursive ? null : "/";
                    GoogleCloudStorageItemInfo itemInfo = fileInfo.getItemInfo();
                    List<String> childNames = this.gcs.listObjectNames(itemInfo.getBucketName(), itemInfo.getObjectName(), delimiter);
                    for (String childName : childNames) {
                        URI childPath = UriPaths.fromStringPathComponents(itemInfo.getBucketName(), childName, false);
                        paths.add(childPath);
                        ((GoogleLogger.Api)logger.atFinest()).log("listFileNames: added %s path", childPath);
                    }
                }
            }
        } else {
            paths.add(path);
            ((GoogleLogger.Api)logger.atFinest()).log("listFileNames: added a single original path for %s file", path);
        }
        return paths;
    }

    private void repairImplicitDirectory(Future<GoogleCloudStorageItemInfo> infoFuture) throws IOException {
        if (infoFuture == null) {
            return;
        }
        Preconditions.checkState(this.options.getCloudStorageOptions().isAutoRepairImplicitDirectoriesEnabled(), "implicit directories auto repair should be enabled");
        GoogleCloudStorageItemInfo info = GoogleCloudStorageFileSystem.getFromFuture(infoFuture);
        StorageResourceId resourceId = info.getResourceId();
        ((GoogleLogger.Api)logger.atFinest()).log("repairImplicitDirectory(resourceId: %s)", resourceId);
        if (info.exists() || resourceId.isRoot() || resourceId.isBucket() || "/".equals(resourceId.getObjectName())) {
            return;
        }
        Preconditions.checkState(resourceId.isDirectory(), "'%s' should be a directory", (Object)resourceId);
        try {
            this.gcs.createEmptyObject(resourceId);
            ((GoogleLogger.Api)logger.atInfo()).log("Successfully repaired '%s' directory.", resourceId);
        }
        catch (IOException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atWarning()).withCause(e)).log("Failed to repair '%s' directory", resourceId);
        }
    }

    private static <T> T getFromFuture(Future<T> future) throws IOException {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Failed to get info from future", e);
        }
    }

    public List<FileInfo> listAllFileInfoForPrefix(URI prefix) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("listAllFileInfoForPrefixPage(prefix: %s)", prefix);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        List<GoogleCloudStorageItemInfo> itemInfos = this.gcs.listObjectInfo(prefixId.getBucketName(), prefixId.getObjectName(), null);
        List<FileInfo> fileInfos = FileInfo.fromItemInfos(itemInfos);
        fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
        return fileInfos;
    }

    public GoogleCloudStorage.ListPage<FileInfo> listAllFileInfoForPrefixPage(URI prefix, String pageToken) throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("listAllFileInfoForPrefixPage(prefix: %s, pageToken:%s)", (Object)prefix, (Object)pageToken);
        StorageResourceId prefixId = this.getPrefixId(prefix);
        GoogleCloudStorage.ListPage<GoogleCloudStorageItemInfo> itemInfosPage = this.gcs.listObjectInfoPage(prefixId.getBucketName(), prefixId.getObjectName(), null, pageToken);
        List<FileInfo> fileInfosPage = FileInfo.fromItemInfos(itemInfosPage.getItems());
        fileInfosPage.sort(FILE_INFO_PATH_COMPARATOR);
        return new GoogleCloudStorage.ListPage<FileInfo>(fileInfosPage, itemInfosPage.getNextPageToken());
    }

    private StorageResourceId getPrefixId(URI prefix) {
        Preconditions.checkNotNull(prefix, "prefix could not be null");
        StorageResourceId prefixId = StorageResourceId.fromUriPath(prefix, true);
        Preconditions.checkArgument(!prefixId.isRoot(), "prefix must not be global root, got '%s'", (Object)prefix);
        return prefixId;
    }

    public List<FileInfo> listFileInfo(URI path) throws IOException {
        Preconditions.checkNotNull(path, "path can not be null");
        ((GoogleLogger.Api)logger.atFinest()).log("listFileInfo(path: %s)", path);
        StorageResourceId pathId = StorageResourceId.fromUriPath(path, true);
        StorageResourceId dirId = StorageResourceId.fromUriPath(UriPaths.toDirectory(path), true);
        ExecutorService dirExecutor = this.options.isStatusParallelEnabled() ? Executors.newFixedThreadPool(2, DAEMON_THREAD_FACTORY) : new LazyExecutorService();
        try {
            GoogleCloudStorageItemInfo pathInfo;
            Future<GoogleCloudStorageItemInfo> dirFuture = dirExecutor.submit(() -> this.gcs.getItemInfo(dirId));
            Future<List> dirChildrenFutures = dirExecutor.submit(() -> dirId.isRoot() ? this.gcs.listBucketInfo() : this.gcs.listObjectInfo(dirId.getBucketName(), dirId.getObjectName(), "/"));
            dirExecutor.shutdown();
            if (!pathId.isDirectory() && (pathInfo = this.gcs.getItemInfo(pathId)).exists()) {
                ArrayList<FileInfo> listedInfo = new ArrayList<FileInfo>();
                listedInfo.add(FileInfo.fromItemInfo(pathInfo));
                ArrayList<FileInfo> arrayList = listedInfo;
                return arrayList;
            }
            GoogleCloudStorageItemInfo dirInfo = dirFuture.get();
            List dirItemInfos = dirChildrenFutures.get();
            if (!dirInfo.exists() && dirItemInfos.isEmpty()) {
                throw new FileNotFoundException("Item not found: " + path);
            }
            List<FileInfo> fileInfos = FileInfo.fromItemInfos(dirItemInfos);
            fileInfos.sort(FILE_INFO_PATH_COMPARATOR);
            List<FileInfo> list = fileInfos;
            return list;
        }
        finally {
            dirExecutor.shutdownNow();
        }
    }

    public FileInfo getFileInfo(URI path) throws IOException {
        Preconditions.checkArgument(path != null, "path must not be null");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        FileInfo fileInfo = FileInfo.fromItemInfo(this.getFileInfoInternal(resourceId, this.gcs.getOptions().isInferImplicitDirectoriesEnabled()));
        ((GoogleLogger.Api)logger.atFinest()).log("getFileInfo(path: %s): %s", (Object)path, (Object)fileInfo);
        return fileInfo;
    }

    private GoogleCloudStorageItemInfo getFileInfoInternal(StorageResourceId resourceId, boolean inferImplicitDirectories) throws IOException {
        if (resourceId.isRoot() || resourceId.isBucket()) {
            return this.gcs.getItemInfo(resourceId);
        }
        StorageResourceId dirId = resourceId.toDirectoryId();
        LazyExecutorService dirExecutor = this.options.isStatusParallelEnabled() ? (resourceId.isDirectory() ? Executors.newSingleThreadExecutor(DAEMON_THREAD_FACTORY) : Executors.newFixedThreadPool(2, DAEMON_THREAD_FACTORY)) : new LazyExecutorService();
        try {
            GoogleCloudStorageItemInfo itemInfo;
            Future<List> dirChildFuture = dirExecutor.submit(() -> this.gcs.listObjectNames(dirId.getBucketName(), dirId.getObjectName(), "/", 1L));
            Future<GoogleCloudStorageItemInfo> dirFuture = resourceId.isDirectory() ? Futures.immediateFuture(this.gcs.getItemInfo(resourceId)) : dirExecutor.submit(() -> this.gcs.getItemInfo(dirId));
            dirExecutor.shutdown();
            if (!resourceId.isDirectory() && (itemInfo = this.gcs.getItemInfo(resourceId)).exists()) {
                GoogleCloudStorageItemInfo googleCloudStorageItemInfo = itemInfo;
                return googleCloudStorageItemInfo;
            }
            GoogleCloudStorageItemInfo dirInfo = dirFuture.get();
            if (dirInfo.exists()) {
                GoogleCloudStorageItemInfo googleCloudStorageItemInfo = dirInfo;
                return googleCloudStorageItemInfo;
            }
            if (dirChildFuture.get().isEmpty()) {
                GoogleCloudStorageItemInfo googleCloudStorageItemInfo = GoogleCloudStorageItemInfo.createNotFound(resourceId);
                return googleCloudStorageItemInfo;
            }
            GoogleCloudStorageItemInfo googleCloudStorageItemInfo = inferImplicitDirectories ? GoogleCloudStorageItemInfo.createInferredDirectory(dirId) : GoogleCloudStorageItemInfo.createNotFound(dirId);
            return googleCloudStorageItemInfo;
        }
        finally {
            dirExecutor.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileInfo> getFileInfos(List<URI> paths) throws IOException {
        Preconditions.checkArgument(paths != null, "paths must not be null");
        ((GoogleLogger.Api)logger.atFinest()).log("getFileInfos(paths: %s)", paths);
        if (paths.size() == 1) {
            return new ArrayList<FileInfo>(Collections.singleton(this.getFileInfo(paths.get(0))));
        }
        int maxThreads = this.gcs.getOptions().getBatchThreads();
        ListeningExecutorService fileInfoExecutor = maxThreads == 0 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(Math.min(maxThreads, paths.size()), DAEMON_THREAD_FACTORY);
        try {
            ArrayList<Future<FileInfo>> infoFutures = new ArrayList<Future<FileInfo>>(paths.size());
            for (URI path : paths) {
                infoFutures.add(fileInfoExecutor.submit(() -> this.getFileInfo(path)));
            }
            fileInfoExecutor.shutdown();
            ArrayList infos = new ArrayList(paths.size());
            for (Future future : infoFutures) {
                try {
                    infos.add(future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    throw new IOException(String.format("Failed to getFileInfos for %d paths", paths.size()), e);
                }
            }
            ArrayList arrayList = infos;
            return arrayList;
        }
        finally {
            fileInfoExecutor.shutdownNow();
        }
    }

    public void close() {
        if (this.gcs == null) {
            return;
        }
        ((GoogleLogger.Api)logger.atFine()).log("close()");
        try {
            this.cachedExecutor.shutdown();
            this.gcs.close();
        }
        finally {
            this.cachedExecutor = null;
            this.gcs = null;
        }
    }

    @VisibleForTesting
    public void mkdir(URI path) throws IOException {
        Preconditions.checkNotNull(path);
        ((GoogleLogger.Api)logger.atFine()).log("mkdir(path: %s)", path);
        Preconditions.checkArgument(!path.equals(GCS_ROOT), "Cannot create root directory.");
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            this.gcs.create(resourceId.getBucketName());
            return;
        }
        resourceId = resourceId.toDirectoryId();
        this.gcs.createEmptyObject(resourceId);
    }

    static List<String> getSubDirs(String objectName) {
        ArrayList<String> subdirs = new ArrayList<String>();
        if (!Strings.isNullOrEmpty(objectName)) {
            int index;
            int currentIndex = 0;
            while (currentIndex < objectName.length() && (index = objectName.indexOf("/", currentIndex)) >= 0) {
                subdirs.add(objectName.substring(0, index + "/".length()));
                currentIndex = index + "/".length();
            }
        }
        return subdirs;
    }

    String getItemName(URI path) {
        Preconditions.checkNotNull(path);
        if (path.equals(GCS_ROOT)) {
            return null;
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath(path, true);
        if (resourceId.isBucket()) {
            return resourceId.getBucketName();
        }
        String objectName = resourceId.getObjectName();
        int index = StringPaths.isDirectoryPath(objectName) ? objectName.lastIndexOf("/", objectName.length() - 2) : objectName.lastIndexOf("/");
        return index < 0 ? objectName : objectName.substring(index + 1);
    }

    public GoogleCloudStorage getGcs() {
        return this.gcs;
    }
}

