/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.FileSystemDescriptor;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFSInputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopOutputStream;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopSyncableOutputStream;
import com.google.cloud.hadoop.fs.gcs.InMemoryGlobberFileSystem;
import com.google.cloud.hadoop.fs.gcs.auth.GcsDelegationTokens;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.CreateFileOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.FileInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UpdatableItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialFromAccessTokenProviderClassFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.PropertyUtil;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Suppliers;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableSet;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Lists;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Maps;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.Sets;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.LazyArgs;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.cloud.hadoop.repackaged.gcs.org.apache.commons.codec.binary.Hex;
import com.google.cloud.hadoop.util.AccessTokenProvider;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.GlobPattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenIdentifier;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.util.Progressable;

public abstract class GoogleHadoopFileSystemBase
extends FileSystem
implements FileSystemDescriptor {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final short REPLICATION_FACTOR_DEFAULT = 3;
    public static final PathFilter DEFAULT_FILTER = path -> true;
    public static final String PROPERTIES_FILE = "gcs.properties";
    public static final String VERSION_PROPERTY = "gcs.connector.version";
    public static final String UNKNOWN_VERSION = "0.0.0";
    public static final String VERSION = PropertyUtil.getPropertyOrDefault(GoogleHadoopFileSystemBase.class, "gcs.properties", "gcs.connector.version", "0.0.0");
    public static final String GHFS_ID;
    private static final String XATTR_KEY_PREFIX = "GHFS_XATTR_";
    private static final byte[] XATTR_NULL_VALUE;
    private static final ThreadFactory DAEMON_THREAD_FACTORY;
    @VisibleForTesting
    boolean enableFlatGlob = (Boolean)GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.getDefault();
    @VisibleForTesting
    boolean enableConcurrentGlob = (Boolean)GoogleHadoopFileSystemConfiguration.GCS_CONCURRENT_GLOB_ENABLE.getDefault();
    private GcsFileChecksumType checksumType = (GcsFileChecksumType)((Object)GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.getDefault());
    protected URI initUri;
    protected GcsDelegationTokens delegationTokens = null;
    private Supplier<GoogleCloudStorageFileSystem> gcsFsSupplier;
    private boolean gcsFsInitialized = false;
    private Path workingDirectory;
    protected long defaultBlockSize = (Long)GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.getDefault();
    private FsPermission reportedPermissions;
    protected final ImmutableMap<Counter, AtomicLong> counters = this.createCounterMap();
    private static final ImmutableSet<Counter> ALL_COUNTERS;

    protected ImmutableMap<Counter, AtomicLong> createCounterMap() {
        EnumMap<Counter, AtomicLong> countersMap = new EnumMap<Counter, AtomicLong>(Counter.class);
        for (Counter counter : ALL_COUNTERS) {
            countersMap.put(counter, new AtomicLong());
        }
        return Maps.immutableEnumMap(countersMap);
    }

    public GoogleHadoopFileSystemBase() {
    }

    GoogleHadoopFileSystemBase(GoogleCloudStorageFileSystem gcsFs) {
        Preconditions.checkNotNull(gcsFs, "gcsFs must not be null");
        this.setGcsFs(gcsFs);
    }

    private void setGcsFs(GoogleCloudStorageFileSystem gcsFs) {
        this.gcsFsSupplier = Suppliers.ofInstance(gcsFs);
        this.gcsFsInitialized = true;
    }

    protected abstract String getHomeDirectorySubpath();

    public abstract Path getHadoopPath(URI var1);

    public abstract URI getGcsPath(Path var1);

    public abstract Path getDefaultWorkingDirectory();

    @Override
    public abstract Path getFileSystemRoot();

    @Override
    public abstract String getScheme();

    public Path makeQualified(Path path) {
        Path qualifiedPath = super.makeQualified(path);
        URI uri = qualifiedPath.toUri();
        Preconditions.checkState("".equals(uri.getPath()) || qualifiedPath.isAbsolute(), "Path '%s' must be fully qualified.", (Object)qualifiedPath);
        StringBuilder sb = new StringBuilder(uri.getPath());
        while (sb.indexOf("/../") == 0) {
            sb.delete(0, 3);
        }
        String strippedPath = sb.toString();
        if (strippedPath.equals("/..") || strippedPath.equals("")) {
            strippedPath = "/";
        }
        Path result = new Path(uri.getScheme(), uri.getAuthority(), strippedPath);
        ((GoogleLogger.Api)logger.atFinest()).log("makeQualified(path: %s): %s", (Object)path, (Object)result);
        return result;
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if (scheme == null || scheme.equalsIgnoreCase(this.getScheme())) {
            return;
        }
        String msg = String.format("Wrong FS scheme: %s, in path: %s, expected scheme: %s", scheme, path, this.getScheme());
        throw new IllegalArgumentException(msg);
    }

    public void initialize(URI path, Configuration config) throws IOException {
        this.initialize(path, config, true);
    }

    public void initialize(URI path, Configuration config, boolean initSuperclass) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(path != null, "path must not be null");
        Preconditions.checkArgument(config != null, "config must not be null");
        Preconditions.checkArgument(path.getScheme() != null, "scheme of path must not be null");
        if (!path.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException("URI scheme not supported: " + path);
        }
        this.initUri = path;
        ((GoogleLogger.Api)logger.atFine()).log("initialize(path: %s, config: %s, initSuperclass: %b)", path, config, initSuperclass);
        if (initSuperclass) {
            super.initialize(path, config);
        } else {
            ((GoogleLogger.Api)logger.atFiner()).log("Initializing 'statistics' as an instance not attached to the static FileSystem map");
            this.statistics = new FileSystem.Statistics(this.getScheme());
        }
        this.setConf(config);
        this.initializeDelegationTokenSupport(config, path);
        this.configure(config);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.INIT);
        this.increment(Counter.INIT_TIME, duration);
    }

    private void initializeDelegationTokenSupport(Configuration config, URI path) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("initializeDelegationTokenSupport(config: %s, path: %s)", (Object)config, (Object)path);
        GcsDelegationTokens dts = new GcsDelegationTokens();
        Text service = new Text(this.getScheme() + "://" + path.getAuthority());
        dts.bindToFileSystem(this, service);
        try {
            dts.init(config);
            dts.start();
            this.delegationTokens = dts;
            if (this.delegationTokens.isBoundToDT()) {
                ((GoogleLogger.Api)logger.atFine()).log("initializeDelegationTokenSupport(config: %s, path: %s): using existing delegation token", (Object)config, (Object)path);
            }
        }
        catch (IllegalStateException | ServiceStateException e) {
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("Failed to initialize delegation token support");
        }
    }

    private void stopDelegationTokens() {
        if (this.delegationTokens != null) {
            try {
                this.delegationTokens.close();
            }
            catch (IOException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause(e)).log("Failed to stop delegation tokens support");
            }
        }
    }

    public URI getUri() {
        return this.getFileSystemRoot().toUri();
    }

    protected int getDefaultPort() {
        int result = -1;
        ((GoogleLogger.Api)logger.atFinest()).log("getDefaultPort(): %d", result);
        return result;
    }

    public FSDataInputStream open(Path hadoopPath, int bufferSize) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFiner()).log("open(hadoopPath: %s, bufferSize: %d [ignored])", (Object)hadoopPath, bufferSize);
        URI gcsPath = this.getGcsPath(hadoopPath);
        GoogleCloudStorageReadOptions readChannelOptions = this.getGcsFs().getOptions().getCloudStorageOptions().getReadChannelOptions();
        GoogleHadoopFSInputStream in = new GoogleHadoopFSInputStream(this, gcsPath, readChannelOptions, this.statistics);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.OPEN);
        this.increment(Counter.OPEN_TIME, duration);
        return new FSDataInputStream((InputStream)((Object)in));
    }

    public FSDataOutputStream create(Path hadoopPath, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        OutputStream out;
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        Preconditions.checkArgument(replication > 0, "replication must be a positive integer: %s", replication);
        Preconditions.checkArgument(blockSize > 0L, "blockSize must be a positive integer: %s", blockSize);
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFiner()).log("create(hadoopPath: %s, overwrite: %b, bufferSize: %d [ignored])", hadoopPath, overwrite, bufferSize);
        URI gcsPath = this.getGcsPath(hadoopPath);
        OutputStreamType type = GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.get(this.getConf(), (arg_0, arg_1) -> ((Configuration)this.getConf()).getEnum(arg_0, arg_1));
        switch (type) {
            case BASIC: {
                out = new GoogleHadoopOutputStream(this, gcsPath, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            case SYNCABLE_COMPOSITE: {
                out = new GoogleHadoopSyncableOutputStream(this, gcsPath, this.statistics, new CreateFileOptions(overwrite));
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported output stream type given for key '%s': '%s'", new Object[]{GoogleHadoopFileSystemConfiguration.GCS_OUTPUT_STREAM_TYPE.getKey(), type}));
            }
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.CREATE);
        this.increment(Counter.CREATE_TIME, duration);
        return new FSDataOutputStream(out, null);
    }

    public FSDataOutputStream createNonRecursive(Path hadoopPath, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        URI gcsPath = this.getGcsPath(Preconditions.checkNotNull(hadoopPath, "hadoopPath must not be null"));
        URI parentGcsPath = UriPaths.getParentPath(gcsPath);
        GoogleCloudStorageItemInfo parentInfo = this.getGcsFs().getFileInfo(parentGcsPath).getItemInfo();
        if (!(parentInfo.isRoot() || parentInfo.isBucket() || parentInfo.exists())) {
            throw new FileNotFoundException(String.format("Can not create '%s' file, because parent folder does not exist: %s", gcsPath, parentGcsPath));
        }
        return this.create(hadoopPath, permission, flags.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream append(Path hadoopPath, int bufferSize, Progressable progress) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        ((GoogleLogger.Api)logger.atFiner()).log("append(hadoopPath: %s, bufferSize: %d [ignored])", (Object)hadoopPath, bufferSize);
        URI filePath = this.getGcsPath(hadoopPath);
        FSDataOutputStream appendStream = new FSDataOutputStream((OutputStream)new GoogleHadoopSyncableOutputStream(this, filePath, this.statistics, CreateFileOptions.DEFAULT_NO_OVERWRITE, true), this.statistics);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.APPEND);
        this.increment(Counter.APPEND_TIME, duration);
        return appendStream;
    }

    public void concat(Path tgt, Path[] srcs) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("concat(tgt: %s, srcs: %s)", (Object)tgt, LazyArgs.lazy(() -> Arrays.toString(srcs)));
        Preconditions.checkArgument(srcs.length > 0, "srcs must have at least one source");
        URI tgtPath = this.getGcsPath(tgt);
        List srcPaths = Arrays.stream(srcs).map(this::getGcsPath).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument(!srcPaths.contains(tgtPath), "target must not be contained in sources");
        List partitions = Lists.partition(srcPaths, 31);
        ((GoogleLogger.Api)logger.atFinest()).log("concat(tgt: %s, %d partitions: %s)", tgt, partitions.size(), partitions);
        for (List partition : partitions) {
            ArrayList<URI> sources = Lists.newArrayList(tgtPath);
            sources.addAll(partition);
            this.getGcsFs().compose(sources, tgtPath, "application/octet-stream");
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        Preconditions.checkArgument(src != null, "src must not be null");
        Preconditions.checkArgument(dst != null, "dst must not be null");
        if (src.makeQualified((FileSystem)this).equals((Object)this.getFileSystemRoot())) {
            ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s): false [src is a root]", (Object)src, (Object)dst);
            return false;
        }
        try {
            this.renameInternal(src, dst);
        }
        catch (IOException e) {
            if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                throw e;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("rename(src: %s, dst: %s): false [failed]", (Object)src, (Object)dst);
            return false;
        }
        return true;
    }

    void renameInternal(Path src, Path dst) throws IOException {
        Preconditions.checkArgument(src != null, "src must not be null");
        Preconditions.checkArgument(dst != null, "dst must not be null");
        long startTime = System.nanoTime();
        this.checkOpen();
        URI srcPath = this.getGcsPath(src);
        URI dstPath = this.getGcsPath(dst);
        this.getGcsFs().rename(srcPath, dstPath);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.RENAME);
        this.increment(Counter.RENAME_TIME, duration);
        ((GoogleLogger.Api)logger.atFiner()).log("rename(src: %s, dst: %s): true", (Object)src, (Object)dst);
    }

    public boolean delete(Path hadoopPath, boolean recursive) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.getGcsFs().delete(gcsPath, recursive);
        }
        catch (DirectoryNotEmptyException e) {
            throw e;
        }
        catch (IOException e) {
            if (ApiErrorExtractor.INSTANCE.requestFailure(e)) {
                throw e;
            }
            ((GoogleLogger.Api)((GoogleLogger.Api)logger.atFiner()).withCause(e)).log("delete(hadoopPath: %s, recursive: %b): false [failed]", (Object)hadoopPath, recursive);
            return false;
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.DELETE);
        this.increment(Counter.DELETE_TIME, duration);
        ((GoogleLogger.Api)logger.atFiner()).log("delete(hadoopPath: %s, recursive: %b): true", (Object)hadoopPath, recursive);
        return true;
    }

    public FileStatus[] listStatus(Path hadoopPath) throws IOException {
        ArrayList<FileStatus> status;
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFinest()).log("listStatus(hadoopPath: %s)", hadoopPath);
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            List<FileInfo> fileInfos = this.getGcsFs().listFileInfo(gcsPath);
            status = new ArrayList<FileStatus>(fileInfos.size());
            String userName = GoogleHadoopFileSystemBase.getUgiUserName();
            for (FileInfo fileInfo : fileInfos) {
                status.add(this.getFileStatus(fileInfo, userName));
            }
        }
        catch (FileNotFoundException fnfe) {
            throw (FileNotFoundException)new FileNotFoundException(String.format("listStatus(hadoopPath: %s): '%s' does not exist.", hadoopPath, gcsPath)).initCause(fnfe);
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.LIST_STATUS);
        this.increment(Counter.LIST_STATUS_TIME, duration);
        return status.toArray(new FileStatus[0]);
    }

    public void setWorkingDirectory(Path hadoopPath) {
        Path newPath;
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        URI gcsPath = UriPaths.toDirectory(this.getGcsPath(hadoopPath));
        this.workingDirectory = newPath = this.getHadoopPath(gcsPath);
        ((GoogleLogger.Api)logger.atFinest()).log("setWorkingDirectory(hadoopPath: %s): %s", (Object)hadoopPath, (Object)this.workingDirectory);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.SET_WD);
        this.increment(Counter.SET_WD_TIME, duration);
    }

    public Path getWorkingDirectory() {
        ((GoogleLogger.Api)logger.atFinest()).log("getWorkingDirectory(): %s", this.workingDirectory);
        return this.workingDirectory;
    }

    public boolean mkdirs(Path hadoopPath, FsPermission permission) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        try {
            this.getGcsFs().mkdirs(gcsPath);
        }
        catch (java.nio.file.FileAlreadyExistsException faee) {
            throw (FileAlreadyExistsException)new FileAlreadyExistsException(String.format("mkdirs(hadoopPath: %s, permission: %s): failed", hadoopPath, permission)).initCause((Throwable)faee);
        }
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.MKDIRS);
        this.increment(Counter.MKDIRS_TIME, duration);
        ((GoogleLogger.Api)logger.atFiner()).log("mkdirs(hadoopPath: %s, permission: %s): true", (Object)hadoopPath, (Object)permission);
        return true;
    }

    public short getDefaultReplication() {
        return 3;
    }

    public FileStatus getFileStatus(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.getGcsFs().getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            throw new FileNotFoundException(String.format("%s not found: %s", fileInfo.isDirectory() ? "Directory" : "File", hadoopPath));
        }
        String userName = GoogleHadoopFileSystemBase.getUgiUserName();
        FileStatus status = this.getFileStatus(fileInfo, userName);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_STATUS);
        this.increment(Counter.GET_FILE_STATUS_TIME, duration);
        return status;
    }

    private FileStatus getFileStatus(FileInfo fileInfo, String userName) throws IOException {
        FileStatus status = new FileStatus(fileInfo.getSize(), fileInfo.isDirectory(), 3, this.defaultBlockSize, fileInfo.getModificationTime(), fileInfo.getModificationTime(), this.reportedPermissions, userName, userName, this.getHadoopPath(fileInfo.getPath()));
        ((GoogleLogger.Api)logger.atFinest()).log("getFileStatus(path: %s, userName: %s): %s", fileInfo.getPath(), userName, LazyArgs.lazy(() -> GoogleHadoopFileSystemBase.fileStatusToString(status)));
        return status;
    }

    @VisibleForTesting
    boolean couldUseFlatGlob(Path fixedPath) {
        if (!this.getUri().getScheme().equals("gs")) {
            ((GoogleLogger.Api)logger.atFinest()).log("Flat glob is on, but doesn't work for scheme '%s', using default behavior.", this.getUri().getScheme());
            return false;
        }
        GlobPattern fullPattern = new GlobPattern(fixedPath.toString());
        if (!fullPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atFinest()).log("Flat glob is on, but Path '%s' has no wildcard, using default behavior.", fixedPath);
            return false;
        }
        if (Strings.isNullOrEmpty(fixedPath.toUri().getAuthority())) {
            ((GoogleLogger.Api)logger.atFinest()).log("Flat glob is on, but Path '%s' has a empty authority, using default behavior.", fixedPath);
            return false;
        }
        GlobPattern authorityPattern = new GlobPattern(fixedPath.toUri().getAuthority());
        if (authorityPattern.hasWildcard()) {
            ((GoogleLogger.Api)logger.atFinest()).log("Flat glob is on, but Path '%s' has a wildcard authority, using default behavior.", fixedPath);
            return false;
        }
        return true;
    }

    @VisibleForTesting
    String trimToPrefixWithoutGlob(String path) {
        char[] wildcardChars = "*?{[".toCharArray();
        int trimIndex = path.length();
        for (char wildcard : wildcardChars) {
            int wildcardIndex = path.indexOf(wildcard);
            if (wildcardIndex < 0 || wildcardIndex >= trimIndex) continue;
            trimIndex = wildcardIndex;
        }
        return path.substring(0, trimIndex);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.globStatus(pathPattern, DEFAULT_FILTER);
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        this.checkOpen();
        ((GoogleLogger.Api)logger.atFiner()).log("globStatus(pathPattern: %s, filter: %s)", (Object)pathPattern, (Object)filter);
        Path encodedPath = new Path(pathPattern.toUri().toString());
        Path encodedFixedPath = this.getHadoopPath(this.getGcsPath(encodedPath));
        Path fixedPath = new Path(URI.create(encodedFixedPath.toString()));
        ((GoogleLogger.Api)logger.atFinest()).log("fixed path pattern: %s => %s", (Object)pathPattern, (Object)fixedPath);
        if (this.enableConcurrentGlob && this.couldUseFlatGlob(fixedPath)) {
            return this.concurrentGlobInternal(fixedPath, filter);
        }
        if (this.enableFlatGlob && this.couldUseFlatGlob(fixedPath)) {
            return this.flatGlobInternal(fixedPath, filter);
        }
        return super.globStatus(fixedPath, filter);
    }

    private FileStatus[] concurrentGlobInternal(Path fixedPath, PathFilter filter) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(2, DAEMON_THREAD_FACTORY);
        Callable<FileStatus[]> flatGlobTask = () -> this.flatGlobInternal(fixedPath, filter);
        Callable<FileStatus[]> nonFlatGlobTask = () -> super.globStatus(fixedPath, filter);
        try {
            FileStatus[] fileStatusArray = (FileStatus[])executorService.invokeAny(Arrays.asList(flatGlobTask, nonFlatGlobTask));
            return fileStatusArray;
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IOException("Concurrent glob execution failed", e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private FileStatus[] flatGlobInternal(Path fixedPath, PathFilter filter) throws IOException {
        GoogleCloudStorage.ListPage<FileInfo> infoPage;
        String pathString = fixedPath.toString();
        String prefixString = this.trimToPrefixWithoutGlob(pathString);
        Path prefixPath = new Path(prefixString);
        URI prefixUri = this.getGcsPath(prefixPath);
        if (prefixString.endsWith("/") && !prefixPath.toString().endsWith("/")) {
            prefixUri = UriPaths.toDirectory(prefixUri);
        }
        ((GoogleLogger.Api)logger.atFinest()).log("Listing everything with '%s' prefix", prefixUri);
        ArrayList<FileStatus> matchedStatuses = null;
        String pageToken = null;
        do {
            infoPage = this.getGcsFs().listAllFileInfoForPrefixPage(prefixUri, pageToken);
            Collection<FileStatus> statusPage = this.toFileStatusesWithImplicitDirectories(infoPage.getItems());
            FileSystem helperFileSystem = InMemoryGlobberFileSystem.createInstance(this.getConf(), this.getWorkingDirectory(), statusPage);
            FileStatus[] matchedStatusPage = helperFileSystem.globStatus(fixedPath, filter);
            if (matchedStatusPage == null) continue;
            Collections.addAll(matchedStatuses == null ? new ArrayList<FileStatus>() : matchedStatuses, matchedStatusPage);
        } while ((pageToken = infoPage.getNextPageToken()) != null);
        if (matchedStatuses == null || matchedStatuses.isEmpty()) {
            return matchedStatuses == null ? null : new FileStatus[]{};
        }
        matchedStatuses.sort(Comparator.naturalOrder().thenComparingInt(f -> GoogleHadoopFileSystemBase.isImplicitDirectory(f) ? 1 : 0));
        ArrayList<FileStatus> filteredStatuses = new ArrayList<FileStatus>(matchedStatuses.size());
        FileStatus lastAdded = null;
        for (FileStatus fileStatus : matchedStatuses) {
            if (lastAdded != null && lastAdded.compareTo(fileStatus) == 0) continue;
            filteredStatuses.add(fileStatus);
            lastAdded = fileStatus;
        }
        return filteredStatuses.toArray(new FileStatus[0]);
    }

    private static boolean isImplicitDirectory(FileStatus curr) {
        return curr.isDir() && curr.getModificationTime() == 0L;
    }

    private Collection<FileStatus> toFileStatusesWithImplicitDirectories(Collection<FileInfo> fileInfos) throws IOException {
        ArrayList<FileStatus> fileStatuses = new ArrayList<FileStatus>(fileInfos.size());
        HashSet<URI> filePaths = Sets.newHashSetWithExpectedSize(fileInfos.size());
        String userName = GoogleHadoopFileSystemBase.getUgiUserName();
        for (FileInfo fileInfo : fileInfos) {
            filePaths.add(fileInfo.getPath());
            fileStatuses.add(this.getFileStatus(fileInfo, userName));
        }
        for (FileInfo fileInfo : fileInfos) {
            URI parentPath = UriPaths.getParentPath(fileInfo.getPath());
            while (parentPath != null && !parentPath.equals(GoogleCloudStorageFileSystem.GCS_ROOT)) {
                if (!filePaths.contains(parentPath)) {
                    ((GoogleLogger.Api)logger.atFinest()).log("Adding fake entry for missing parent path '%s'", parentPath);
                    StorageResourceId id = StorageResourceId.fromUriPath(parentPath, true);
                    GoogleCloudStorageItemInfo fakeItemInfo = GoogleCloudStorageItemInfo.createInferredDirectory(id);
                    FileInfo fakeFileInfo = FileInfo.fromItemInfo(fakeItemInfo);
                    filePaths.add(parentPath);
                    fileStatuses.add(this.getFileStatus(fakeFileInfo, userName));
                }
                parentPath = UriPaths.getParentPath(parentPath);
            }
        }
        return fileStatuses;
    }

    private static String getUgiUserName() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return ugi.getShortUserName();
    }

    public Path getHomeDirectory() {
        Path result = new Path(this.getFileSystemRoot(), this.getHomeDirectorySubpath());
        ((GoogleLogger.Api)logger.atFinest()).log("getHomeDirectory(): %s", result);
        return result;
    }

    private static String fileStatusToString(FileStatus stat) {
        assert (stat != null);
        return String.format("path: %s, isDir: %s, len: %d, owner: %s", stat.getPath().toString(), stat.isDir(), stat.getLen(), stat.getOwner());
    }

    public String getCanonicalServiceName() {
        String service = null;
        if (this.delegationTokens != null) {
            service = this.delegationTokens.getService().toString();
        }
        ((GoogleLogger.Api)logger.atFinest()).log("getCanonicalServiceName(): %s", service);
        return service;
    }

    public GoogleCloudStorageFileSystem getGcsFs() {
        return this.gcsFsSupplier.get();
    }

    void increment(Counter key) {
        this.increment(key, 1L);
    }

    void increment(Counter key, long value) {
        this.counters.get((Object)key).addAndGet(value);
    }

    @VisibleForTesting
    String countersToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        double numNanoSecPerSec = TimeUnit.SECONDS.toNanos(1L);
        String timeSuffix = "_TIME";
        for (Counter c : Counter.values()) {
            String name = c.toString();
            if (name.endsWith(timeSuffix)) continue;
            long count = this.counters.get((Object)c).get();
            sb.append(String.format("%20s = %d calls\n", name, count));
            String timeCounterName = name + timeSuffix;
            double totalTime = (double)this.counters.get((Object)Enum.valueOf(Counter.class, timeCounterName)).get() / numNanoSecPerSec;
            sb.append(String.format("%20s = %.2f sec\n", timeCounterName, totalTime));
            String avgName = name + " avg.";
            double avg = totalTime / (double)count;
            sb.append(String.format("%20s = %.2f sec / call\n\n", avgName, avg));
        }
        return sb.toString();
    }

    private void logCounters() {
        ((GoogleLogger.Api)logger.atFine()).log("%s", LazyArgs.lazy(this::countersToString));
    }

    private Credential getCredential(Configuration config) throws IOException, GeneralSecurityException {
        Credential credential = null;
        if (this.delegationTokens != null) {
            AccessTokenProvider atp = this.delegationTokens.getAccessTokenProvider();
            if (atp != null) {
                atp.setConf(config);
                credential = CredentialFromAccessTokenProviderClassFactory.credential(atp, CredentialFactory.GCS_SCOPES);
            }
        } else {
            credential = CredentialFromAccessTokenProviderClassFactory.credential(config, ImmutableList.of("fs.gs"), CredentialFactory.GCS_SCOPES);
            if (credential == null) {
                credential = HadoopCredentialConfiguration.getCredentialFactory(config, "fs.gs").getCredential(CredentialFactory.GCS_SCOPES);
            }
        }
        return credential;
    }

    private synchronized void configure(Configuration config) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS_ID=%s: configure(config: %s)", (Object)GHFS_ID, (Object)config);
        this.overrideConfigFromFile(config);
        this.setConf(config);
        this.enableFlatGlob = GoogleHadoopFileSystemConfiguration.GCS_FLAT_GLOB_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1));
        this.enableConcurrentGlob = GoogleHadoopFileSystemConfiguration.GCS_CONCURRENT_GLOB_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1));
        this.checksumType = GoogleHadoopFileSystemConfiguration.GCS_FILE_CHECKSUM_TYPE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1));
        this.defaultBlockSize = GoogleHadoopFileSystemConfiguration.BLOCK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1));
        this.reportedPermissions = new FsPermission(GoogleHadoopFileSystemConfiguration.PERMISSIONS_TO_REPORT.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        if (this.gcsFsSupplier == null) {
            if (GoogleHadoopFileSystemConfiguration.GCS_LAZY_INITIALIZATION_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1)).booleanValue()) {
                this.gcsFsSupplier = Suppliers.memoize(() -> {
                    try {
                        GoogleCloudStorageFileSystem gcsFs = this.createGcsFs(config);
                        this.configureBuckets(gcsFs);
                        this.configureWorkingDirectory(config);
                        this.gcsFsInitialized = true;
                        return gcsFs;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to create GCS FS", e);
                    }
                });
            } else {
                this.setGcsFs(this.createGcsFs(config));
                this.configureBuckets(this.getGcsFs());
                this.configureWorkingDirectory(config);
            }
        } else {
            this.configureBuckets(this.getGcsFs());
            this.configureWorkingDirectory(config);
        }
    }

    private void overrideConfigFromFile(Configuration config) throws IOException {
        String configFile = GoogleHadoopFileSystemConfiguration.GCS_CONFIG_OVERRIDE_FILE.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (configFile != null) {
            config.addResource((InputStream)new FileInputStream(configFile));
        }
    }

    private GoogleCloudStorageFileSystem createGcsFs(Configuration config) throws IOException {
        Credential credential;
        try {
            credential = this.getCredential(config);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        GoogleCloudStorageFileSystemOptions gcsFsOptions = GoogleHadoopFileSystemConfiguration.getGcsFsOptionsBuilder(config).build();
        return new GoogleCloudStorageFileSystem(credential, gcsFsOptions);
    }

    @VisibleForTesting
    protected abstract void configureBuckets(GoogleCloudStorageFileSystem var1) throws IOException;

    private void configureWorkingDirectory(Configuration config) {
        Path newWorkingDirectory;
        this.workingDirectory = this.getFileSystemRoot();
        String configWorkingDirectory = GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        if (Strings.isNullOrEmpty(configWorkingDirectory)) {
            newWorkingDirectory = this.getDefaultWorkingDirectory();
            ((GoogleLogger.Api)logger.atWarning()).log("No working directory configured, using default: '%s'", newWorkingDirectory);
        } else {
            newWorkingDirectory = new Path(configWorkingDirectory);
        }
        this.setWorkingDirectory(newWorkingDirectory);
        ((GoogleLogger.Api)logger.atFinest()).log("Configured working directory: %s = %s", (Object)GoogleHadoopFileSystemConfiguration.GCS_WORKING_DIRECTORY.getKey(), (Object)this.getWorkingDirectory());
    }

    private void checkOpen() throws IOException {
        if (this.isClosed()) {
            throw new IOException("GoogleHadoopFileSystem has been closed or not initialized.");
        }
    }

    private boolean isClosed() {
        return this.gcsFsSupplier == null || this.gcsFsSupplier.get() == null;
    }

    public boolean deleteOnExit(Path f) throws IOException {
        this.checkOpen();
        boolean result = super.deleteOnExit(f);
        ((GoogleLogger.Api)logger.atFiner()).log("deleteOnExit(path: %s): %b", (Object)f, result);
        return result;
    }

    protected void processDeleteOnExit() {
        ((GoogleLogger.Api)logger.atFinest()).log("processDeleteOnExit()");
        super.processDeleteOnExit();
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        ContentSummary result = super.getContentSummary(f);
        ((GoogleLogger.Api)logger.atFinest()).log("getContentSummary(path: %s): %b", (Object)f, (Object)result);
        return result;
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        Token<DelegationTokenIdentifier> result = null;
        if (this.delegationTokens != null) {
            result = this.delegationTokens.getBoundOrNewDT(renewer);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getDelegationToken(renewer: %s): %s", (Object)renewer, result);
        return result;
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("copyFromLocalFile(delSrc: %b, overwrite: %b, %d srcs, dst: %s)", delSrc, overwrite, srcs.length, dst);
        super.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("copyFromLocalFile(delSrc: %b, overwrite: %b, src: %s, dst: %s)", delSrc, overwrite, src, dst);
        super.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("copyToLocalFile(delSrc: %b, src: %s, dst: %s)", delSrc, src, dst);
        super.copyToLocalFile(delSrc, src, dst);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        Path result = super.startLocalOutput(fsOutputFile, tmpLocalFile);
        ((GoogleLogger.Api)logger.atFiner()).log("startLocalOutput(fsOutputFile: %s, tmpLocalFile: %s): %s", fsOutputFile, tmpLocalFile, result);
        return result;
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("startLocalOutput(fsOutputFile: %s, tmpLocalFile: %s)", (Object)fsOutputFile, (Object)tmpLocalFile);
        super.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void close() throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("close()");
        super.close();
        if (this.gcsFsSupplier != null) {
            if (this.gcsFsInitialized) {
                this.getGcsFs().close();
            }
            this.gcsFsSupplier = null;
        }
        this.stopDelegationTokens();
        this.logCounters();
    }

    public long getUsed() throws IOException {
        long result = super.getUsed();
        ((GoogleLogger.Api)logger.atFinest()).log("getUsed(): %s", result);
        return result;
    }

    public long getDefaultBlockSize() {
        long result = this.defaultBlockSize;
        ((GoogleLogger.Api)logger.atFinest()).log("getDefaultBlockSize(): %d", result);
        return result;
    }

    public FileChecksum getFileChecksum(Path hadoopPath) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkArgument(hadoopPath != null, "hadoopPath must not be null");
        this.checkOpen();
        URI gcsPath = this.getGcsPath(hadoopPath);
        FileInfo fileInfo = this.getGcsFs().getFileInfo(gcsPath);
        if (!fileInfo.exists()) {
            throw new FileNotFoundException(String.format("%s not found: %s", fileInfo.isDirectory() ? "Directory" : "File", hadoopPath));
        }
        FileChecksum checksum = GoogleHadoopFileSystemBase.getFileChecksum(this.checksumType, fileInfo);
        ((GoogleLogger.Api)logger.atFinest()).log("getFileChecksum(hadoopPath: %s [gcsPath: %s]): %s", hadoopPath, gcsPath, checksum);
        long duration = System.nanoTime() - startTime;
        this.increment(Counter.GET_FILE_CHECKSUM);
        this.increment(Counter.GET_FILE_CHECKSUM_TIME, duration);
        return checksum;
    }

    private static FileChecksum getFileChecksum(GcsFileChecksumType type, FileInfo fileInfo) throws IOException {
        switch (type) {
            case NONE: {
                return null;
            }
            case CRC32C: {
                return new GcsFileChecksum(type, fileInfo.getItemInfo().getVerificationAttributes().getCrc32c());
            }
            case MD5: {
                return new GcsFileChecksum(type, fileInfo.getItemInfo().getVerificationAttributes().getMd5hash());
            }
        }
        throw new IOException("Unrecognized GcsFileChecksumType: " + (Object)((Object)type));
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        ((GoogleLogger.Api)logger.atFinest()).log("setVerifyChecksum(verifyChecksum: %s)", verifyChecksum);
        super.setVerifyChecksum(verifyChecksum);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("setPermission(path: %s, permission: %s)", (Object)p, (Object)permission);
        super.setPermission(p, permission);
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("setOwner(path: %s, username: %s, groupname: %s)", p, username, groupname);
        super.setOwner(p, username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        ((GoogleLogger.Api)logger.atFinest()).log("setTimes(path: %s, mtime: %d, atime: %d)", p, mtime, atime);
        super.setTimes(p, mtime, atime);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        Preconditions.checkNotNull(path, "path should not be null");
        Preconditions.checkNotNull(name, "name should not be null");
        Map<String, byte[]> attributes = this.getGcsFs().getFileInfo(this.getGcsPath(path)).getAttributes();
        String xAttrKey = this.getXAttrKey(name);
        byte[] xAttr = attributes.containsKey(xAttrKey) ? this.getXAttrValue(attributes.get(xAttrKey)) : null;
        ((GoogleLogger.Api)logger.atFiner()).log("getXAttr(path: %s, name: %s): %s", path, name, LazyArgs.lazy(() -> new String(xAttr, StandardCharsets.UTF_8)));
        return xAttr;
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        Preconditions.checkNotNull(path, "path should not be null");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        Map xAttrs = fileInfo.getAttributes().entrySet().stream().filter(a -> this.isXAttr((String)a.getKey())).collect(HashMap::new, (m, a) -> m.put(this.getXAttrName((String)a.getKey()), this.getXAttrValue((byte[])a.getValue())), Map::putAll);
        ((GoogleLogger.Api)logger.atFiner()).log("getXAttrs(path: %s): %s", (Object)path, (Object)xAttrs);
        return xAttrs;
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        Map<String, Object> xAttrs;
        Preconditions.checkNotNull(path, "path should not be null");
        Preconditions.checkNotNull(names, "names should not be null");
        if (names.isEmpty()) {
            xAttrs = new HashMap<String, byte[]>();
        } else {
            HashSet<String> namesSet = new HashSet<String>(names);
            xAttrs = this.getXAttrs(path).entrySet().stream().filter(a -> namesSet.contains(a.getKey())).collect(HashMap::new, (m, a) -> {
                byte[] cfr_ignored_0 = (byte[])m.put(a.getKey(), a.getValue());
            }, Map::putAll);
        }
        ((GoogleLogger.Api)logger.atFiner()).log("getXAttrs(path: %s, names: %s): %s", path, names, xAttrs);
        return xAttrs;
    }

    public List<String> listXAttrs(Path path) throws IOException {
        Preconditions.checkNotNull(path, "path should not be null");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        List xAttrs = fileInfo.getAttributes().keySet().stream().filter(this::isXAttr).map(this::getXAttrName).collect(Collectors.toCollection(ArrayList::new));
        ((GoogleLogger.Api)logger.atFiner()).log("listXAttrs(path: %s): %s", (Object)path, (Object)xAttrs);
        return xAttrs;
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flags) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("setXAttr(path: %s, name: %s, value %s, flags %s", path, name, LazyArgs.lazy(() -> new String(value, StandardCharsets.UTF_8)), flags);
        Preconditions.checkNotNull(path, "path should not be null");
        Preconditions.checkNotNull(name, "name should not be null");
        Preconditions.checkArgument(flags != null && !flags.isEmpty(), "flags should not be null or empty");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        String xAttrKey = this.getXAttrKey(name);
        Map<String, byte[]> attributes = fileInfo.getAttributes();
        if (attributes.containsKey(xAttrKey) && !flags.contains(XAttrSetFlag.REPLACE)) {
            throw new IOException(String.format("REPLACE flag must be set to update XAttr (name='%s', value='%s') for '%s'", name, new String(value, StandardCharsets.UTF_8), path));
        }
        if (!attributes.containsKey(xAttrKey) && !flags.contains(XAttrSetFlag.CREATE)) {
            throw new IOException(String.format("CREATE flag must be set to create XAttr (name='%s', value='%s') for '%s'", name, new String(value, StandardCharsets.UTF_8), path));
        }
        UpdatableItemInfo updateInfo = new UpdatableItemInfo(fileInfo.getItemInfo().getResourceId(), ImmutableMap.of(xAttrKey, this.getXAttrValue(value)));
        this.getGcsFs().getGcs().updateItems(ImmutableList.of(updateInfo));
    }

    public void removeXAttr(Path path, String name) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("removeXAttr(path: %s, name: %s)", (Object)path, (Object)name);
        Preconditions.checkNotNull(path, "path should not be null");
        Preconditions.checkNotNull(name, "name should not be null");
        FileInfo fileInfo = this.getGcsFs().getFileInfo(this.getGcsPath(path));
        HashMap<String, byte[]> xAttrToRemove = new HashMap<String, byte[]>();
        xAttrToRemove.put(this.getXAttrKey(name), null);
        UpdatableItemInfo updateInfo = new UpdatableItemInfo(fileInfo.getItemInfo().getResourceId(), xAttrToRemove);
        this.getGcsFs().getGcs().updateItems(ImmutableList.of(updateInfo));
    }

    private boolean isXAttr(String key) {
        return key != null && key.startsWith(XATTR_KEY_PREFIX);
    }

    private String getXAttrKey(String name) {
        return XATTR_KEY_PREFIX + name;
    }

    private String getXAttrName(String key) {
        return key.substring(XATTR_KEY_PREFIX.length());
    }

    private byte[] getXAttrValue(byte[] value) {
        return value == null ? XATTR_NULL_VALUE : value;
    }

    static {
        ((GoogleLogger.Api)logger.atFine()).log("GHFS version: %s", VERSION);
        GHFS_ID = String.format("GHFS/%s", VERSION);
        XATTR_NULL_VALUE = new byte[0];
        DAEMON_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("ghfs-thread-%d").setDaemon(true).build();
        ALL_COUNTERS = Sets.immutableEnumSet(EnumSet.allOf(Counter.class));
    }

    private static class GcsFileChecksum
    extends FileChecksum {
        private final GcsFileChecksumType checksumType;
        private final byte[] bytes;

        public GcsFileChecksum(GcsFileChecksumType checksumType, byte[] bytes) {
            this.checksumType = checksumType;
            this.bytes = bytes;
            Preconditions.checkState(bytes == null || bytes.length == checksumType.getByteLength(), "Checksum value length (%s) should be equal to the algorithm byte length (%s)", checksumType.getByteLength(), bytes.length);
        }

        public String getAlgorithmName() {
            return this.checksumType.getAlgorithmName();
        }

        public int getLength() {
            return this.checksumType.getByteLength();
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void readFields(DataInput in) throws IOException {
            in.readFully(this.bytes);
        }

        public void write(DataOutput out) throws IOException {
            out.write(this.bytes);
        }

        public String toString() {
            return this.getAlgorithmName() + ": " + (this.bytes == null ? null : new String(Hex.encodeHex(this.bytes)));
        }
    }

    public static enum Counter {
        APPEND,
        APPEND_TIME,
        CREATE,
        CREATE_TIME,
        DELETE,
        DELETE_TIME,
        GET_FILE_CHECKSUM,
        GET_FILE_CHECKSUM_TIME,
        GET_FILE_STATUS,
        GET_FILE_STATUS_TIME,
        INIT,
        INIT_TIME,
        INPUT_STREAM,
        INPUT_STREAM_TIME,
        LIST_STATUS,
        LIST_STATUS_TIME,
        MKDIRS,
        MKDIRS_TIME,
        OPEN,
        OPEN_TIME,
        OUTPUT_STREAM,
        OUTPUT_STREAM_TIME,
        READ1,
        READ1_TIME,
        READ,
        READ_TIME,
        READ_FROM_CHANNEL,
        READ_FROM_CHANNEL_TIME,
        READ_CLOSE,
        READ_CLOSE_TIME,
        READ_POS,
        READ_POS_TIME,
        RENAME,
        RENAME_TIME,
        SEEK,
        SEEK_TIME,
        SET_WD,
        SET_WD_TIME,
        WRITE1,
        WRITE1_TIME,
        WRITE,
        WRITE_TIME,
        WRITE_CLOSE,
        WRITE_CLOSE_TIME;

    }

    public static enum GcsFileChecksumType {
        NONE(null, 0),
        CRC32C("COMPOSITE-CRC32C", 4),
        MD5("MD5", 16);

        private final String algorithmName;
        private final int byteLength;

        private GcsFileChecksumType(String algorithmName, int byteLength) {
            this.algorithmName = algorithmName;
            this.byteLength = byteLength;
        }

        public String getAlgorithmName() {
            return this.algorithmName;
        }

        public int getByteLength() {
            return this.byteLength;
        }
    }

    public static enum OutputStreamType {
        BASIC,
        SYNCABLE_COMPOSITE;

    }
}

