/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.InputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageImpl;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageItemInfo;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.ObjectWriteConditions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AbstractGoogleAsyncWriteChannel;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.ClientRequestHelper;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.LoggingMediaHttpUploaderProgressListener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class GoogleCloudStorageWriteChannel
extends AbstractGoogleAsyncWriteChannel<Storage.Objects.Insert, StorageObject>
implements GoogleCloudStorageItemInfo.Provider {
    private static final long MIN_LOGGING_INTERVAL_MS = 60000L;
    private final Storage gcs;
    private final String bucketName;
    private final String objectName;
    private final String contentEncoding;
    private final String kmsKeyName;
    private final ObjectWriteConditions writeConditions;
    private final Map<String, String> metadata;
    private GoogleCloudStorageItemInfo completedItemInfo = null;

    @Deprecated
    public GoogleCloudStorageWriteChannel(ExecutorService uploadThreadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata) {
        this(uploadThreadPool, gcs, requestHelper, bucketName, objectName, null, null, options, writeConditions, objectMetadata);
    }

    @Deprecated
    public GoogleCloudStorageWriteChannel(ExecutorService uploadThreadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata, String contentType) {
        this(uploadThreadPool, gcs, requestHelper, bucketName, objectName, contentType, null, options, writeConditions, objectMetadata);
    }

    @Deprecated
    public GoogleCloudStorageWriteChannel(ExecutorService uploadThreadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, String contentType, String kmsKeyName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata) {
        this(uploadThreadPool, gcs, requestHelper, bucketName, objectName, contentType, null, kmsKeyName, options, writeConditions, objectMetadata);
    }

    public GoogleCloudStorageWriteChannel(ExecutorService uploadThreadPool, Storage gcs, ClientRequestHelper<StorageObject> requestHelper, String bucketName, String objectName, String contentType, String contentEncoding, String kmsKeyName, AsyncWriteChannelOptions options, ObjectWriteConditions writeConditions, Map<String, String> objectMetadata) {
        super(uploadThreadPool, options);
        this.gcs = gcs;
        this.setClientRequestHelper(requestHelper);
        this.bucketName = bucketName;
        this.objectName = objectName;
        if (contentType != null) {
            this.setContentType(contentType);
        }
        this.contentEncoding = contentEncoding;
        this.kmsKeyName = kmsKeyName;
        this.writeConditions = writeConditions;
        this.metadata = objectMetadata;
    }

    @Override
    public Storage.Objects.Insert createRequest(InputStreamContent inputStream) throws IOException {
        StorageObject object = new StorageObject().setContentEncoding(this.contentEncoding).setMetadata(this.metadata).setName(this.objectName);
        Storage.Objects.Insert insert = this.gcs.objects().insert(this.bucketName, object, inputStream);
        this.writeConditions.apply(insert);
        if (insert.getMediaHttpUploader() != null) {
            insert.getMediaHttpUploader().setDirectUploadEnabled(this.isDirectUploadEnabled());
            insert.getMediaHttpUploader().setProgressListener(new LoggingMediaHttpUploaderProgressListener(this.objectName, 60000L));
        }
        insert.setName(this.objectName);
        if (this.kmsKeyName != null) {
            insert.setKmsKeyName(this.kmsKeyName);
        }
        return insert;
    }

    @Override
    public void handleResponse(StorageObject response) {
        this.completedItemInfo = GoogleCloudStorageImpl.createItemInfoForStorageObject(new StorageResourceId(this.bucketName, this.objectName), response);
    }

    @Override
    public GoogleCloudStorageItemInfo getItemInfo() {
        return this.completedItemInfo;
    }
}

