/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.cloud.hadoop.gcsio.UriPaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.Path;

public class GoogleHadoopFileSystem
extends GoogleHadoopFileSystemBase {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private String rootBucket;

    public GoogleHadoopFileSystem() {
    }

    @VisibleForTesting
    GoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    @VisibleForTesting
    protected void configureBuckets(GoogleCloudStorageFileSystem gcsFs) throws IOException {
        this.rootBucket = this.initUri.getAuthority();
        Preconditions.checkArgument((this.rootBucket != null ? 1 : 0) != 0, (String)"No bucket specified in GCS URI: %s", (Object)this.initUri);
        UriPaths.fromStringPathComponents((String)this.rootBucket, null, (boolean)true);
        ((GoogleLogger.Api)logger.atFine()).log("configureBuckets: GoogleHadoopFileSystem root bucket is '%s'", (Object)this.rootBucket);
    }

    @Override
    protected void checkPath(Path path) {
        ((GoogleLogger.Api)logger.atFinest()).log("checkPath(path: %s)", (Object)path);
        super.checkPath(path);
        URI uri = path.toUri();
        String bucket = uri.getAuthority();
        if (bucket == null || bucket.equals(this.rootBucket)) {
            return;
        }
        throw new IllegalArgumentException(String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, this.rootBucket));
    }

    @VisibleForTesting
    String getRootBucketName() {
        return this.rootBucket;
    }

    @Override
    protected String getHomeDirectorySubpath() {
        return "user/" + System.getProperty("user.name");
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        ((GoogleLogger.Api)logger.atFinest()).log("getHadoopPath(gcsPath: %s)", (Object)gcsPath);
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = StorageResourceId.fromUriPath((URI)gcsPath, (boolean)true);
        Preconditions.checkArgument((!resourceId.isRoot() ? 1 : 0) != 0, (String)"Missing authority in gcsPath '%s'", (Object)gcsPath);
        Preconditions.checkArgument((boolean)resourceId.getBucketName().equals(this.rootBucket), (String)"Authority of URI '%s' doesn't match root bucket '%s'", (Object)resourceId.getBucketName(), (Object)this.rootBucket);
        Path hadoopPath = new Path(this.getScheme() + "://" + this.rootBucket + '/' + resourceId.getObjectName());
        ((GoogleLogger.Api)logger.atFinest()).log("getHadoopPath(gcsPath: %s): %s", (Object)gcsPath, (Object)hadoopPath);
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        ((GoogleLogger.Api)logger.atFinest()).log("getGcsPath(hadoopPath: %s)", (Object)hadoopPath);
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        URI gcsPath = UriPaths.fromStringPathComponents((String)this.rootBucket, (String)objectName, (boolean)true);
        ((GoogleLogger.Api)logger.atFinest()).log("getGcsPath(hadoopPath: %s): %s", (Object)hadoopPath, (Object)gcsPath);
        return gcsPath;
    }

    @Override
    public String getScheme() {
        return "gs";
    }

    @Override
    public Path getFileSystemRoot() {
        return new Path(this.getScheme() + "://" + this.rootBucket + '/');
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return this.getFileSystemRoot();
    }
}

