/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.fs.gcs.HadoopConfigurationProperty;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageReadOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.PerformanceCachingGoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.cooplock.CooperativeLockingOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.AsyncWriteChannelOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RequesterPaysOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Strings;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableList;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.collect.ImmutableMap;
import com.google.cloud.hadoop.repackaged.gcs.com.google.common.flogger.GoogleLogger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class GoogleHadoopFileSystemConfiguration {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String GCS_CONFIG_PREFIX = "fs.gs";
    public static final List<String> CONFIG_KEY_PREFIXES = ImmutableList.copyOf(HadoopCredentialConfiguration.getConfigKeyPrefixes("fs.gs"));
    public static final HadoopConfigurationProperty<String> GCS_ROOT_URL = new HadoopConfigurationProperty<String>("fs.gs.storage.root.url", "https://storage.googleapis.com/", new String[0]);
    public static final HadoopConfigurationProperty<String> PERMISSIONS_TO_REPORT = new HadoopConfigurationProperty<String>("fs.gs.reported.permissions", "700", new String[0]);
    public static final HadoopConfigurationProperty<Long> BLOCK_SIZE = new HadoopConfigurationProperty<Long>("fs.gs.block.size", 0x4000000L, new String[0]);
    public static final HadoopConfigurationProperty<String> DELEGATION_TOKEN_BINDING_CLASS = new HadoopConfigurationProperty("fs.gs.delegation.token.binding");
    public static final HadoopConfigurationProperty<String> GCS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.project.id");
    public static final HadoopConfigurationProperty<String> GCS_WORKING_DIRECTORY = new HadoopConfigurationProperty<String>("fs.gs.working.dir", "/", new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCE_BUCKET_DELETE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.bucket.delete.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode> GCS_REQUESTER_PAYS_MODE = new HadoopConfigurationProperty<RequesterPaysOptions.RequesterPaysMode>("fs.gs.requester.pays.mode", RequesterPaysOptions.REQUESTER_PAYS_MODE_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_REQUESTER_PAYS_PROJECT_ID = new HadoopConfigurationProperty("fs.gs.requester.pays.project.id");
    public static final HadoopConfigurationProperty<Collection<String>> GCS_REQUESTER_PAYS_BUCKETS = new HadoopConfigurationProperty("fs.gs.requester.pays.buckets", ImmutableList.of(), new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType> GCS_FILE_CHECKSUM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.GcsFileChecksumType>("fs.gs.checksum.type", GoogleHadoopFileSystemBase.GcsFileChecksumType.NONE, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_PERFORMANCE_CACHE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.performance.cache.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS = new HadoopConfigurationProperty<Long>("fs.gs.performance.cache.max.entry.age.ms", 5000L, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_STATUS_PARALLEL_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.status.parallel.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_LAZY_INITIALIZATION_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.lazy.init.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.implicit.dir.repair.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.implicit.dir.infer.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_FLAT_GLOB_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.glob.flatlist.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_CONCURRENT_GLOB_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.glob.concurrent.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_MARKER_FILE_PATTERN = new HadoopConfigurationProperty("fs.gs.marker.file.pattern");
    public static final HadoopConfigurationProperty<Long> GCS_MAX_REQUESTS_PER_BATCH = new HadoopConfigurationProperty<Long>("fs.gs.max.requests.per.batch", 15L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_BATCH_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.batch.threads", 15, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_COPY_MAX_REQUESTS_PER_BATCH = new HadoopConfigurationProperty<Long>("fs.gs.copy.max.requests.per.batch", 15L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_COPY_BATCH_THREADS = new HadoopConfigurationProperty<Integer>("fs.gs.copy.batch.threads", 15, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COPY_WITH_REWRITE_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.copy.with.rewrite.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_REWRITE_MAX_BYTES_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.rewrite.max.bytes.per.call", 0x20000000L, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_MAX_LIST_ITEMS_PER_CALL = new HadoopConfigurationProperty<Long>("fs.gs.list.max.items.per.call", 1024L, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_MAX_RETRY = new HadoopConfigurationProperty<Integer>("fs.gs.http.max.retry", 10, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_CONNECT_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.connect-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_HTTP_READ_TIMEOUT = new HadoopConfigurationProperty<Integer>("fs.gs.http.read-timeout", 20000, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_APPLICATION_NAME_SUFFIX = new HadoopConfigurationProperty<String>("fs.gs.application.name.suffix", "", new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE = new HadoopConfigurationProperty<Integer>("fs.gs.max.wait.for.empty.object.creation.ms", 3000, new String[0]);
    public static final HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType> GCS_OUTPUT_STREAM_TYPE = new HadoopConfigurationProperty<GoogleHadoopFileSystemBase.OutputStreamType>("fs.gs.outputstream.type", GoogleHadoopFileSystemBase.OutputStreamType.BASIC, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.buffer.size", 0x800000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.pipe.buffer.size", 0x100000, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.chunk.size", 0x4000000, "fs.gs.io.buffersize.write");
    public static final HadoopConfigurationProperty<Integer> GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.outputstream.upload.cache.size", 0, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.outputstream.direct.upload.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_INPUT_STREAM_BUFFER_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.inputstream.buffer.size", 0, "fs.gs.io.buffersize");
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.fast.fail.on.not.found.enable", true, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.inputstream.support.gzip.encoding.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT = new HadoopConfigurationProperty<Long>("fs.gs.inputstream.inplace.seek.limit", 0x800000L, new String[0]);
    public static final HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise> GCS_INPUT_STREAM_FADVISE = new HadoopConfigurationProperty<GoogleCloudStorageReadOptions.Fadvise>("fs.gs.inputstream.fadvise", GoogleCloudStorageReadOptions.Fadvise.AUTO, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE = new HadoopConfigurationProperty<Integer>("fs.gs.inputstream.min.range.request.size", 524288, new String[0]);
    public static final HadoopConfigurationProperty<String> GCS_CONFIG_OVERRIDE_FILE = new HadoopConfigurationProperty<Object>("fs.gs.config.override.file", null, new String[0]);
    public static final HadoopConfigurationProperty<Boolean> GCS_COOPERATIVE_LOCKING_ENABLE = new HadoopConfigurationProperty<Boolean>("fs.gs.cooperative.locking.enable", false, new String[0]);
    public static final HadoopConfigurationProperty<Long> GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS = new HadoopConfigurationProperty<Long>("fs.gs.cooperative.locking.expiration.timeout.ms", CooperativeLockingOptions.LOCK_EXPIRATION_TIMEOUT_MS_DEFAULT, new String[0]);
    public static final HadoopConfigurationProperty<Integer> GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS = new HadoopConfigurationProperty<Integer>("fs.gs.cooperative.locking.max.concurrent.operations", 20, new String[0]);
    public static final HadoopConfigurationProperty<Map<String, String>> GCS_HTTP_HEADERS = new HadoopConfigurationProperty("fs.gs.storage.http.headers.", ImmutableMap.of(), new String[0]);

    static GoogleCloudStorageFileSystemOptions.Builder getGcsFsOptionsBuilder(Configuration config) {
        return GoogleCloudStorageFileSystemOptions.builder().setBucketDeleteEnabled(GCE_BUCKET_DELETE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setMarkerFilePattern(GCS_MARKER_FILE_PATTERN.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setPerformanceCacheEnabled(GCS_PERFORMANCE_CACHE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setCooperativeLockingEnabled(GCS_COOPERATIVE_LOCKING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setPerformanceCacheOptions(GoogleHadoopFileSystemConfiguration.getPerformanceCachingOptions(config)).setStatusParallelEnabled(GCS_STATUS_PARALLEL_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setCloudStorageOptions(GoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(config).build());
    }

    @VisibleForTesting
    static GoogleCloudStorageOptions.Builder getGcsOptionsBuilder(Configuration config) {
        String projectId = GCS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return GoogleCloudStorageOptions.builder().setStorageRootUrl(GCS_ROOT_URL.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setAutoRepairImplicitDirectoriesEnabled(GCS_REPAIR_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setInferImplicitDirectoriesEnabled(GCS_INFER_IMPLICIT_DIRECTORIES_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setCopyWithRewriteEnabled(GCS_COPY_WITH_REWRITE_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setMaxBytesRewrittenPerCall(GCS_REWRITE_MAX_BYTES_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setCopyMaxRequestsPerBatch(GCS_COPY_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setCopyBatchThreads(GCS_COPY_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setTransportType(HadoopCredentialConfiguration.HTTP_TRANSPORT_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProxyAddress(HadoopCredentialConfiguration.PROXY_ADDRESS_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1))).setProxyUsername(HadoopCredentialConfiguration.PROXY_USERNAME_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config)).setProxyPassword(HadoopCredentialConfiguration.PROXY_PASSWORD_SUFFIX.withPrefixes(CONFIG_KEY_PREFIXES).getPassword(config)).setProjectId(projectId).setMaxListItemsPerCall(GCS_MAX_LIST_ITEMS_PER_CALL.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setMaxRequestsPerBatch(GCS_MAX_REQUESTS_PER_BATCH.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setBatchThreads(GCS_BATCH_THREADS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setMaxHttpRequestRetries(GCS_HTTP_MAX_RETRY.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setHttpRequestConnectTimeout(GCS_HTTP_CONNECT_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setHttpRequestReadTimeout(GCS_HTTP_READ_TIMEOUT.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setAppName(GoogleHadoopFileSystemConfiguration.getApplicationName(config)).setMaxWaitMillisForEmptyObjectCreation(GCS_MAX_WAIT_MILLIS_EMPTY_OBJECT_CREATE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setReadChannelOptions(GoogleHadoopFileSystemConfiguration.getReadChannelOptions(config)).setWriteChannelOptions(GoogleHadoopFileSystemConfiguration.getWriteChannelOptions(config)).setRequesterPaysOptions(GoogleHadoopFileSystemConfiguration.getRequesterPaysOptions(config, projectId)).setCooperativeLockingOptions(GoogleHadoopFileSystemConfiguration.getCooperativeLockingOptions(config)).setHttpRequestHeaders(GCS_HTTP_HEADERS.getPropsWithPrefix(config));
    }

    private static PerformanceCachingGoogleCloudStorageOptions getPerformanceCachingOptions(Configuration config) {
        return PerformanceCachingGoogleCloudStorageOptions.builder().setMaxEntryAgeMillis(GCS_PERFORMANCE_CACHE_MAX_ENTRY_AGE_MILLIS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).build();
    }

    private static String getApplicationName(Configuration config) {
        String appNameSuffix = Strings.nullToEmpty(GCS_APPLICATION_NAME_SUFFIX.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1)));
        String applicationName = GoogleHadoopFileSystem.GHFS_ID + appNameSuffix;
        ((GoogleLogger.Api)logger.atFinest()).log("getApplicationName(config: %s): %s", (Object)config, (Object)applicationName);
        return applicationName;
    }

    private static GoogleCloudStorageReadOptions getReadChannelOptions(Configuration config) {
        return GoogleCloudStorageReadOptions.builder().setFastFailOnNotFound(GCS_INPUT_STREAM_FAST_FAIL_ON_NOT_FOUND_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setSupportGzipEncoding(GCS_INPUT_STREAM_SUPPORT_GZIP_ENCODING_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).setInplaceSeekLimit(GCS_INPUT_STREAM_INPLACE_SEEK_LIMIT.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setBufferSize(GCS_INPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setFadvise(GCS_INPUT_STREAM_FADVISE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setMinRangeRequestSize(GCS_INPUT_STREAM_MIN_RANGE_REQUEST_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).build();
    }

    private static AsyncWriteChannelOptions getWriteChannelOptions(Configuration config) {
        return AsyncWriteChannelOptions.builder().setBufferSize(GCS_OUTPUT_STREAM_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setPipeBufferSize(GCS_OUTPUT_STREAM_PIPE_BUFFER_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setUploadChunkSize(GCS_OUTPUT_STREAM_UPLOAD_CHUNK_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setUploadCacheSize(GCS_OUTPUT_STREAM_UPLOAD_CACHE_SIZE.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).setDirectUploadEnabled(GCS_OUTPUT_STREAM_DIRECT_UPLOAD_ENABLE.get(config, (arg_0, arg_1) -> ((Configuration)config).getBoolean(arg_0, arg_1))).build();
    }

    private static RequesterPaysOptions getRequesterPaysOptions(Configuration config, String projectId) {
        String requesterPaysProjectId = GCS_REQUESTER_PAYS_PROJECT_ID.get(config, (arg_0, arg_1) -> ((Configuration)config).get(arg_0, arg_1));
        return RequesterPaysOptions.builder().setMode(GCS_REQUESTER_PAYS_MODE.get(config, (arg_0, arg_1) -> ((Configuration)config).getEnum(arg_0, arg_1))).setProjectId(requesterPaysProjectId == null ? projectId : requesterPaysProjectId).setBuckets(GCS_REQUESTER_PAYS_BUCKETS.getStringCollection(config)).build();
    }

    private static CooperativeLockingOptions getCooperativeLockingOptions(Configuration config) {
        return CooperativeLockingOptions.builder().setLockExpirationTimeoutMilli(GCS_COOPERATIVE_LOCKING_EXPIRATION_TIMEOUT_MS.get(config, (arg_0, arg_1) -> ((Configuration)config).getLong(arg_0, arg_1))).setMaxConcurrentOperations(GCS_COOPERATIVE_LOCKING_MAX_CONCURRENT_OPERATIONS.get(config, (arg_0, arg_1) -> ((Configuration)config).getInt(arg_0, arg_1))).build();
    }
}

