/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.samples;

import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.common.collect.Streams;
import com.google.common.flogger.GoogleLogger;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class WikipediaRequestBytes {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static void main(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        GenericOptionsParser parser = new GenericOptionsParser(args);
        String[] customArgs = parser.getRemainingArgs();
        Configuration config = parser.getConfiguration();
        if (customArgs.length != 5) {
            System.out.println("Usage: hadoop jar wikipedia_bytes_deploy.jar [projectId] [inputDatasetId] [inputTableId] [exportGcsBucket] [jobOutputPath]");
            System.exit(1);
        }
        String projectId = customArgs[0];
        String inputDatasetId = customArgs[1];
        String inputTableId = customArgs[2];
        String exportGcsBucket = customArgs[3];
        String jobOutputPath = customArgs[4];
        JobConf conf = new JobConf(config, WikipediaRequestBytes.class);
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, projectId, inputDatasetId, inputTableId);
        conf.set(BigQueryConfiguration.GCS_BUCKET.getKey(), exportGcsBucket);
        Job job = new Job((Configuration)conf, "WikipediaRequestBytes");
        job.setJarByClass(WikipediaRequestBytes.class);
        job.setMapperClass(TitleBytesMapper.class);
        job.setCombinerClass(TitleBytesSumReducer.class);
        job.setReducerClass(TitleBytesSumReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(jobOutputPath));
        job.setInputFormatClass(GsonBigQueryInputFormat.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        job.waitForCompletion(true);
        GsonBigQueryInputFormat.cleanupJob(job.getConfiguration(), job.getJobID());
    }

    public static class TitleBytesSumReducer
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        private final LongWritable bytesCountWritable = new LongWritable();

        public void reduce(Text title, Iterable<LongWritable> bytesTransferred, Reducer.Context context) throws IOException, InterruptedException {
            long count = Streams.stream(bytesTransferred).mapToLong(LongWritable::get).sum();
            this.bytesCountWritable.set(count);
            context.write((Object)title, (Object)this.bytesCountWritable);
        }
    }

    public static class TitleBytesMapper
    extends Mapper<LongWritable, JsonObject, Text, LongWritable> {
        private final Text pageTitleText = new Text();
        private final LongWritable pageBytesWritable = new LongWritable();

        public void map(LongWritable lineNumber, JsonObject record, Mapper.Context context) throws IOException, InterruptedException {
            long pageBytes = -1L;
            String pageTitle = null;
            try {
                pageBytes = record.get("bytes_transferred").getAsLong();
                pageTitle = record.get("title").getAsString();
            }
            catch (ClassCastException | NullPointerException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Malformed record, bad title or bytes_transferred: '%s'", (Object)record);
            }
            if (pageTitle != null) {
                this.pageTitleText.set(pageTitle);
                this.pageBytesWritable.set(pageBytes);
                context.write((Object)this.pageTitleText, (Object)this.pageBytesWritable);
            }
        }
    }
}

