/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class BigQueryTableSchema {
    private final TableSchema tableSchema;

    public BigQueryTableSchema() {
        this.tableSchema = new TableSchema();
    }

    BigQueryTableSchema(TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)tableSchema, (Object)"tableSchema is null.");
        this.tableSchema = tableSchema;
    }

    public BigQueryTableSchema setFields(List<BigQueryTableFieldSchema> bigQueryTableFields) {
        Preconditions.checkArgument((!bigQueryTableFields.isEmpty() ? 1 : 0) != 0, (Object)"Empty fields.");
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>(bigQueryTableFields.size());
        for (BigQueryTableFieldSchema bigQueryTableField : bigQueryTableFields) {
            fields.add(bigQueryTableField.get());
        }
        this.tableSchema.setFields(fields);
        return this;
    }

    public int hashCode() {
        return this.tableSchema.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigQueryTableSchema)) {
            return false;
        }
        BigQueryTableSchema another = (BigQueryTableSchema)object;
        return this.tableSchema.equals((Object)another.tableSchema);
    }

    TableSchema get() {
        return this.tableSchema;
    }

    static BigQueryTableSchema wrap(TableSchema tableSchema) {
        return new BigQueryTableSchema(tableSchema);
    }
}

