/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class ShardedInputSplit
extends InputSplit
implements Writable {
    private Path shardDirectoryAndPattern;
    private long estimatedNumRecords;

    public ShardedInputSplit() {
    }

    public ShardedInputSplit(Path shardDirectoryAndPattern, long estimatedNumRecords) {
        this.shardDirectoryAndPattern = shardDirectoryAndPattern;
        this.estimatedNumRecords = estimatedNumRecords;
    }

    public Path getShardDirectoryAndPattern() {
        return this.shardDirectoryAndPattern;
    }

    public long getLength() {
        return this.estimatedNumRecords;
    }

    public String[] getLocations() throws IOException {
        return new String[0];
    }

    public String toString() {
        return String.format("%s[%d estimated records]", this.shardDirectoryAndPattern, this.estimatedNumRecords);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.shardDirectoryAndPattern.toString());
        out.writeLong(this.estimatedNumRecords);
    }

    public void readFields(DataInput in) throws IOException {
        this.shardDirectoryAndPattern = new Path(Text.readString((DataInput)in));
        this.estimatedNumRecords = in.readLong();
    }
}

