/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.UnshardedExportToCloudStorage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;

public class NoopFederatedExportToCloudStorage
extends UnshardedExportToCloudStorage {
    protected final List<String> gcsPaths;

    public NoopFederatedExportToCloudStorage(Configuration configuration, ExportFileFormat fileFormat, BigQueryHelper bigQueryHelper, String projectId, Table table, @Nullable InputFormat<LongWritable, Text> delegateInputFormat) {
        super(configuration, NoopFederatedExportToCloudStorage.getCommaSeparatedGcsPathList(table), fileFormat, bigQueryHelper, projectId, table, delegateInputFormat);
        Preconditions.checkNotNull((Object)table.getExternalDataConfiguration());
        String inputType = fileFormat.getFormatIdentifier();
        String tableType = table.getExternalDataConfiguration().getSourceFormat();
        Preconditions.checkArgument((boolean)inputType.equals(tableType), (String)"MapReduce fileFormat '%s' does not match BigQuery sourceFormat '%s'. Use the appropriate InputFormat.", (Object)inputType, (Object)tableType);
        this.gcsPaths = table.getExternalDataConfiguration().getSourceUris();
    }

    @VisibleForTesting
    static String getCommaSeparatedGcsPathList(Table table) {
        Preconditions.checkNotNull((Object)table.getExternalDataConfiguration());
        for (String uri : table.getExternalDataConfiguration().getSourceUris()) {
            Preconditions.checkArgument((boolean)uri.startsWith("gs://"), (String)"Invalid GCS resource: '%s'", (Object)uri);
        }
        return Joiner.on((String)",").join((Iterable)table.getExternalDataConfiguration().getSourceUris());
    }

    @Override
    public void prepare() throws IOException {
    }

    @Override
    public void beginExport() throws IOException {
    }

    @Override
    public void waitForUsableMapReduceInput() throws IOException, InterruptedException {
    }

    @Override
    public List<String> getExportPaths() throws IOException {
        return this.gcsPaths;
    }

    @Override
    public void cleanupExport() throws IOException {
    }
}

