/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTimePartitioning;
import com.google.cloud.hadoop.io.bigquery.output.IndirectBigQueryOutputCommitter;
import com.google.cloud.hadoop.util.testing.CredentialConfigurationUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class IndirectBigQueryOutputCommitterTest {
    private static final String TEST_PROJECT_ID = "domain:project";
    private static final String TEST_DATASET_ID = "dataset";
    private static final String TEST_TABLE_ID = "table";
    private static final String QUALIFIED_TEST_TABLE_ID = String.format("%s:%s.%s", "domain:project", "dataset", "table");
    private static final BigQueryTimePartitioning TEST_TIME_PARTITIONING = BigQueryTimePartitioning.wrap((TimePartitioning)new TimePartitioning().setType("DAY"));
    private static final BigQueryFileFormat TEST_FILE_FORMAT = BigQueryFileFormat.NEWLINE_DELIMITED_JSON;
    private static final String TEST_WRITE_DISPOSITION = (String)BigQueryConfiguration.OUTPUT_TABLE_WRITE_DISPOSITION.getDefault();
    private static final String TEST_CREATE_DISPOSITION = (String)BigQueryConfiguration.OUTPUT_TABLE_CREATE_DISPOSITION.getDefault();
    private static final Class<? extends FileOutputFormat> TEST_OUTPUT_CLASS = TextOutputFormat.class;
    private static final BigQueryTableSchema TEST_TABLE_SCHEMA = BigQueryTableSchema.wrap((TableSchema)new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("Word").setType("STRING"), (Object)new TableFieldSchema().setName("Count").setType("INTEGER"))));
    private static final String TEST_KMS_KEY_NAME = "projects/domain:project/locations/us-west1/keyRings/ring-1/cryptoKeys/key-1";
    private static final TaskAttemptID TEST_TASK_ATTEMPT_ID = new TaskAttemptID(new TaskID("sample_task", 100, false, 200), 1);
    private static final String TEST_BUCKET_STRING = "gs://test_bucket";
    private static final String TEST_OUTPUT_PATH_STRING = "gs://test_bucket/test_directory/";
    private static final String TEST_OUTPUT_FILE_STRING = "gs://test_bucket/test_directory/test_file";
    private InMemoryGoogleHadoopFileSystem ghfs;
    private TableReference outputTableRef;
    private Configuration conf;
    private Path outputPath;
    private Path outputSampleFilePath;
    private Job job;
    private IndirectBigQueryOutputCommitter committer;
    @Mock
    private BigQueryHelper mockBigQueryHelper;
    @Mock
    private TaskAttemptContext mockTaskAttemptContext;
    @Mock
    private OutputCommitter mockCommitter;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.ghfs = new InMemoryGoogleHadoopFileSystem();
        this.ghfs.mkdirs(new Path(TEST_BUCKET_STRING));
        this.job = Job.getInstance((Configuration)InMemoryGoogleHadoopFileSystem.getSampleConfiguration());
        this.conf = this.job.getConfiguration();
        CredentialConfigurationUtil.addTestConfigurationSettings((Configuration)this.conf);
        BigQueryOutputConfiguration.configure((Configuration)this.conf, (String)QUALIFIED_TEST_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        BigQueryOutputConfiguration.setKmsKeyName((Configuration)this.conf, (String)TEST_KMS_KEY_NAME);
        this.conf.set(BigQueryConfiguration.OUTPUT_TABLE_PARTITIONING.getKey(), TEST_TIME_PARTITIONING.getAsJson());
        this.outputTableRef = BigQueryOutputConfiguration.getTableReference((Configuration)this.conf);
        this.outputPath = BigQueryOutputConfiguration.getGcsOutputPath((Configuration)this.conf);
        this.outputSampleFilePath = new Path(TEST_OUTPUT_FILE_STRING);
        Mockito.when((Object)this.mockTaskAttemptContext.getConfiguration()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.mockTaskAttemptContext.getTaskAttemptID()).thenReturn((Object)TEST_TASK_ATTEMPT_ID);
        this.committer = new IndirectBigQueryOutputCommitter(this.mockTaskAttemptContext, this.mockCommitter);
        this.committer.setBigQueryHelper(this.mockBigQueryHelper);
    }

    @After
    public void tearDown() throws IOException {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigQueryHelper});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockCommitter});
        this.ghfs.delete(this.outputPath, true);
    }

    private void generateSampleFiles() throws IOException {
        this.ghfs.mkdirs(this.outputSampleFilePath.getParent());
        this.ghfs.createNewFile(this.outputSampleFilePath);
        Truth.assertThat((Boolean)this.ghfs.exists(this.outputPath)).isTrue();
        Truth.assertThat((Boolean)this.ghfs.exists(this.outputSampleFilePath)).isTrue();
    }

    @Test
    public void testCommitJob() throws Exception {
        this.generateSampleFiles();
        this.committer.commitJob((JobContext)this.job);
        Class<List> listClass = List.class;
        ArgumentCaptor gcsOutputFileCaptor = ArgumentCaptor.forClass(listClass);
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).importFromGcs((String)ArgumentMatchers.eq((Object)TEST_PROJECT_ID), (TableReference)ArgumentMatchers.eq((Object)this.outputTableRef), (TableSchema)ArgumentMatchers.eq((Object)TEST_TABLE_SCHEMA.get()), (TimePartitioning)ArgumentMatchers.eq((Object)TEST_TIME_PARTITIONING.get()), (String)ArgumentMatchers.eq((Object)TEST_KMS_KEY_NAME), (BigQueryFileFormat)ArgumentMatchers.eq((Object)TEST_FILE_FORMAT), (String)ArgumentMatchers.eq((Object)TEST_CREATE_DISPOSITION), (String)ArgumentMatchers.eq((Object)TEST_WRITE_DISPOSITION), (List)gcsOutputFileCaptor.capture(), ArgumentMatchers.eq((boolean)true));
        ((OutputCommitter)Mockito.verify((Object)this.mockCommitter)).commitJob((JobContext)ArgumentMatchers.eq((Object)this.job));
        Truth.assertThat((Iterable)((Iterable)gcsOutputFileCaptor.getValue())).contains((Object)TEST_OUTPUT_FILE_STRING);
    }

    @Test
    public void testCommitJobInterrupt() throws Exception {
        this.generateSampleFiles();
        InterruptedException helperInterruptedException = new InterruptedException("Test exception");
        ((BigQueryHelper)Mockito.doThrow((Throwable[])new Throwable[]{helperInterruptedException}).when((Object)this.mockBigQueryHelper)).importFromGcs((String)ArgumentMatchers.any(String.class), (TableReference)ArgumentMatchers.any(TableReference.class), (TableSchema)ArgumentMatchers.any(TableSchema.class), (TimePartitioning)ArgumentMatchers.any(TimePartitioning.class), ArgumentMatchers.anyString(), (BigQueryFileFormat)ArgumentMatchers.any(BigQueryFileFormat.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (List)ArgumentMatchers.any(List.class), ArgumentMatchers.eq((boolean)true));
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.committer.commitJob((JobContext)this.job));
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)helperInterruptedException);
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).importFromGcs((String)ArgumentMatchers.eq((Object)TEST_PROJECT_ID), (TableReference)ArgumentMatchers.eq((Object)this.outputTableRef), (TableSchema)ArgumentMatchers.eq((Object)TEST_TABLE_SCHEMA.get()), (TimePartitioning)ArgumentMatchers.eq((Object)TEST_TIME_PARTITIONING.get()), (String)ArgumentMatchers.eq((Object)TEST_KMS_KEY_NAME), (BigQueryFileFormat)ArgumentMatchers.eq((Object)TEST_FILE_FORMAT), (String)ArgumentMatchers.eq((Object)TEST_CREATE_DISPOSITION), (String)ArgumentMatchers.eq((Object)TEST_WRITE_DISPOSITION), (List)ArgumentMatchers.any(List.class), ArgumentMatchers.eq((boolean)true));
        ((OutputCommitter)Mockito.verify((Object)this.mockCommitter)).commitJob((JobContext)ArgumentMatchers.eq((Object)this.job));
    }

    @Test
    public void testAbortJob() throws IOException {
        this.generateSampleFiles();
        this.committer.abortJob((JobContext)this.mockTaskAttemptContext, JobStatus.State.KILLED);
        Truth.assertThat((Boolean)(!this.ghfs.exists(this.outputPath) ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(!this.ghfs.exists(this.outputSampleFilePath) ? 1 : 0)).isTrue();
        ((OutputCommitter)Mockito.verify((Object)this.mockCommitter)).abortJob((JobContext)ArgumentMatchers.eq((Object)this.mockTaskAttemptContext), (JobStatus.State)ArgumentMatchers.eq((Object)JobStatus.State.KILLED));
    }
}

