/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.FederatedBigQueryOutputCommitter;
import com.google.cloud.hadoop.io.bigquery.output.FederatedBigQueryOutputFormat;
import com.google.cloud.hadoop.util.testing.CredentialConfigurationUtil;
import com.google.common.truth.Truth;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class FederatedBigQueryOutputFormatTest {
    private static final String TEST_PROJECT_ID = "domain:project";
    private static final String TEST_DATASET_ID = "dataset";
    private static final String TEST_TABLE_ID = "table";
    private static final String QUALIFIED_TEST_TABLE_ID = String.format("%s:%s.%s", "domain:project", "dataset", "table");
    private static final BigQueryFileFormat TEST_FILE_FORMAT = BigQueryFileFormat.NEWLINE_DELIMITED_JSON;
    private static final Class<? extends FileOutputFormat> TEST_OUTPUT_CLASS = TextOutputFormat.class;
    private static final String TEST_OUTPUT_PATH_STRING = "gs://test_bucket/test_directory/";
    private static final Path TEST_OUTPUT_PATH = new Path("gs://test_bucket/test_directory/");
    private static final TaskAttemptID TEST_TASK_ATTEMPT_ID = new TaskAttemptID(new TaskID("sample_task", 100, false, 200), 1);
    private InMemoryGoogleHadoopFileSystem ghfs;
    private Configuration conf;
    private Job job;
    private FederatedBigQueryOutputFormat<Text, Text> outputFormat;
    @Mock
    private TaskAttemptContext mockTaskAttemptContext;
    @Mock
    private FileOutputFormat<Text, Text> mockFileOutputFormat;
    @Mock
    private OutputCommitter mockOutputCommitter;
    @Mock
    private RecordWriter<Text, Text> mockRecordWriter;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.ghfs = new InMemoryGoogleHadoopFileSystem();
        this.job = Job.getInstance((Configuration)InMemoryGoogleHadoopFileSystem.getSampleConfiguration());
        this.conf = this.job.getConfiguration();
        CredentialConfigurationUtil.addTestConfigurationSettings((Configuration)this.conf);
        BigQueryOutputConfiguration.configureWithAutoSchema((Configuration)this.conf, (String)QUALIFIED_TEST_TABLE_ID, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        Mockito.when((Object)this.mockTaskAttemptContext.getConfiguration()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.mockTaskAttemptContext.getTaskAttemptID()).thenReturn((Object)TEST_TASK_ATTEMPT_ID);
        Mockito.when((Object)this.mockFileOutputFormat.getOutputCommitter((TaskAttemptContext)ArgumentMatchers.eq((Object)this.mockTaskAttemptContext))).thenReturn((Object)this.mockOutputCommitter);
        Mockito.when((Object)this.mockFileOutputFormat.getRecordWriter((TaskAttemptContext)ArgumentMatchers.eq((Object)this.mockTaskAttemptContext))).thenReturn(this.mockRecordWriter);
        this.outputFormat = new FederatedBigQueryOutputFormat();
        this.outputFormat.setDelegate(this.mockFileOutputFormat);
    }

    @After
    public void tearDown() throws IOException {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockFileOutputFormat});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockOutputCommitter});
        this.ghfs.delete(TEST_OUTPUT_PATH, true);
    }

    @Test
    public void testCreateCommitter() throws IOException {
        FederatedBigQueryOutputCommitter committer = (FederatedBigQueryOutputCommitter)this.outputFormat.createCommitter(this.mockTaskAttemptContext);
        Truth.assertThat((Object)committer.getDelegate()).isEqualTo((Object)this.mockOutputCommitter);
        ((FileOutputFormat)Mockito.verify(this.mockFileOutputFormat)).getOutputCommitter((TaskAttemptContext)ArgumentMatchers.eq((Object)this.mockTaskAttemptContext));
    }
}

