/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.FederatedBigQueryOutputCommitter;
import com.google.cloud.hadoop.util.testing.CredentialConfigurationUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class FederatedBigQueryOutputCommitterTest {
    private static final String TEST_PROJECT_ID = "domain:project";
    private static final String TEST_DATASET_ID = "dataset";
    private static final String TEST_TABLE_ID = "table";
    private static final String QUALIFIED_TEST_TABLE_ID = String.format("%s:%s.%s", "domain:project", "dataset", "table");
    private static final BigQueryFileFormat TEST_FILE_FORMAT = BigQueryFileFormat.NEWLINE_DELIMITED_JSON;
    private static final Class<? extends FileOutputFormat> TEST_OUTPUT_CLASS = TextOutputFormat.class;
    private static final BigQueryTableSchema TEST_TABLE_SCHEMA = BigQueryTableSchema.wrap((TableSchema)new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("Word").setType("STRING"), (Object)new TableFieldSchema().setName("Count").setType("INTEGER"))));
    private static final TaskAttemptID TEST_TASK_ATTEMPT_ID = new TaskAttemptID(new TaskID("sample_task", 100, false, 200), 1);
    private static final String TEST_BUCKET_STRING = "gs://test_bucket";
    private static final String TEST_OUTPUT_PATH_STRING = "gs://test_bucket/test_directory/";
    private static final String TEST_OUTPUT_FILE_STRING = "gs://test_bucket/test_directory/test_file";
    private InMemoryGoogleHadoopFileSystem ghfs;
    private TableReference outputTableRef;
    private Configuration conf;
    private Path outputPath;
    private Path outputSampleFilePath;
    private Job job;
    private FederatedBigQueryOutputCommitter committer;
    @Mock
    private BigQueryHelper mockBigQueryHelper;
    @Mock
    private TaskAttemptContext mockTaskAttemptContext;
    @Mock
    private OutputCommitter mockCommitter;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        this.ghfs = new InMemoryGoogleHadoopFileSystem();
        this.ghfs.mkdirs(new Path(TEST_BUCKET_STRING));
        this.job = Job.getInstance((Configuration)InMemoryGoogleHadoopFileSystem.getSampleConfiguration());
        this.conf = this.job.getConfiguration();
        CredentialConfigurationUtil.addTestConfigurationSettings((Configuration)this.conf);
        BigQueryOutputConfiguration.configure((Configuration)this.conf, (String)QUALIFIED_TEST_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        this.outputTableRef = BigQueryOutputConfiguration.getTableReference((Configuration)this.conf);
        this.outputPath = BigQueryOutputConfiguration.getGcsOutputPath((Configuration)this.conf);
        this.outputSampleFilePath = new Path(TEST_OUTPUT_FILE_STRING);
        Mockito.when((Object)this.mockTaskAttemptContext.getConfiguration()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.mockTaskAttemptContext.getTaskAttemptID()).thenReturn((Object)TEST_TASK_ATTEMPT_ID);
        this.committer = new FederatedBigQueryOutputCommitter(this.mockTaskAttemptContext, this.mockCommitter);
        this.committer.setBigQueryHelper(this.mockBigQueryHelper);
    }

    @After
    public void tearDown() throws IOException {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigQueryHelper});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockCommitter});
        this.ghfs.delete(this.outputPath, true);
    }

    private void generateSampleFiles() throws IOException {
        this.ghfs.mkdirs(this.outputSampleFilePath.getParent());
        this.ghfs.createNewFile(this.outputSampleFilePath);
        Truth.assertThat((Boolean)this.ghfs.exists(this.outputPath)).isTrue();
        Truth.assertThat((Boolean)this.ghfs.exists(this.outputSampleFilePath)).isTrue();
    }

    @Test
    public void testCommitJob() throws IOException {
        this.generateSampleFiles();
        this.committer.commitJob((JobContext)this.job);
        Class<List> listClass = List.class;
        ArgumentCaptor gcsOutputFileCaptor = ArgumentCaptor.forClass(listClass);
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).importFederatedFromGcs((String)ArgumentMatchers.eq((Object)TEST_PROJECT_ID), (TableReference)ArgumentMatchers.eq((Object)this.outputTableRef), (TableSchema)ArgumentMatchers.eq((Object)TEST_TABLE_SCHEMA.get()), (BigQueryFileFormat)ArgumentMatchers.eq((Object)TEST_FILE_FORMAT), (List)gcsOutputFileCaptor.capture());
        ((OutputCommitter)Mockito.verify((Object)this.mockCommitter)).commitJob((JobContext)ArgumentMatchers.eq((Object)this.job));
        Truth.assertThat((Iterable)((Iterable)gcsOutputFileCaptor.getValue())).containsExactly(new Object[]{TEST_OUTPUT_FILE_STRING});
    }

    @Test
    public void testAbortJob() throws IOException {
        this.generateSampleFiles();
        this.committer.abortJob((JobContext)this.mockTaskAttemptContext, JobStatus.State.KILLED);
        Truth.assertThat((Boolean)(!this.ghfs.exists(this.outputPath) ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(!this.ghfs.exists(this.outputSampleFilePath) ? 1 : 0)).isTrue();
        ((OutputCommitter)Mockito.verify((Object)this.mockCommitter)).abortJob((JobContext)ArgumentMatchers.eq((Object)this.mockTaskAttemptContext), (JobStatus.State)ArgumentMatchers.eq((Object)JobStatus.State.KILLED));
    }
}

