/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.cloud.hadoop.io.bigquery.output.BigQueryTimePartitioning;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.Map;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTimePartitioningTest {
    public static final String TIME_PARTITIONING_JSON = "{\"expirationMs\":\"1000\",\"field\":\"ingestDate\",\"requirePartitionFilter\":true,\"type\":\"DAY\"}";

    @Test
    public void testConvertToJson() throws IOException {
        BigQueryTimePartitioning bigQueryTimePartitioning = new BigQueryTimePartitioning();
        bigQueryTimePartitioning.setType("DAY");
        bigQueryTimePartitioning.setExpirationMs(1000L);
        bigQueryTimePartitioning.setField("ingestDate");
        bigQueryTimePartitioning.setRequirePartitionFilter(Boolean.valueOf(true));
        Truth.assertThat((String)bigQueryTimePartitioning.getAsJson()).isEqualTo((Object)TIME_PARTITIONING_JSON);
    }

    @Test
    public void testConvertFromJson() throws IOException {
        BigQueryTimePartitioning bigQueryTimePartitioning = new BigQueryTimePartitioning();
        bigQueryTimePartitioning.setType("DAY");
        bigQueryTimePartitioning.setExpirationMs(1000L);
        bigQueryTimePartitioning.setField("ingestDate");
        bigQueryTimePartitioning.setRequirePartitionFilter(Boolean.valueOf(true));
        Truth.assertThat((Map)BigQueryTimePartitioning.getFromJson((String)TIME_PARTITIONING_JSON)).isEqualTo((Object)bigQueryTimePartitioning.get());
    }

    @Test
    public void testConversion_OnlyTypeIsPresent() throws IOException {
        BigQueryTimePartitioning bigQueryTimePartitioning = new BigQueryTimePartitioning();
        bigQueryTimePartitioning.setType("DAY");
        String json = bigQueryTimePartitioning.getAsJson();
        Truth.assertThat((String)json).isEqualTo((Object)"{\"type\":\"DAY\"}");
        Truth.assertThat((String)BigQueryTimePartitioning.getFromJson((String)json).getType()).isEqualTo((Object)"DAY");
    }
}

