/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableHelper;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryTableSchemaTest {
    @Test
    public void testBigQueryTableSchema() throws IOException {
        ImmutableList fields = ImmutableList.of((Object)new BigQueryTableFieldSchema().setName("Field1").setType("STRING"), (Object)new BigQueryTableFieldSchema().setName("Field2").setType("INTEGER"), (Object)new BigQueryTableFieldSchema().setName("Field3").setType("RECORD").setFields((List)ImmutableList.of((Object)new BigQueryTableFieldSchema().setName("NestedField1").setType("STRING"), (Object)new BigQueryTableFieldSchema().setName("NestedField2").setType("INTEGER"))));
        BigQueryTableSchema tableSchema = new BigQueryTableSchema().setFields((List)fields);
        String json = BigQueryTableHelper.getTableSchemaJson((TableSchema)tableSchema.get());
        String expectedJson = "{\"fields\":[{\"name\":\"Field1\",\"type\":\"STRING\"},{\"name\":\"Field2\",\"type\":\"INTEGER\"},{\"fields\":[{\"name\":\"NestedField1\",\"type\":\"STRING\"},{\"name\":\"NestedField2\",\"type\":\"INTEGER\"}],\"name\":\"Field3\",\"type\":\"RECORD\"}]}";
        Truth.assertThat((String)json).isEqualTo((Object)expectedJson);
    }
}

