/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery.output;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class BigQueryOutputConfigurationTest {
    private static final String DEFAULT_PROJECT_ID = "google.com:my-project";
    private static final String TEST_PROJECT_ID = "domain:project";
    private static final String TEST_LOAD_PROJECT_ID = "domain:load-project";
    private static final String TEST_DATASET_ID = "dataset";
    private static final String TEST_TABLE_ID = "table";
    private static final String QUALIFIED_TABLE_ID = String.format("%s:%s.%s", "domain:project", "dataset", "table");
    private static final String QUALIFIED_TABLE_ID_WITHOUT_PROJECT = String.format("%s.%s", "dataset", "table");
    private static final TableReference TEST_TABLE_REF = new TableReference().setProjectId("domain:project").setDatasetId("dataset").setTableId("table");
    private static final String TEST_OUTPUT_PATH_STRING = "gs://test_bucket/test_directory";
    private static final BigQueryFileFormat TEST_FILE_FORMAT = BigQueryFileFormat.NEWLINE_DELIMITED_JSON;
    private static final Class<? extends FileOutputFormat> TEST_OUTPUT_CLASS = TextOutputFormat.class;
    private static final BigQueryTableSchema TEST_TABLE_SCHEMA = new BigQueryTableSchema().setFields((List)ImmutableList.of((Object)new BigQueryTableFieldSchema().setName("A").setType("STRING"), (Object)new BigQueryTableFieldSchema().setName("B").setType("INTEGER")));
    private static final String TEST_TABLE_SCHEMA_STRING = "[{\"name\":\"A\",\"type\":\"STRING\"},{\"name\":\"B\",\"type\":\"INTEGER\"}]";
    private static final String TEST_BAD_TABLE_SCHEMA_STRING = "[{\"name\":\"A\",\"type\":\"STRING\"},{'name':\"B\",\"type\":\"INTEGER\"}]";
    private static Configuration conf;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        conf = InMemoryGoogleHadoopFileSystem.getSampleConfiguration();
        new BigQueryOutputConfiguration();
    }

    @Test
    public void testConfigure() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_FILE_FORMAT.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_FILE_FORMAT.name());
        Truth.assertThat((Class)((Class)BigQueryConfiguration.OUTPUT_FORMAT_CLASS.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getClass(arg_0, arg_1)))).isEqualTo(TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_TABLE_SCHEMA_STRING);
        Truth.assertThat((String)BigQueryOutputConfiguration.getGcsOutputPath((Configuration)conf).toString()).isEqualTo((Object)TEST_OUTPUT_PATH_STRING);
    }

    @Test
    public void testConfigureWithDefaultProject() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), DEFAULT_PROJECT_ID);
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID_WITHOUT_PROJECT, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)DEFAULT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_FILE_FORMAT.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_FILE_FORMAT.name());
        Truth.assertThat((Class)((Class)BigQueryConfiguration.OUTPUT_FORMAT_CLASS.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getClass(arg_0, arg_1)))).isEqualTo(TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_TABLE_SCHEMA_STRING);
        Truth.assertThat((String)BigQueryOutputConfiguration.getGcsOutputPath((Configuration)conf).toString()).isEqualTo((Object)TEST_OUTPUT_PATH_STRING);
    }

    @Test
    public void testConfigureWithAutoSchema() throws IOException {
        BigQueryOutputConfiguration.configureWithAutoSchema((Configuration)conf, (String)QUALIFIED_TABLE_ID, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_FILE_FORMAT.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isEqualTo((Object)TEST_FILE_FORMAT.name());
        Truth.assertThat((Class)((Class)BigQueryConfiguration.OUTPUT_FORMAT_CLASS.get(conf, (arg_0, arg_1) -> ((Configuration)conf).getClass(arg_0, arg_1)))).isEqualTo(TEST_OUTPUT_CLASS);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get(conf, (arg_0, arg_1) -> ((Configuration)conf).get(arg_0, arg_1)))).isNull();
        Truth.assertThat((String)BigQueryOutputConfiguration.getGcsOutputPath((Configuration)conf).toString()).isEqualTo((Object)TEST_OUTPUT_PATH_STRING);
    }

    @Test
    public void testConfigureMissing() throws IOException {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID_WITHOUT_PROJECT, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS));
    }

    @Test
    public void testValidateConfiguration() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        BigQueryOutputConfiguration.validateConfiguration((Configuration)conf);
    }

    @Test
    public void testValidateConfigurationMissingProjectId() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        conf.unset(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey());
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.validateConfiguration((Configuration)conf));
    }

    @Test
    public void testValidateConfigurationBadSchema() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.getKey(), TEST_BAD_TABLE_SCHEMA_STRING);
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.validateConfiguration((Configuration)conf));
    }

    @Test
    public void testValidateConfigurationMissingFileFormat() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        conf.unset(BigQueryConfiguration.OUTPUT_FILE_FORMAT.getKey());
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.validateConfiguration((Configuration)conf));
    }

    @Test
    public void testValidateConfigurationMissingOutputFormat() throws IOException {
        BigQueryOutputConfiguration.configure((Configuration)conf, (String)QUALIFIED_TABLE_ID, (BigQueryTableSchema)TEST_TABLE_SCHEMA, (String)TEST_OUTPUT_PATH_STRING, (BigQueryFileFormat)TEST_FILE_FORMAT, TEST_OUTPUT_CLASS);
        conf.unset(BigQueryConfiguration.OUTPUT_FORMAT_CLASS.getKey());
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.validateConfiguration((Configuration)conf));
    }

    @Test
    public void testGetProjectId() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_PROJECT_ID);
    }

    @Test
    public void testGetProjectIdBackup() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), TEST_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_PROJECT_ID);
    }

    @Test
    public void testGetProjectIdPrecedence() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), TEST_LOAD_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_PROJECT_ID);
    }

    @Test
    public void testGetProjectIdMissing() throws IOException {
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getProjectId((Configuration)conf));
    }

    @Test
    public void testGetJobProjectId() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), TEST_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getJobProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_PROJECT_ID);
    }

    @Test
    public void testGetJobProjectIdBackup() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getJobProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_PROJECT_ID);
    }

    @Test
    public void testGetJobProjectIdPrecedence() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), TEST_LOAD_PROJECT_ID);
        String result = BigQueryOutputConfiguration.getJobProjectId((Configuration)conf);
        Truth.assertThat((String)result).isEqualTo((Object)TEST_LOAD_PROJECT_ID);
    }

    @Test
    public void testGetJobProjectIdMissing() throws IOException {
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getJobProjectId((Configuration)conf));
    }

    @Test
    public void testGetTableReference() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        conf.set(BigQueryConfiguration.OUTPUT_DATASET_ID.getKey(), TEST_DATASET_ID);
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_ID.getKey(), TEST_TABLE_ID);
        TableReference result = BigQueryOutputConfiguration.getTableReference((Configuration)conf);
        Truth.assertThat((Map)result).isEqualTo((Object)TEST_TABLE_REF);
    }

    @Test
    public void testGetTableReferenceMissingKey() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_PROJECT_ID.getKey(), TEST_PROJECT_ID);
        conf.set(BigQueryConfiguration.OUTPUT_DATASET_ID.getKey(), TEST_DATASET_ID);
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getTableReference((Configuration)conf));
    }

    @Test
    public void testGetTableReferenceBackupProjectId() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), TEST_PROJECT_ID);
        conf.set(BigQueryConfiguration.OUTPUT_DATASET_ID.getKey(), TEST_DATASET_ID);
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_ID.getKey(), TEST_PROJECT_ID);
        BigQueryOutputConfiguration.getTableReference((Configuration)conf);
    }

    @Test
    public void testGetTableReferenceSchema() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.getKey(), TEST_TABLE_SCHEMA_STRING);
        Optional result = BigQueryOutputConfiguration.getTableSchema((Configuration)conf);
        Truth.assertThat(result.get()).isEqualTo((Object)TEST_TABLE_SCHEMA);
    }

    @Test
    public void testGetTableReferenceSchemaBadSchema() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.getKey(), TEST_BAD_TABLE_SCHEMA_STRING);
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getTableSchema((Configuration)conf));
    }

    @Test
    public void testGetFileFormat() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_FILE_FORMAT.getKey(), TEST_FILE_FORMAT.name());
        BigQueryFileFormat result = BigQueryOutputConfiguration.getFileFormat((Configuration)conf);
        Truth.assertThat((Comparable)result).isEqualTo((Object)TEST_FILE_FORMAT);
    }

    @Test
    public void testGetFileFormatMissing() throws IOException {
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getFileFormat((Configuration)conf));
    }

    @Test
    public void testGetFileFormatMalformed() throws IOException {
        conf.set(BigQueryConfiguration.OUTPUT_FILE_FORMAT.getKey(), Ascii.toLowerCase((String)TEST_FILE_FORMAT.name()));
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryOutputConfiguration.getFileFormat((Configuration)conf));
    }

    @Test
    public void testGetGcsOutputPath() throws IOException {
        BigQueryOutputConfiguration.setFileOutputFormatOutputPath((Configuration)conf, (String)TEST_OUTPUT_PATH_STRING);
        Path result = BigQueryOutputConfiguration.getGcsOutputPath((Configuration)conf);
        Truth.assertThat((String)result.toString()).isEqualTo((Object)TEST_OUTPUT_PATH_STRING);
    }

    @Test
    public void testGetGcsOutputPathMissing() throws IOException {
        Assert.assertThrows(IOException.class, () -> BigQueryOutputConfiguration.getGcsOutputPath((Configuration)conf));
    }
}

