/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UnshardedInputSplitTest {
    private static final int START = 0;
    private static final int LENGTH = 60;
    private static final Path PATH = new Path("test/path");

    @Test
    public void testGetLength() {
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(PATH, 0L, 60L, new String[0]);
        Truth.assertThat((Long)bqInputSplit.getLength()).isEqualTo((Object)60);
    }

    @Test
    public void testGetLocations() throws IOException {
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(PATH, 0L, 60L, new String[0]);
        Truth.assertThat((Object[])bqInputSplit.getLocations()).hasLength(0);
    }

    @Test
    public void testGetPath() {
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(PATH, 0L, 60L, new String[0]);
        Truth.assertThat((Comparable)bqInputSplit.getPath()).isEqualTo((Object)PATH);
    }

    @Test
    public void testToString() {
        FileSplit inputSplit = new FileSplit(PATH, 0L, 60L, new String[0]);
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(PATH, 0L, 60L, new String[0]);
        Truth.assertThat((String)bqInputSplit.toString()).isEqualTo((Object)inputSplit.toString());
    }

    @Test
    public void testReadWriteFields() throws IOException {
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(PATH, 0L, 60L, new String[0]);
        UnshardedInputSplit bqResultSplit = new UnshardedInputSplit();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        bqInputSplit.write((DataOutput)out);
        out.flush();
        byte[] data = baos.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        bqResultSplit.readFields((DataInput)in);
        Truth.assertThat((Long)bqInputSplit.getLength()).isEqualTo((Object)60);
        Truth.assertThat((Long)bqInputSplit.getStart()).isEqualTo((Object)0);
        Truth.assertThat((Comparable)bqInputSplit.getPath()).isEqualTo((Object)PATH);
    }
}

