/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.UnshardedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UnshardedExportToCloudStorageTest {
    @Test
    public void testGetSplits() throws Exception {
        Configuration conf = new Configuration();
        UnshardedExportToCloudStorage export = new UnshardedExportToCloudStorage(conf, "path", ExportFileFormat.AVRO, new BigQueryHelper(null), "project-id", null, (InputFormat)new InputFormat<LongWritable, Text>(){

            public List<InputSplit> getSplits(JobContext jobContext) {
                return ImmutableList.builder().add((Object)new FileSplit(new Path("Foo"), 0L, 1L, new String[0])).add((Object)new FileSplit(new Path("Bar"), 0L, 1L, new String[0])).build();
            }

            public RecordReader<LongWritable, Text> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) {
                throw new UnsupportedOperationException("Not implemented.");
            }
        });
        List splits = export.getSplits(null);
        UnshardedInputSplit fooSplit = (UnshardedInputSplit)splits.get(0);
        Truth.assertThat((String)fooSplit.getPath().getName()).isEqualTo((Object)"Foo");
        UnshardedInputSplit barSplit = (UnshardedInputSplit)splits.get(1);
        Truth.assertThat((String)barSplit.getPath().getName()).isEqualTo((Object)"Bar");
    }
}

