/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ShardedInputSplitTest {
    private Path shardPath1;
    private Path shardPath2;
    private long numRecords1;
    private long numRecords2;
    private ShardedInputSplit split1;
    private ShardedInputSplit split2;

    @Before
    public void setUp() {
        this.shardPath1 = new Path("gs://foo-bucket/shard0/data-*.json");
        this.shardPath2 = new Path("gs://bar-bucket/shard1/part-*.csv");
        this.numRecords1 = 123L;
        this.numRecords2 = 456L;
        this.split1 = new ShardedInputSplit(this.shardPath1, this.numRecords1);
        this.split2 = new ShardedInputSplit(this.shardPath2, this.numRecords2);
    }

    @Test
    public void testGetLocations() throws IOException {
        Truth.assertThat((Object[])this.split1.getLocations()).isNotNull();
        Truth.assertThat((Object[])this.split1.getLocations()).isEmpty();
    }

    @Test
    public void testBasicFields() throws IOException {
        Truth.assertThat((Comparable)this.split1.getShardDirectoryAndPattern()).isEqualTo((Object)this.shardPath1);
        Truth.assertThat((Long)this.split1.getLength()).isEqualTo((Object)this.numRecords1);
    }

    @Test
    public void testToString() throws IOException {
        Truth.assertThat((String)this.split1.toString()).contains((CharSequence)this.shardPath1.toString());
        Truth.assertThat((String)this.split1.toString()).contains((CharSequence)Long.toString(this.numRecords1));
    }

    @Test
    public void testSerializeAndDeserializeSingle() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        this.split1.write((DataOutput)dataOut);
        dataOut.close();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        DataInputStream dataIn = new DataInputStream(byteIn);
        ShardedInputSplit recoveredSplit = new ShardedInputSplit();
        recoveredSplit.readFields((DataInput)dataIn);
        Truth.assertThat((Comparable)recoveredSplit.getShardDirectoryAndPattern()).isEqualTo((Object)this.shardPath1);
        Truth.assertThat((Long)recoveredSplit.getLength()).isEqualTo((Object)this.numRecords1);
    }

    @Test
    public void testSerializeAndDeserializeMultiple() throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        this.split1.write((DataOutput)dataOut);
        this.split2.write((DataOutput)dataOut);
        dataOut.close();
        ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
        DataInputStream dataIn = new DataInputStream(byteIn);
        ShardedInputSplit recoveredSplit = new ShardedInputSplit();
        recoveredSplit.readFields((DataInput)dataIn);
        Truth.assertThat((Comparable)recoveredSplit.getShardDirectoryAndPattern()).isEqualTo((Object)this.shardPath1);
        Truth.assertThat((Long)recoveredSplit.getLength()).isEqualTo((Object)this.numRecords1);
        recoveredSplit.readFields((DataInput)dataIn);
        Truth.assertThat((Comparable)recoveredSplit.getShardDirectoryAndPattern()).isEqualTo((Object)this.shardPath2);
        Truth.assertThat((Long)recoveredSplit.getLength()).isEqualTo((Object)this.numRecords2);
    }
}

