/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.Bucket;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorage;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageTestUtils;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.io.bigquery.AbstractBigQueryIoIntegrationTestBase;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.IndirectBigQueryOutputFormat;
import com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RegionalIntegrationTest {
    private static final String RANDOM_STRING = UUID.randomUUID().toString().substring(0, 4);
    private static final String LOCATION = "asia-northeast1";
    private static final String TEST_BUCKET_PREFIX = "bq_integration_test";
    private static final String PROJECT_ID = TestConfiguration.getInstance().getProjectId();
    private static final String DATASET_ID = ("bq_integration_test_asia-northeast1_" + RANDOM_STRING).replace('-', '_');
    private static final String QUALIFIED_TABLE_ID_FMT = "%s:%s.%s";
    private Configuration conf;
    private Bigquery bigquery;
    private GoogleCloudStorage gcs;
    private GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper;
    private Job job;

    @Before
    public void setup() throws Exception {
        Assume.assumeFalse((String)"Test is not VPCSC compatible", (boolean)Boolean.parseBoolean(System.getenv("GOOGLE_CLOUD_TESTS_IN_VPCSC")));
        this.bucketHelper = new GoogleCloudStorageTestHelper.TestBucketHelper(TEST_BUCKET_PREFIX);
        String testBucket = this.bucketHelper.getUniqueBucketName(LOCATION);
        ArrayList<BigQueryTableFieldSchema> outputTableFieldSchema = new ArrayList<BigQueryTableFieldSchema>();
        outputTableFieldSchema.add(new BigQueryTableFieldSchema().setName("Word").setType("STRING"));
        outputTableFieldSchema.add(new BigQueryTableFieldSchema().setName("Count").setType("INTEGER"));
        BigQueryTableSchema outputSchema = new BigQueryTableSchema().setFields(outputTableFieldSchema);
        this.conf = AbstractBigQueryIoIntegrationTestBase.getConfigForGcsFromBigquerySettings(PROJECT_ID);
        this.conf.set(BigQueryConfiguration.GCS_BUCKET.getKey(), testBucket);
        String qualifiedInputTableId = String.format(QUALIFIED_TABLE_ID_FMT, PROJECT_ID, DATASET_ID, "shakespeare");
        String qualifiedOutputTableId = String.format(QUALIFIED_TABLE_ID_FMT, PROJECT_ID, DATASET_ID, "shakespeare_word_count");
        String outputGcsPath = "gs://" + testBucket + "/test-output";
        this.job = Job.getInstance((Configuration)this.conf, (String)"wordcount");
        this.conf = this.job.getConfiguration();
        this.conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), PROJECT_ID);
        this.conf.set(BigQueryConfiguration.DATA_LOCATION.getKey(), LOCATION);
        BigQueryConfiguration.configureBigQueryInput((Configuration)this.conf, (String)qualifiedInputTableId);
        BigQueryOutputConfiguration.configure((Configuration)this.conf, (String)qualifiedOutputTableId, (BigQueryTableSchema)outputSchema, (String)outputGcsPath, (BigQueryFileFormat)BigQueryFileFormat.NEWLINE_DELIMITED_JSON, TextOutputFormat.class);
        this.job.setOutputKeyClass(Text.class);
        this.job.setOutputValueClass(LongWritable.class);
        this.job.setMapperClass(Map.class);
        this.job.setReducerClass(Reduce.class);
        this.job.setInputFormatClass(GsonBigQueryInputFormat.class);
        this.job.setOutputFormatClass(IndirectBigQueryOutputFormat.class);
        this.bigquery = new BigQueryFactory().getBigQuery(this.conf);
        BigQueryHelper bigqueryHelper = new BigQueryHelper(this.bigquery);
        Storage storage = new Storage.Builder(GoogleCloudStorageTestUtils.HTTP_TRANSPORT, GoogleCloudStorageTestUtils.JSON_FACTORY, (HttpRequestInitializer)new RetryHttpInitializer(GoogleCloudStorageTestHelper.getCredential(), BigQueryFactory.BQC_ID)).setApplicationName(BigQueryFactory.BQC_ID).build();
        GoogleCloudStorageFileSystem gcsFs = GoogleCloudStorageFileSystemIntegrationHelper.createGcsFs((String)PROJECT_ID);
        this.gcs = gcsFs.getGcs();
        String exportBucket = this.bucketHelper.getUniqueBucketName("us");
        storage.buckets().insert(PROJECT_ID, new Bucket().setName(exportBucket).setLocation("US")).executeUnparsed();
        bigqueryHelper.exportBigQueryToGcs(PROJECT_ID, new TableReference().setProjectId("bigquery-public-data").setDatasetId("samples").setTableId("shakespeare"), (List)ImmutableList.of((Object)("gs://" + exportBucket + "/shakespeare")), true);
        storage.buckets().insert(PROJECT_ID, new Bucket().setName(testBucket).setLocation(LOCATION)).executeUnparsed();
        gcsFs.rename(new URI("gs://" + exportBucket + "/shakespeare"), new URI("gs://" + testBucket + "/shakespeare"));
        this.bigquery.datasets().insert(PROJECT_ID, new Dataset().setLocation(LOCATION).setDatasetReference(new DatasetReference().setProjectId(PROJECT_ID).setDatasetId(DATASET_ID))).executeUnparsed();
        bigqueryHelper.importFromGcs(PROJECT_ID, new TableReference().setProjectId(PROJECT_ID).setDatasetId(DATASET_ID).setTableId("shakespeare"), null, null, null, BigQueryFileFormat.NEWLINE_DELIMITED_JSON, (String)BigQueryConfiguration.OUTPUT_TABLE_CREATE_DISPOSITION.getDefault(), "WRITE_EMPTY", (List)ImmutableList.of((Object)("gs://" + testBucket + "/shakespeare")), true);
    }

    @Test
    public void testRegionalMapReduce() throws Exception {
        this.job.waitForCompletion(true);
    }

    @After
    public void tearDown() throws Exception {
        if (this.job == null) {
            return;
        }
        try {
            GsonBigQueryInputFormat.cleanupJob((Configuration)this.job.getConfiguration(), (JobID)this.job.getJobID());
        }
        finally {
            this.bucketHelper.cleanup(this.gcs);
            this.bigquery.datasets().delete(PROJECT_ID, DATASET_ID).setDeleteContents(Boolean.valueOf(true)).executeUnparsed();
        }
    }

    public static class Reduce
    extends Reducer<Text, LongWritable, JsonObject, NullWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long count = 0L;
            for (LongWritable val : values) {
                count += val.get();
            }
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("Word", key.toString());
            jsonObject.addProperty("Count", (Number)count);
            context.write((Object)jsonObject, (Object)NullWritable.get());
        }
    }

    public static class Map
    extends Mapper<LongWritable, JsonObject, Text, LongWritable> {
        private static final LongWritable ONE = new LongWritable(1L);
        private final Text word = new Text();

        public void map(LongWritable key, JsonObject value, Mapper.Context context) throws IOException, InterruptedException {
            JsonElement countElement = value.get("word");
            if (countElement != null) {
                String wordInRecord = countElement.getAsString();
                this.word.set(wordInRecord);
                context.write((Object)this.word, (Object)ONE);
            }
        }
    }
}

