/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.ExternalDataConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.ExportFileFormat;
import com.google.cloud.hadoop.io.bigquery.NoopFederatedExportToCloudStorage;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class NoopFederatedExportToCloudStorageTest {
    private Table table;
    private Configuration conf;
    private final BigQueryHelper helper = new BigQueryHelper(null);
    private final String projectId = "project-id";

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.table = new Table().setExternalDataConfiguration(new ExternalDataConfiguration().setSourceFormat("AVRO").setSourceUris((List)ImmutableList.of((Object)"gs://foo-bucket/bar-dir/glob-*.avro", (Object)"gs://foo-bucket/bar-dir/file.avro")));
    }

    @Test
    public void testGetCommaSeparatedGcsPathList() throws Exception {
        String result = NoopFederatedExportToCloudStorage.getCommaSeparatedGcsPathList((Table)this.table);
        Truth.assertThat((String)result).isEqualTo((Object)"gs://foo-bucket/bar-dir/glob-*.avro,gs://foo-bucket/bar-dir/file.avro");
    }

    @Test
    public void testValidateGcsPaths() throws Exception {
        this.table.getExternalDataConfiguration().setSourceUris((List)ImmutableList.of((Object)"https://drive.google.com/open?id=1234"));
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new NoopFederatedExportToCloudStorage(this.conf, ExportFileFormat.AVRO, this.helper, "project-id", this.table, null));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"Invalid GCS resource: 'https://drive.google.com/open?id=1234'");
    }

    @Test
    public void testFormatMismatch() throws Exception {
        this.table.getExternalDataConfiguration().setSourceFormat("CSV");
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new NoopFederatedExportToCloudStorage(this.conf, ExportFileFormat.AVRO, this.helper, "project-id", this.table, null));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)"MapReduce fileFormat 'AVRO' does not match BigQuery sourceFormat 'CSV'. Use the appropriate InputFormat");
    }

    @Test
    public void testGetSplits() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        NoopFederatedExportToCloudStorage export = new NoopFederatedExportToCloudStorage(conf, ExportFileFormat.AVRO, this.helper, "project-id", this.table, (InputFormat)new InputFormat<LongWritable, Text>(){

            public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
                return ImmutableList.builder().add((Object)new FileSplit(new Path("gs://foo-bucket/bar-dir/glob-1.avro"), 0L, 1L, new String[0])).add((Object)new FileSplit(new Path("gs://foo-bucket/bar-dir/glob-2.avro"), 0L, 1L, new String[0])).add((Object)new FileSplit(new Path("gs://foo-bucket/bar-dir/file.avro"), 0L, 1L, new String[0])).build();
            }

            public RecordReader<LongWritable, Text> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
                throw new UnsupportedOperationException("Not implemented.");
            }
        });
        List splits = export.getSplits(null);
        Truth.assertThat((String)conf.get("mapreduce.input.fileinputformat.inputdir")).isEqualTo((Object)"gs://foo-bucket/bar-dir/glob-*.avro,gs://foo-bucket/bar-dir/file.avro");
        UnshardedInputSplit split1 = (UnshardedInputSplit)splits.get(0);
        Truth.assertThat((String)split1.getPath().toString()).isEqualTo((Object)"gs://foo-bucket/bar-dir/glob-1.avro");
        UnshardedInputSplit split2 = (UnshardedInputSplit)splits.get(1);
        Truth.assertThat((String)split2.getPath().toString()).isEqualTo((Object)"gs://foo-bucket/bar-dir/glob-2.avro");
        UnshardedInputSplit split3 = (UnshardedInputSplit)splits.get(2);
        Truth.assertThat((String)split3.getPath().toString()).isEqualTo((Object)"gs://foo-bucket/bar-dir/file.avro");
    }
}

