/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.GsonRecordReader;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.common.truth.Truth;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class GsonRecordReaderTest {
    private LongWritable key1 = new LongWritable(0L);
    private LongWritable key2 = new LongWritable(35L);
    private Text value1 = new Text("{'title':'Test1','value':'test_1'}");
    private Text value2 = new Text("{'title':'Test2','value':'test_2'}");
    private FileSystem ghfs;
    private Configuration config;
    private TaskAttemptID testTaskAttemptId = new TaskAttemptID(new TaskID(new JobID("", 1), true, 1), 1);

    @Before
    public void setUp() throws IOException {
        this.config = InMemoryGoogleHadoopFileSystem.getSampleConfiguration();
        this.ghfs = new InMemoryGoogleHadoopFileSystem();
    }

    @Test
    public void testIterateNextKeyValue() throws Exception {
        GsonRecordReader recordReader = this.getRecordReader(0);
        recordReader.close();
        GsonRecordReader multipleRecordReader = this.getRecordReader(60);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isFalse();
        multipleRecordReader.close();
        GsonRecordReader smallRecordReader = this.getRecordReader(30);
        Truth.assertThat((Boolean)smallRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Boolean)smallRecordReader.nextKeyValue()).isFalse();
        multipleRecordReader.close();
    }

    @Test
    public void testGetCurrentValue() throws Exception {
        JsonParser jsonParser = new JsonParser();
        JsonObject json1 = (JsonObject)jsonParser.parse(this.value1.toString());
        JsonObject json2 = (JsonObject)jsonParser.parse(this.value2.toString());
        GsonRecordReader multipleRecordReader = this.getRecordReader(60);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Object)multipleRecordReader.getCurrentValue()).isEqualTo((Object)json1);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Object)multipleRecordReader.getCurrentValue()).isEqualTo((Object)json2);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isFalse();
        Truth.assertThat((Object)multipleRecordReader.getCurrentValue()).isEqualTo((Object)json2);
        multipleRecordReader.close();
    }

    @Test
    public void testGetCurrentKey() throws Exception {
        GsonRecordReader multipleRecordReader = this.getRecordReader(60);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)multipleRecordReader.getCurrentKey()).isEqualTo((Object)this.key1);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)multipleRecordReader.getCurrentKey()).isEqualTo((Object)this.key2);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isFalse();
        Truth.assertThat((Comparable)multipleRecordReader.getCurrentKey()).isEqualTo((Object)this.key2);
        multipleRecordReader.close();
    }

    @Test
    public void testGetProgress() throws Exception {
        GsonRecordReader multipleRecordReader = this.getRecordReader(60);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Float)Float.valueOf(multipleRecordReader.getProgress())).isWithin(0.01f).of(0.58f);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Float)Float.valueOf(multipleRecordReader.getProgress())).isWithin(0.01f).of(1.0f);
        Truth.assertThat((Boolean)multipleRecordReader.nextKeyValue()).isFalse();
        Truth.assertThat((Float)Float.valueOf(multipleRecordReader.getProgress())).isWithin(0.01f).of(1.0f);
        multipleRecordReader.close();
    }

    public GsonRecordReader getRecordReader(int splitLength) throws Exception {
        TaskAttemptContext mockJob = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
        Mockito.when((Object)mockJob.getConfiguration()).thenReturn((Object)this.config);
        Mockito.when((Object)mockJob.getTaskAttemptID()).thenReturn((Object)this.testTaskAttemptId);
        Path mockPath = new Path("gs://test_bucket/test-object");
        this.ghfs.mkdirs(new Path("gs://test_bucket/"));
        GsonRecordReaderTest.writeFile(this.ghfs, mockPath, (this.value1 + "\n" + this.value2 + "\n").getBytes(StandardCharsets.UTF_8));
        UnshardedInputSplit inputSplit = new UnshardedInputSplit(mockPath, 0L, (long)splitLength, new String[0]);
        GsonRecordReader reader = new GsonRecordReader();
        reader.initialize((InputSplit)inputSplit, mockJob);
        return reader;
    }

    public static void writeFile(FileSystem ghfs, Path hadoopPath, byte[] buffer) throws IOException {
        try (FSDataOutputStream writeStream = ghfs.create(hadoopPath, true);){
            writeStream.write(buffer);
        }
    }
}

