/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.io.bigquery.AbstractBigQueryIoIntegrationTestBase;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GsonBigQueryIoIntegrationTest
extends AbstractBigQueryIoIntegrationTestBase<JsonObject> {
    public GsonBigQueryIoIntegrationTest() {
        super((InputFormat)new GsonBigQueryInputFormat());
    }

    @Override
    protected Map<String, Object> readRecord(RecordReader<?, JsonObject> recordReader) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonObject currentValue = (JsonObject)recordReader.getCurrentValue();
        for (Map.Entry entry : currentValue.entrySet()) {
            Object value;
            String key = (String)entry.getKey();
            JsonPrimitive primitiveValue = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (COMPANY_NAME_FIELD.getName().equals(key)) {
                value = primitiveValue.getAsString();
            } else if (MARKET_CAP_FIELD.getName().equals(key)) {
                value = primitiveValue.getAsInt();
            } else {
                throw new IllegalStateException("Cannot handle key " + key);
            }
            result.put(key, value);
        }
        return result;
    }
}

