/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ExternalDataConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.AbstractBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.GsonRecordReader;
import com.google.cloud.hadoop.io.bigquery.GsonRecordReaderTest;
import com.google.cloud.hadoop.io.bigquery.UnshardedInputSplit;
import com.google.cloud.hadoop.util.testing.CredentialConfigurationUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.LoggerConfig;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class GsonBigQueryInputFormatTest {
    private Text value1 = new Text("{'title':'Test1','value':'test_1'}");
    private Text value2 = new Text("{'title':'Test2','value':'test_2'}");
    private InMemoryGoogleHadoopFileSystem ghfs;
    private JobConf config;
    private String jobProjectId = "google.com:foo-project";
    private String dataProjectId = "publicdata";
    private String intermediateDataset = "test_dataset";
    private String intermediateTable = "test_table";
    @Mock
    private Bigquery mockBigquery;
    @Mock
    private Bigquery.Jobs mockBigqueryJobs;
    @Mock
    private Bigquery.Jobs.Get mockBigqueryJobsGet;
    @Mock
    private Bigquery.Jobs.Insert mockBigqueryJobsInsert;
    @Mock
    private Bigquery.Tables mockBigqueryTables;
    @Mock
    private Bigquery.Tables.Get mockBigqueryTablesGet;
    @Mock
    private InputFormat<LongWritable, Text> mockInputFormat;
    @Mock
    private TaskAttemptContext mockTaskAttemptContext;
    @Mock
    private BigQueryHelper mockBigQueryHelper;
    private JobStatus jobStatus;
    private Job jobHandle;
    private TableReference tableRef;
    private Table table;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        LoggerConfig.getConfig(GsonBigQueryInputFormat.class).setLevel(Level.FINE);
        this.config = new JobConf(InMemoryGoogleHadoopFileSystem.getSampleConfiguration());
        this.config.set(BigQueryConfiguration.PROJECT_ID.getKey(), this.jobProjectId);
        this.config.set(BigQueryConfiguration.INPUT_PROJECT_ID.getKey(), this.dataProjectId);
        this.config.set(BigQueryConfiguration.INPUT_DATASET_ID.getKey(), this.intermediateDataset);
        this.config.set(BigQueryConfiguration.INPUT_TABLE_ID.getKey(), this.intermediateTable);
        this.config.set(BigQueryConfiguration.TEMP_GCS_PATH.getKey(), "gs://test_bucket/other_path");
        this.config.setClass(AbstractBigQueryInputFormat.INPUT_FORMAT_CLASS.getKey(), GsonBigQueryInputFormat.class, AbstractBigQueryInputFormat.class);
        this.config.setBoolean(BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.getKey(), true);
        CredentialConfigurationUtil.addTestConfigurationSettings((Configuration)this.config);
        this.ghfs = new InMemoryGoogleHadoopFileSystem();
        JobReference fakeJobReference = new JobReference().setProjectId(this.jobProjectId).setJobId("bigquery-job-1234").setLocation("test-job-location");
        this.jobStatus = new JobStatus();
        this.jobStatus.setState("DONE");
        this.jobStatus.setErrorResult(null);
        this.jobHandle = new Job();
        this.jobHandle.setStatus(this.jobStatus);
        this.jobHandle.setJobReference(fakeJobReference);
        this.tableRef = new TableReference();
        this.tableRef.setProjectId(this.dataProjectId);
        this.tableRef.setDatasetId("test_dataset");
        this.tableRef.setTableId("test_table");
        this.table = new Table().setTableReference(this.tableRef).setLocation("test_location");
        Mockito.when((Object)this.mockBigQueryHelper.getRawBigquery()).thenReturn((Object)this.mockBigquery);
        Mockito.when((Object)this.mockBigquery.jobs()).thenReturn((Object)this.mockBigqueryJobs);
        Mockito.when((Object)this.mockBigqueryJobs.get((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockBigqueryJobsGet);
        Mockito.when((Object)this.mockBigqueryJobsGet.setLocation((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockBigqueryJobsGet);
        Mockito.when((Object)this.mockBigqueryJobsGet.execute()).thenReturn((Object)this.jobHandle);
        Mockito.when((Object)this.mockBigqueryJobs.insert((String)ArgumentMatchers.any(String.class), (Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)this.mockBigqueryJobsInsert);
        Mockito.when((Object)this.mockBigqueryJobsInsert.execute()).thenReturn((Object)this.jobHandle);
        Mockito.when((Object)this.mockBigquery.tables()).thenReturn((Object)this.mockBigqueryTables);
        Mockito.when((Object)this.mockBigqueryTables.get((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockBigqueryTablesGet);
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenReturn((Object)this.table);
        Mockito.when((Object)this.mockBigQueryHelper.getTable((TableReference)ArgumentMatchers.any(TableReference.class))).thenReturn((Object)this.table);
        Mockito.when((Object)this.mockBigQueryHelper.createJobReference((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)fakeJobReference);
        Mockito.when((Object)this.mockBigQueryHelper.insertJobOrFetchDuplicate((String)ArgumentMatchers.any(String.class), (Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)this.jobHandle);
    }

    @After
    public void tearDown() throws IOException {
        Path tmpPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        tmpPath.getFileSystem((Configuration)this.config).delete(tmpPath, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigQueryHelper});
    }

    @Test
    public void testCreateRecordReader() throws Exception {
        Mockito.when((Object)this.mockTaskAttemptContext.getConfiguration()).thenReturn((Object)this.config);
        Mockito.when((Object)this.mockTaskAttemptContext.getJobID()).thenReturn((Object)new JobID());
        Path mockPath = new Path("gs://test_bucket/path/test");
        this.ghfs.mkdirs(new Path("gs://test_bucket/"));
        GsonRecordReaderTest.writeFile((FileSystem)this.ghfs, mockPath, (this.value1 + "\n" + this.value2 + "\n").getBytes(StandardCharsets.UTF_8));
        UnshardedInputSplit bqInputSplit = new UnshardedInputSplit(mockPath, 0L, 60L, new String[0]);
        GsonBigQueryInputFormat gsonBigQueryInputFormat = new GsonBigQueryInputFormat();
        GsonRecordReader recordReader = (GsonRecordReader)gsonBigQueryInputFormat.createRecordReader((InputSplit)bqInputSplit, (Configuration)this.config);
        recordReader.initialize((InputSplit)bqInputSplit, this.mockTaskAttemptContext);
        Truth.assertThat((Boolean)recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Boolean)recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Boolean)recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testGetSplitsUnshardedBlocking() throws Exception {
        JobContextImpl jobContext = new JobContextImpl((Configuration)this.config, new JobID());
        Mockito.when((Object)this.mockInputFormat.getSplits((JobContext)ArgumentMatchers.eq((Object)jobContext))).thenReturn((Object)ImmutableList.of((Object)new FileSplit(new Path("file1"), 0L, 100L, new String[0])));
        GsonBigQueryInputFormatForTest gsonBigQueryInputFormat = new GsonBigQueryInputFormatForTest();
        gsonBigQueryInputFormat.setDelegateInputFormat(this.mockInputFormat);
        List splits = gsonBigQueryInputFormat.getSplits((JobContext)jobContext);
        Path baseExportPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        FileStatus baseStatus = baseExportPath.getFileSystem((Configuration)this.config).getFileStatus(baseExportPath);
        Truth.assertThat((Boolean)baseStatus.isDir()).isTrue();
        Truth.assertThat((String)((FileSplit)splits.get(0)).getPath().getName()).isEqualTo((Object)"file1");
        Truth.assertThat((String)this.config.get("mapreduce.input.fileinputformat.inputdir")).isEqualTo(BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).createJobReference((String)ArgumentMatchers.eq((Object)this.jobProjectId), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.eq((Object)"test_location"));
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).insertJobOrFetchDuplicate((String)ArgumentMatchers.eq((Object)this.jobProjectId), (Job)ArgumentMatchers.any(Job.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryTables});
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper)).getRawBigquery();
    }

    @Test
    public void testGetSplitsFederated() throws Exception {
        JobContextImpl jobContext = new JobContextImpl((Configuration)this.config, new JobID());
        this.table.setType("EXTERNAL").setExternalDataConfiguration(new ExternalDataConfiguration().setSourceFormat("NEWLINE_DELIMITED_JSON").setSourceUris((List)ImmutableList.of((Object)"gs://foo-bucket/bar.json")));
        FileSplit split = new FileSplit(new Path("gs://foo-bucket/bar.json"), 0L, 100L, new String[0]);
        Mockito.when((Object)this.mockInputFormat.getSplits((JobContext)ArgumentMatchers.eq((Object)jobContext))).thenReturn((Object)ImmutableList.of((Object)split));
        GsonBigQueryInputFormatForTest gsonBigQueryInputFormat = new GsonBigQueryInputFormatForTest();
        gsonBigQueryInputFormat.setDelegateInputFormat(this.mockInputFormat);
        List splits = gsonBigQueryInputFormat.getSplits((JobContext)jobContext);
        Truth.assertThat((Iterable)splits).hasSize(1);
        Truth.assertThat((Comparable)((FileSplit)splits.get(0)).getPath()).isEqualTo((Object)split.getPath());
        Truth.assertThat((String)this.config.get("mapreduce.input.fileinputformat.inputdir")).isEqualTo((Object)"gs://foo-bucket/bar.json");
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper, (VerificationMode)Mockito.times((int)1))).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigquery});
    }

    @Test
    public void testGetSplitsSecurityException() throws IOException {
        Mockito.when((Object)this.mockBigquery.tables()).thenReturn((Object)this.mockBigqueryTables);
        Path mockPath = new Path("gs://test_bucket/path/test");
        this.ghfs.mkdirs(new Path("gs://test_bucket/"));
        GsonRecordReaderTest.writeFile((FileSystem)this.ghfs, mockPath, (this.value1 + "\n" + this.value2 + "\n").getBytes(StandardCharsets.UTF_8));
        GsonBigQueryInputFormatForTestGeneralSecurityException gsonBigQueryInputFormat = new GsonBigQueryInputFormatForTestGeneralSecurityException();
        this.config.set("mapreduce.input.fileinputformat.inputdir", "gs://test_bucket/path/test");
        JobContextImpl jobContext = new JobContextImpl((Configuration)this.config, new JobID());
        Assert.assertThrows(IOException.class, () -> GsonBigQueryInputFormatTest.lambda$testGetSplitsSecurityException$0(gsonBigQueryInputFormat, (JobContext)jobContext));
    }

    @Test
    public void testCleanupJobWithIntermediateDeleteAndGcsDelete() throws IOException {
        this.config.setBoolean(BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.getKey(), true);
        Path tempPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        FileSystem fs = tempPath.getFileSystem((Configuration)this.config);
        fs.mkdirs(tempPath);
        Path dataFile = new Path(tempPath.toString() + "/data-00000.json");
        fs.createNewFile(dataFile);
        Truth.assertThat((Boolean)fs.exists(tempPath)).isTrue();
        Truth.assertThat((Boolean)fs.exists(dataFile)).isTrue();
        GsonBigQueryInputFormat.cleanupJob((BigQueryHelper)this.mockBigQueryHelper, (Configuration)this.config);
        Truth.assertThat((Boolean)(!fs.exists(tempPath) ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(!fs.exists(dataFile) ? 1 : 0)).isTrue();
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper, (VerificationMode)Mockito.times((int)1))).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
    }

    @Test
    public void testCleanupJobWithIntermediateDeleteNoGcsDelete() throws IOException {
        this.config.setBoolean(BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.getKey(), false);
        Path tempPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        FileSystem fs = tempPath.getFileSystem((Configuration)this.config);
        fs.mkdirs(tempPath);
        Path dataFile = new Path(tempPath.toString() + "/data-00000.json");
        fs.createNewFile(dataFile);
        Truth.assertThat((Boolean)fs.exists(tempPath)).isTrue();
        Truth.assertThat((Boolean)fs.exists(dataFile)).isTrue();
        GsonBigQueryInputFormat.cleanupJob((BigQueryHelper)this.mockBigQueryHelper, (Configuration)this.config);
        Truth.assertThat((Boolean)fs.exists(tempPath)).isTrue();
        Truth.assertThat((Boolean)fs.exists(dataFile)).isTrue();
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper, (VerificationMode)Mockito.times((int)1))).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
    }

    @Test
    public void testCleanupJobWithNoIntermediateDelete() throws IOException {
        this.config.setBoolean(BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.getKey(), true);
        Mockito.when((Object)this.mockBigQueryHelper.getTable((TableReference)ArgumentMatchers.any(TableReference.class))).thenReturn((Object)new Table());
        Path tempPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        FileSystem fs = tempPath.getFileSystem((Configuration)this.config);
        fs.mkdirs(tempPath);
        Path dataFile = new Path(tempPath.toString() + "/data-00000.json");
        fs.createNewFile(dataFile);
        Truth.assertThat((Boolean)fs.exists(tempPath)).isTrue();
        Truth.assertThat((Boolean)fs.exists(dataFile)).isTrue();
        GsonBigQueryInputFormat.cleanupJob((BigQueryHelper)this.mockBigQueryHelper, (Configuration)this.config);
        Truth.assertThat((Boolean)(!fs.exists(tempPath) ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(!fs.exists(dataFile) ? 1 : 0)).isTrue();
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper, (VerificationMode)Mockito.times((int)1))).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigquery, this.mockBigqueryTables});
    }

    @Test
    public void testCleanupJobWithIntermediateDeleteNoShardedExport() throws IOException {
        this.config.setBoolean(BigQueryConfiguration.DELETE_EXPORT_FILES_FROM_GCS.getKey(), true);
        Path tempPath = new Path((String)BigQueryConfiguration.TEMP_GCS_PATH.get((Configuration)this.config, (arg_0, arg_1) -> ((JobConf)this.config).get(arg_0, arg_1)));
        FileSystem fs = tempPath.getFileSystem((Configuration)this.config);
        fs.mkdirs(tempPath);
        Path dataFile = new Path(tempPath.toString() + "/data-00000.json");
        fs.createNewFile(dataFile);
        Truth.assertThat((Boolean)fs.exists(tempPath)).isTrue();
        Truth.assertThat((Boolean)fs.exists(dataFile)).isTrue();
        GsonBigQueryInputFormat.cleanupJob((BigQueryHelper)this.mockBigQueryHelper, (Configuration)this.config);
        Truth.assertThat((Boolean)(!fs.exists(tempPath) ? 1 : 0)).isTrue();
        Truth.assertThat((Boolean)(!fs.exists(dataFile) ? 1 : 0)).isTrue();
        ((BigQueryHelper)Mockito.verify((Object)this.mockBigQueryHelper, (VerificationMode)Mockito.times((int)1))).getTable((TableReference)ArgumentMatchers.eq((Object)this.tableRef));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigquery});
    }

    private static /* synthetic */ void lambda$testGetSplitsSecurityException$0(GsonBigQueryInputFormat gsonBigQueryInputFormat, JobContext jobContext) throws Throwable {
        gsonBigQueryInputFormat.getSplits(jobContext);
    }

    static class GsonBigQueryInputFormatForTestGeneralSecurityException
    extends GsonBigQueryInputFormat {
        GsonBigQueryInputFormatForTestGeneralSecurityException() {
        }

        public Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
            throw new GeneralSecurityException();
        }

        public BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
            throw new GeneralSecurityException();
        }
    }

    class GsonBigQueryInputFormatForTest
    extends GsonBigQueryInputFormat {
        GsonBigQueryInputFormatForTest() {
        }

        public Bigquery getBigQuery(Configuration config) throws GeneralSecurityException, IOException {
            return GsonBigQueryInputFormatTest.this.mockBigquery;
        }

        public BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
            return GsonBigQueryInputFormatTest.this.mockBigQueryHelper;
        }
    }
}

