/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.client.util.Sleeper;
import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.DynamicFileListRecordReader;
import com.google.cloud.hadoop.io.bigquery.GsonRecordReader;
import com.google.cloud.hadoop.io.bigquery.ShardedInputSplit;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.LoggerConfig;
import com.google.common.truth.Truth;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DynamicFileListRecordReaderTest {
    private static final String RECORD_0 = "{'day':'Sunday','letters':'6'}";
    private static final String RECORD_1 = "{'day':'Monday','letters':'6'}";
    private static final String RECORD_2 = "{'day':'Tuesday','letters':'7'}";
    private static final String SLEEP_ID = "test-sleep-id-12345";
    private JsonParser jsonParser = new JsonParser();
    private Configuration config;
    @Mock
    private TaskAttemptContext mockTaskContext;
    @Mock
    private Sleeper mockSleeper;
    private Path basePath;
    private Path shardPath;
    private long estimatedNumRecords;
    private ShardedInputSplit inputSplit;
    private DynamicFileListRecordReader<LongWritable, JsonObject> recordReader;
    private FileSystem fileSystem;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        LoggerConfig.getConfig(DynamicFileListRecordReader.class).setLevel(Level.FINE);
        this.config = InMemoryGoogleHadoopFileSystem.getSampleConfiguration();
        Mockito.when((Object)this.mockTaskContext.getConfiguration()).thenReturn((Object)this.config);
        this.basePath = new Path("gs://foo-bucket/");
        this.shardPath = new Path(this.basePath, "shard0/data-*.json");
        this.estimatedNumRecords = 2L;
        this.fileSystem = this.basePath.getFileSystem(this.config);
        this.fileSystem.mkdirs(this.basePath);
        this.fileSystem.mkdirs(this.shardPath.getParent());
        ((Sleeper)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(SLEEP_ID)}).when((Object)this.mockSleeper)).sleep(ArgumentMatchers.anyLong());
        this.resetRecordReader();
    }

    @After
    public void tearDown() throws IOException {
        this.fileSystem.delete(this.basePath, true);
        this.recordReader.close();
    }

    private DynamicFileListRecordReader<LongWritable, JsonObject> createReader() {
        return new DynamicFileListRecordReader((split, configuration) -> new GsonRecordReader());
    }

    private void resetRecordReader() throws Exception {
        this.inputSplit = new ShardedInputSplit(this.shardPath, this.estimatedNumRecords);
        this.recordReader = this.createReader();
        this.recordReader.initialize((InputSplit)this.inputSplit, this.mockTaskContext);
        this.recordReader.setSleeper(this.mockSleeper);
    }

    private void checkNextKeyValueWouldBlock() {
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.recordReader.nextKeyValue());
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)SLEEP_ID);
    }

    private void writeFile(Path outfile, List<String> lines) throws IOException {
        Text lineText = new Text();
        Text newLine = new Text("\n");
        try (FSDataOutputStream dataOut = this.fileSystem.create(outfile);){
            for (String line : lines) {
                lineText.set(line);
                dataOut.write(lineText.getBytes(), 0, lineText.getLength());
                dataOut.write(newLine.getBytes(), 0, newLine.getLength());
            }
        }
    }

    @Test
    public void testInitializeCreatesShardDirectory() throws Exception {
        this.fileSystem.delete(this.shardPath.getParent(), true);
        Truth.assertThat((Boolean)this.fileSystem.exists(this.shardPath.getParent())).isFalse();
        this.resetRecordReader();
        Truth.assertThat((Boolean)this.fileSystem.exists(this.shardPath.getParent())).isTrue();
    }

    @Test
    public void testGetCurrentBeforeFirstRecord() {
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isNull();
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isNull();
        Truth.assertThat((Float)Float.valueOf(this.recordReader.getProgress())).isZero();
    }

    @Test
    public void testGetProgressZeroEstimatedRecords() throws Exception {
        this.inputSplit = new ShardedInputSplit(this.shardPath, 0L);
        this.recordReader = this.createReader();
        this.recordReader.initialize((InputSplit)this.inputSplit, this.mockTaskContext);
        Truth.assertThat((Float)Float.valueOf(this.recordReader.getProgress())).isZero();
    }

    @Test
    public void testEmptyFileIsOnlyFileAndZeroIndex() throws Exception {
        this.checkNextKeyValueWouldBlock();
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-000.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isNull();
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isNull();
    }

    @Test
    public void nextKeyValue_whenNoFilesAndMaxAttemptsReached_throwsException() throws Exception {
        this.config.setInt(BigQueryConfiguration.DYNAMIC_FILE_LIST_RECORD_READER_POLL_MAX_ATTEMPTS.getKey(), 1);
        this.resetRecordReader();
        this.recordReader.setSleeper(Sleeper.DEFAULT);
        IllegalStateException e = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> this.recordReader.nextKeyValue());
        Truth.assertThat((Throwable)e).hasMessageThat().doesNotContain((CharSequence)SLEEP_ID);
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)"Couldn't obtain any files after 1 attempt(s).");
    }

    @Test
    public void testEmptyFileIsOnlyFileAndNotZeroIndex() throws IOException {
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-001.json"));
        this.checkNextKeyValueWouldBlock();
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-002.json"));
        Assert.assertThrows(IllegalStateException.class, () -> this.recordReader.nextKeyValue());
    }

    @Test
    public void testEmptyFileThenDataFile() throws Exception {
        this.checkNextKeyValueWouldBlock();
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-001.json"));
        this.checkNextKeyValueWouldBlock();
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testEmptyFileIndexLessThanOtherFileBadKnownFile() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        this.writeFile(new Path(this.shardPath.getParent(), "data-002.json"), (List<String>)ImmutableList.of((Object)RECORD_1));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-001.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_1));
        Assert.assertThrows(IllegalStateException.class, () -> this.recordReader.nextKeyValue());
    }

    @Test
    public void testEmptyFileIndexLessThanOtherFileBadNewFile() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-002.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        this.writeFile(new Path(this.shardPath.getParent(), "data-003.json"), (List<String>)ImmutableList.of((Object)RECORD_1));
        Assert.assertThrows(IllegalStateException.class, () -> this.recordReader.nextKeyValue());
    }

    @Test
    public void testSingleDataFile() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0, (Object)RECORD_1, (Object)RECORD_2));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable((long)(RECORD_0.length() + 1)));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_1));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable((long)(RECORD_0.length() + RECORD_1.length() + 2)));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_2));
        this.checkNextKeyValueWouldBlock();
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-001.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testMultipleDataFilesInSingleList() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        this.writeFile(new Path(this.shardPath.getParent(), "data-001.json"), (List<String>)ImmutableList.of((Object)RECORD_1, (Object)RECORD_2));
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-002.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_1));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable((long)(RECORD_1.length() + 1)));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_2));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testMultipleFilesThenHangBeforeEmptyFileAppears() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        this.writeFile(new Path(this.shardPath.getParent(), "data-001.json"), (List<String>)ImmutableList.of((Object)RECORD_1));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_1));
        this.checkNextKeyValueWouldBlock();
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-002.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testCloseBeforeEnd() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0, (Object)RECORD_1));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        this.recordReader.close();
    }

    @Test
    public void testThreeBatchesEndFileInMiddleBatch() throws Exception {
        this.writeFile(new Path(this.shardPath.getParent(), "data-000.json"), (List<String>)ImmutableList.of((Object)RECORD_0));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_0));
        this.checkNextKeyValueWouldBlock();
        this.writeFile(new Path(this.shardPath.getParent(), "data-001.json"), (List<String>)ImmutableList.of((Object)RECORD_1));
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), "data-003.json"));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_1));
        this.checkNextKeyValueWouldBlock();
        this.checkNextKeyValueWouldBlock();
        this.writeFile(new Path(this.shardPath.getParent(), "data-002.json"), (List<String>)ImmutableList.of((Object)RECORD_2));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isTrue();
        Truth.assertThat((Comparable)((Comparable)this.recordReader.getCurrentKey())).isEqualTo((Object)new LongWritable(0L));
        Truth.assertThat((Object)this.recordReader.getCurrentValue()).isEqualTo((Object)this.jsonParser.parse(RECORD_2));
        Truth.assertThat((Boolean)this.recordReader.nextKeyValue()).isFalse();
    }

    @Test
    public void testBadFilename() throws Exception {
        String outOfBounds = String.format("data-%d.json", 0x80000000L);
        this.fileSystem.createNewFile(new Path(this.shardPath.getParent(), outOfBounds));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> this.recordReader.nextKeyValue());
    }
}

