/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1beta1.AvroProto;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryRecordReader;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DirectBigQueryRecordReaderTest {
    private static final String RAW_SCHEMA = "{\"type\": \"record\", \"name\": \"__root__\", \"fields\": [{\"name\": \"f0_\", \"type\": [\"null\", \"long\"]}]}";
    private Schema parsedSchema;
    private static final List<Storage.ReadRowsResponse> RESPONSES_123 = ImmutableList.of((Object)Storage.ReadRowsResponse.newBuilder().setAvroRows(AvroProto.AvroRows.newBuilder().setRowCount(2L).setSerializedBinaryRows(ByteString.copyFrom((byte[])new byte[]{2, 2, 2, 4}))).build(), (Object)Storage.ReadRowsResponse.newBuilder().setAvroRows(AvroProto.AvroRows.newBuilder().setRowCount(1L).setSerializedBinaryRows(ByteString.copyFrom((byte[])new byte[]{2, 6}))).build());
    private DirectBigQueryInputFormat.DirectBigQueryInputSplit split = new DirectBigQueryInputFormat.DirectBigQueryInputSplit("session", "{\"type\": \"record\", \"name\": \"__root__\", \"fields\": [{\"name\": \"f0_\", \"type\": [\"null\", \"long\"]}]}", 5L);
    private static final Storage.Stream STREAM = Storage.Stream.newBuilder().setName("session").build();
    @Mock
    private BigQueryStorageClient bqClient;
    @Mock
    private ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRows;
    @Mock
    private TaskAttemptContext taskContext;
    @Mock
    private ServerStream<Storage.ReadRowsResponse> rowsStream;
    private DirectBigQueryRecordReader reader;

    @Before
    public void setUp() {
        Schema.Parser parser = new Schema.Parser();
        this.parsedSchema = parser.parse(RAW_SCHEMA);
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.bqClient.readRowsCallable()).thenReturn(this.readRows);
        Mockito.when((Object)this.readRows.call(Matchers.any(Storage.ReadRowsRequest.class))).thenReturn(this.rowsStream);
        this.reader = new TestDirectBigQueryRecordReader();
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.bqClient});
    }

    private void initialize() throws Exception {
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(STREAM)).build();
        this.reader.initialize((InputSplit)this.split, this.taskContext);
        ((BigQueryStorageClient)Mockito.verify((Object)this.bqClient)).readRowsCallable();
        ((ServerStreamingCallable)Mockito.verify(this.readRows)).call(ArgumentMatchers.eq((Object)request));
    }

    @Test
    public void testInitialize() throws Exception {
        this.initialize();
    }

    @Test
    public void testEmpty() throws Exception {
        Mockito.when((Object)this.rowsStream.iterator()).thenReturn((Object)ImmutableList.of().iterator());
        this.initialize();
        Truth.assertThat((Boolean)this.reader.nextKeyValue()).isFalse();
    }

    private GenericRecord avroRecord(int i) {
        GenericData.Record rec = new GenericData.Record(this.parsedSchema);
        rec.put(0, (Object)Integer.toUnsignedLong(i));
        return rec;
    }

    @Test
    public void testRead() throws Exception {
        Mockito.when((Object)this.rowsStream.iterator()).thenReturn(RESPONSES_123.iterator());
        this.initialize();
        for (int i = 1; i <= 3; ++i) {
            Truth.assertThat((Boolean)this.reader.nextKeyValue()).isTrue();
            Truth.assertThat((Comparable)this.reader.getCurrentKey()).isEqualTo((Object)NullWritable.get());
            Truth.assertThat((Object)this.reader.getCurrentValue()).isEqualTo((Object)this.avroRecord(i));
        }
        Truth.assertThat((Boolean)this.reader.nextKeyValue()).isFalse();
    }

    @Test
    public void testLimiting() throws Exception {
        Mockito.when((Object)this.rowsStream.iterator()).thenReturn(RESPONSES_123.iterator());
        this.split = new DirectBigQueryInputFormat.DirectBigQueryInputSplit("session", RAW_SCHEMA, 1L);
        this.initialize();
        Truth.assertThat((Boolean)this.reader.nextKeyValue()).isTrue();
        ((BigQueryStorageClient)Mockito.verify((Object)this.bqClient)).finalizeStream((Storage.Stream)ArgumentMatchers.eq((Object)STREAM));
        Truth.assertThat((Comparable)this.reader.getCurrentKey()).isEqualTo((Object)NullWritable.get());
        Truth.assertThat((Object)this.reader.getCurrentValue()).isEqualTo((Object)this.avroRecord(1));
        for (int i = 2; i <= 3; ++i) {
            Truth.assertThat((Boolean)this.reader.nextKeyValue()).isTrue();
            Truth.assertThat((Comparable)this.reader.getCurrentKey()).isEqualTo((Object)NullWritable.get());
            Truth.assertThat((Object)this.reader.getCurrentValue()).isEqualTo((Object)this.avroRecord(i));
        }
        Truth.assertThat((Boolean)this.reader.nextKeyValue()).isFalse();
    }

    class TestDirectBigQueryRecordReader
    extends DirectBigQueryRecordReader {
        TestDirectBigQueryRecordReader() {
        }

        protected BigQueryStorageClient getClient(Configuration conf) {
            return DirectBigQueryRecordReaderTest.this.bqClient;
        }
    }
}

