/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.storage.v1beta1.AvroProto;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryRecordReader;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class DirectBigQueryInputFormatTest {
    @Mock
    private BigQueryHelper bqHelper;
    @Mock
    private BigQueryStorageClient bqClient;
    @Mock
    private TaskAttemptContext taskContext;
    private JobConf config;
    private DirectBigQueryInputFormat input;
    private TableReference tableRef;
    private String jobProjectId = "foo-project";
    private String dataProjectId = "publicdata";
    private String datasetId = "test_dataset";
    private String tableId = "test_table";

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.tableRef = new TableReference().setProjectId(this.dataProjectId).setDatasetId(this.datasetId).setTableId(this.tableId);
        Table table = new Table().setTableReference(this.tableRef).setLocation("test_location").setNumRows(BigInteger.valueOf(23L)).setNumBytes(Long.valueOf(0x18000000L));
        Mockito.when((Object)this.bqHelper.getTable((TableReference)Matchers.any(TableReference.class))).thenReturn((Object)table);
        this.config = new JobConf();
        this.config.set(BigQueryConfiguration.PROJECT_ID.getKey(), this.jobProjectId);
        this.config.set(BigQueryConfiguration.INPUT_PROJECT_ID.getKey(), this.dataProjectId);
        this.config.set(BigQueryConfiguration.INPUT_DATASET_ID.getKey(), this.datasetId);
        this.config.set(BigQueryConfiguration.INPUT_TABLE_ID.getKey(), this.tableId);
        this.config.set("mapreduce.job.maps", "3");
        this.config.set(BigQueryConfiguration.SKEW_LIMIT.getKey(), "1.2");
        this.config.set(BigQueryConfiguration.SQL_FILTER.getKey(), "foo == 0");
        this.config.set(BigQueryConfiguration.SELECTED_FIELDS.getKey(), "foo,bar");
        this.input = new TestDirectBigQueryInputFormat();
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.bqClient});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.bqHelper});
    }

    @Test
    public void getSplits() throws IOException {
        JobContextImpl jobContext = new JobContextImpl((Configuration)this.config, new JobID());
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(TableReferenceProto.TableReference.newBuilder().setProjectId("publicdata").setDatasetId("test_dataset").setTableId("test_table")).setRequestedStreams(3).setParent("projects/foo-project").setReadOptions(ReadOptions.TableReadOptions.newBuilder().addAllSelectedFields((Iterable)ImmutableList.of((Object)"foo", (Object)"bar")).setRowRestriction("foo == 0").build()).setFormat(Storage.DataFormat.AVRO).build();
        Storage.ReadSession session = Storage.ReadSession.newBuilder().setAvroSchema(AvroProto.AvroSchema.newBuilder().setSchema("schema").build()).addAllStreams((Iterable)ImmutableList.of((Object)Storage.Stream.newBuilder().setName("stream1").build(), (Object)Storage.Stream.newBuilder().setName("stream2").build())).build();
        ImmutableList expected = ImmutableList.of((Object)new DirectBigQueryInputFormat.DirectBigQueryInputSplit("stream1", "schema", 14L), (Object)new DirectBigQueryInputFormat.DirectBigQueryInputSplit("stream2", "schema", 14L));
        Mockito.when((Object)this.bqClient.createReadSession((Storage.CreateReadSessionRequest)Matchers.any(Storage.CreateReadSessionRequest.class))).thenReturn((Object)session);
        try {
            List splits = this.input.getSplits((JobContext)jobContext);
            Truth.assertThat((Iterable)splits).containsExactlyElementsIn((Iterable)expected);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ((BigQueryHelper)Mockito.verify((Object)this.bqHelper)).getTable(this.tableRef);
        ((BigQueryStorageClient)Mockito.verify((Object)this.bqClient)).createReadSession(request);
    }

    @Test
    public void createRecordReader() {
        Truth.assertThat((Object)this.input.createRecordReader((InputSplit)new DirectBigQueryInputFormat.DirectBigQueryInputSplit("foo", "schema", 7L), this.taskContext)).isInstanceOf(DirectBigQueryRecordReader.class);
    }

    class TestDirectBigQueryInputFormat
    extends DirectBigQueryInputFormat {
        TestDirectBigQueryInputFormat() {
        }

        protected BigQueryStorageClient getClient(Configuration config) {
            return DirectBigQueryInputFormatTest.this.bqClient;
        }

        protected BigQueryHelper getBigQueryHelper(Configuration config) {
            return DirectBigQueryInputFormatTest.this.bqHelper;
        }
    }
}

