/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.ErrorProto;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.util.Progressable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryUtilsTest {
    private Bigquery mockBigQuery;
    private Progressable mockProgressable;
    private String projectId = "Test";
    private JobReference jobReference;
    private Bigquery.Jobs mockBigQueryJobs;
    private Bigquery.Jobs.Get mockJobsGet;
    private JobStatus jobStatus;
    private JobStatus notDoneJobStatus;
    private Job job;
    private Job notDoneJob;

    @Before
    public void setUp() throws IOException {
        this.jobReference = new JobReference().setJobId("test-job-id").setLocation("test-job-location");
        this.notDoneJob = new Job();
        this.notDoneJobStatus = new JobStatus();
        this.notDoneJobStatus.setState("NOT DONE");
        this.notDoneJobStatus.setErrorResult(null);
        this.notDoneJob.setStatus(this.notDoneJobStatus);
        this.notDoneJob.setJobReference(this.jobReference);
        this.job = new Job();
        this.jobStatus = new JobStatus();
        this.jobStatus.setState("DONE");
        this.jobStatus.setErrorResult(null);
        this.job.setStatus(this.jobStatus);
        this.job.setJobReference(this.jobReference);
        this.mockBigQuery = (Bigquery)Mockito.mock(Bigquery.class);
        this.mockBigQueryJobs = (Bigquery.Jobs)Mockito.mock(Bigquery.Jobs.class);
        this.mockJobsGet = (Bigquery.Jobs.Get)Mockito.mock(Bigquery.Jobs.Get.class);
        Mockito.when((Object)this.mockBigQuery.jobs()).thenReturn((Object)this.mockBigQueryJobs);
        Mockito.when((Object)this.mockBigQueryJobs.get(this.projectId, this.jobReference.getJobId())).thenReturn((Object)this.mockJobsGet).thenReturn((Object)this.mockJobsGet);
        Mockito.when((Object)this.mockJobsGet.setLocation((String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockJobsGet);
        Mockito.when((Object)this.mockJobsGet.execute()).thenReturn((Object)this.job);
        new BigQueryUtils();
        this.mockProgressable = (Progressable)Mockito.mock(Progressable.class);
    }

    @Test
    public void testWaitForJobCompletion() throws Exception {
        Mockito.when((Object)this.mockJobsGet.execute()).thenReturn((Object)this.job);
        BigQueryUtils.waitForJobCompletion((Bigquery)this.mockBigQuery, (String)this.projectId, (JobReference)this.jobReference, (Progressable)this.mockProgressable);
        ((Bigquery)Mockito.verify((Object)this.mockBigQuery)).jobs();
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigQueryJobs)).get(this.projectId, this.jobReference.getJobId());
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockJobsGet)).execute();
        ((Progressable)Mockito.verify((Object)this.mockProgressable, (VerificationMode)Mockito.never())).progress();
    }

    @Test
    public void testWaitForJobCompletionChange() throws Exception {
        Mockito.when((Object)this.mockJobsGet.execute()).thenReturn((Object)this.notDoneJob).thenReturn((Object)this.job);
        BigQueryUtils.waitForJobCompletion((Bigquery)this.mockBigQuery, (String)this.projectId, (JobReference)this.jobReference, (Progressable)this.mockProgressable);
        ((Bigquery)Mockito.verify((Object)this.mockBigQuery, (VerificationMode)Mockito.times((int)2))).jobs();
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigQueryJobs, (VerificationMode)Mockito.times((int)2))).get(this.projectId, this.jobReference.getJobId());
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockJobsGet, (VerificationMode)Mockito.times((int)2))).execute();
        ((Progressable)Mockito.verify((Object)this.mockProgressable, (VerificationMode)Mockito.atLeastOnce())).progress();
    }

    @Test
    public void testWaitForJobCompletionError() throws InterruptedException, IOException {
        Mockito.when((Object)this.mockJobsGet.execute()).thenReturn((Object)this.job);
        this.jobStatus.setErrorResult(new ErrorProto());
        IOException e = (IOException)Assert.assertThrows(IOException.class, () -> BigQueryUtils.waitForJobCompletion((Bigquery)this.mockBigQuery, (String)this.projectId, (JobReference)this.jobReference, (Progressable)this.mockProgressable));
        Truth.assertThat((Throwable)e).hasMessageThat().contains((CharSequence)this.jobReference.getJobId());
    }

    @Test
    public void testGetSchemaFromString() {
        String fields = "[{'name': 'MyName', 'type': 'STRING'},{'name': 'Number', 'type': 'INTEGER', 'mode': 'sample'}]";
        List list = BigQueryUtils.getSchemaFromString((String)fields);
        Truth.assertThat((Iterable)list).hasSize(2);
        Truth.assertThat((String)((TableFieldSchema)list.get(0)).getName()).isEqualTo((Object)"MyName");
        Truth.assertThat((String)((TableFieldSchema)list.get(0)).getType()).isEqualTo((Object)"STRING");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getName()).isEqualTo((Object)"Number");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getType()).isEqualTo((Object)"INTEGER");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getMode()).isEqualTo((Object)"sample");
    }

    @Test
    public void testGetSchemaFromStringNested() {
        String fields = "[{'name': 'MyName', 'type': 'STRING'},{'name': 'MyNestedField', 'type': 'RECORD', 'mode': 'repeated', 'fields': [{'name': 'field1', 'type': 'INTEGER'}, {'name': 'field2', 'type': 'STRING'}]}]";
        List list = BigQueryUtils.getSchemaFromString((String)fields);
        Truth.assertThat((Iterable)list).hasSize(2);
        Truth.assertThat((String)((TableFieldSchema)list.get(0)).getName()).isEqualTo((Object)"MyName");
        Truth.assertThat((String)((TableFieldSchema)list.get(0)).getType()).isEqualTo((Object)"STRING");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getName()).isEqualTo((Object)"MyNestedField");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getType()).isEqualTo((Object)"RECORD");
        Truth.assertThat((String)((TableFieldSchema)list.get(1)).getMode()).isEqualTo((Object)"repeated");
        List nestedList = ((TableFieldSchema)list.get(1)).getFields();
        Truth.assertThat((Iterable)nestedList).isNotNull();
        Truth.assertThat((Iterable)nestedList).hasSize(2);
        Truth.assertThat((String)((TableFieldSchema)nestedList.get(0)).getName()).isEqualTo((Object)"field1");
        Truth.assertThat((String)((TableFieldSchema)nestedList.get(0)).getType()).isEqualTo((Object)"INTEGER");
        Truth.assertThat((String)((TableFieldSchema)nestedList.get(1)).getName()).isEqualTo((Object)"field2");
        Truth.assertThat((String)((TableFieldSchema)nestedList.get(1)).getType()).isEqualTo((Object)"STRING");
    }

    @Test
    public void testGetSchemaFromStringWithMissingName() {
        String fields = "[{'type': 'STRING'},{'name': 'Number', 'type': 'INTEGER', 'mode': 'sample'}]";
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryUtils.getSchemaFromString((String)fields));
    }

    @Test
    public void testGetSchemaFromStringWithMissingType() {
        String fields = "[{'name': 'MyName', 'type': 'STRING'},{'name': 'Number', 'mode': 'sample'}]";
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryUtils.getSchemaFromString((String)fields));
    }

    @Test
    public void testGetSchemaFromStringWithTopLevelNonJsonObject() {
        String fields = "[{'name': 'MyName', 'type': 'STRING'},foo,{'name': 'Number', 'type': 'INTEGER', 'mode': 'sample'}]";
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryUtils.getSchemaFromString((String)fields));
    }

    @Test
    public void testGetSchemaFromStringRecordTypeLacksFields() {
        String fields = "[{'name': 'MyName', 'type': 'STRING'},{'name': 'MyNestedField', 'type': 'RECORD', 'mode': 'repeated'}]";
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryUtils.getSchemaFromString((String)fields));
    }
}

