/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryStringsTest {
    @Test
    public void testTableReferenceToStringWithNoProjectId() {
        TableReference tableRef = new TableReference().setDatasetId("foo").setTableId("bar");
        Truth.assertThat((String)BigQueryStrings.toString((TableReference)tableRef)).isEqualTo((Object)"foo.bar");
        tableRef.setProjectId("");
        Truth.assertThat((String)BigQueryStrings.toString((TableReference)tableRef)).isEqualTo((Object)"foo.bar");
    }

    @Test
    public void testTableReferenceToStringWithProjectId() {
        TableReference tableRef = new TableReference().setProjectId("foo-proj").setDatasetId("foo").setTableId("bar");
        Truth.assertThat((String)BigQueryStrings.toString((TableReference)tableRef)).isEqualTo((Object)"foo-proj:foo.bar");
    }

    @Test
    public void testToStringThrowsWhenTableIdIsNull() {
        TableReference tableRef = new TableReference().setProjectId("foo-proj").setDatasetId("foo").setTableId(null);
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.toString((TableReference)tableRef));
    }

    @Test
    public void testToStringThrowsWhenTableIdIsEmpty() {
        TableReference tableRef = new TableReference().setProjectId("foo-proj").setDatasetId("foo").setTableId("");
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.toString((TableReference)tableRef));
    }

    @Test
    public void testToStringThrowsWhenDatasetIsNull() {
        TableReference tableRef = new TableReference().setProjectId("foo-proj").setDatasetId(null).setTableId("tableId");
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.toString((TableReference)tableRef));
    }

    @Test
    public void testToStringThrowsWhenDatasetIsEmpty() {
        TableReference tableRef = new TableReference().setProjectId("foo-proj").setDatasetId("").setTableId("tableId");
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.toString((TableReference)tableRef));
    }

    @Test
    public void testParseTableReferenceNoProject() {
        TableReference tableRef = BigQueryStrings.parseTableReference((String)"fooA1_.2bar");
        Truth.assertThat((String)tableRef.getProjectId()).isNull();
        Truth.assertThat((String)tableRef.getDatasetId()).isEqualTo((Object)"fooA1_");
        Truth.assertThat((String)tableRef.getTableId()).isEqualTo((Object)"2bar");
    }

    @Test
    public void testParseTableReferenceWithProject() {
        TableReference tableRef = BigQueryStrings.parseTableReference((String)"google.com:foo-proj:foo.bar");
        Truth.assertThat((String)tableRef.getProjectId()).isEqualTo((Object)"google.com:foo-proj");
        Truth.assertThat((String)tableRef.getDatasetId()).isEqualTo((Object)"foo");
        Truth.assertThat((String)tableRef.getTableId()).isEqualTo((Object)"bar");
    }

    @Test
    public void testParseTableReferenceThrowsWhenDashesArePresent() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.parseTableReference((String)"foo-o.bar"));
    }

    @Test
    public void testParseTableReferenceThrowsWhenNoDotsPresent() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.parseTableReference((String)"foo"));
    }

    @Test
    public void testParseTableReferenceThrowsWhenOnlyOneDotPresent() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.parseTableReference((String)"p.foo:bar"));
    }

    @Test
    public void testParseTableReferenceThrowsWhenDatasetIsEmpty() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.parseTableReference((String)"foo."));
    }

    @Test
    public void testParseTableReferenceThrowsWhenTableIsEmpty() {
        Assert.assertThrows(IllegalArgumentException.class, () -> BigQueryStrings.parseTableReference((String)".bar"));
    }
}

