/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.cloud.hadoop.util.ApiErrorExtractor;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.LoggerConfig;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigQueryHelperTest {
    @Mock
    private Bigquery mockBigquery;
    @Mock
    private Bigquery.Jobs mockBigqueryJobs;
    @Mock
    private Bigquery.Jobs.Get mockBigqueryJobsGet;
    @Mock
    private Bigquery.Jobs.Insert mockBigqueryJobsInsert;
    @Mock
    private Bigquery.Tables mockBigqueryTables;
    @Mock
    private Bigquery.Tables.Get mockBigqueryTablesGet;
    @Mock
    private ApiErrorExtractor mockErrorExtractor;
    private JobStatus jobStatus;
    private Job jobHandle;
    private Table fakeTable;
    private TableSchema fakeTableSchema;
    private String jobProjectId = "google.com:foo-project";
    private final String kmsKeyName = "projects/google.com:foo-project/locations/us-west1/keyRings/ring-1/cryptoKeys/key-1";
    private TableReference tableRef;
    private String projectId = "google.com:bar-project";
    private String datasetId = "test_dataset";
    private String tableId = "test_table";
    private String jobId = "bigquery-job-1234";
    private BigQueryHelper helper;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        LoggerConfig.getConfig(GsonBigQueryInputFormat.class).setLevel(Level.FINE);
        JobReference fakeJobReference = new JobReference().setProjectId(this.jobProjectId).setJobId(this.jobId);
        this.jobStatus = new JobStatus();
        this.jobStatus.setState("DONE");
        this.jobStatus.setErrorResult(null);
        this.jobHandle = new Job();
        this.jobHandle.setStatus(this.jobStatus);
        this.jobHandle.setJobReference(fakeJobReference);
        Mockito.when((Object)this.mockBigquery.jobs()).thenReturn((Object)this.mockBigqueryJobs);
        Mockito.when((Object)this.mockBigqueryJobs.get((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockBigqueryJobsGet);
        Mockito.when((Object)this.mockBigqueryJobsGet.setLocation((String)ArgumentMatchers.any())).thenReturn((Object)this.mockBigqueryJobsGet);
        Mockito.when((Object)this.mockBigqueryJobs.insert((String)ArgumentMatchers.any(String.class), (Job)ArgumentMatchers.any(Job.class))).thenReturn((Object)this.mockBigqueryJobsInsert);
        this.fakeTableSchema = new TableSchema();
        this.fakeTable = new Table().setSchema(this.fakeTableSchema).setLocation("test_location");
        Mockito.when((Object)this.mockBigquery.tables()).thenReturn((Object)this.mockBigqueryTables);
        Mockito.when((Object)this.mockBigqueryTables.get((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)this.mockBigqueryTablesGet);
        Bigquery.Datasets datasets = (Bigquery.Datasets)Mockito.mock(Bigquery.Datasets.class);
        Bigquery.Datasets.Get datasetsGet = (Bigquery.Datasets.Get)Mockito.mock(Bigquery.Datasets.Get.class);
        Dataset dataset = new Dataset().setLocation("test_location");
        Mockito.when((Object)this.mockBigquery.datasets()).thenReturn((Object)datasets);
        Mockito.when((Object)datasets.get((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class))).thenReturn((Object)datasetsGet);
        Mockito.when((Object)datasetsGet.execute()).thenReturn((Object)dataset);
        this.tableRef = new TableReference();
        this.tableRef.setProjectId(this.projectId);
        this.tableRef.setDatasetId(this.datasetId);
        this.tableRef.setTableId(this.tableId);
        this.helper = new BigQueryHelper(this.mockBigquery);
        this.helper.setErrorExtractor(this.mockErrorExtractor);
    }

    @After
    public void tearDown() {
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigquery});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryJobs});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryJobsGet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryJobsInsert});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryTables});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockBigqueryTablesGet});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockErrorExtractor});
    }

    @Test
    public void testImportBigQueryFromGcs() throws Exception {
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenReturn((Object)this.fakeTable);
        final ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Bigquery.Jobs.Insert)Mockito.doAnswer((Answer)new Answer<Job>(){

            public Job answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((Bigquery.Jobs)Mockito.verify((Object)BigQueryHelperTest.this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).insert((String)ArgumentMatchers.eq((Object)BigQueryHelperTest.this.jobProjectId), (Job)jobCaptor.capture());
                return (Job)jobCaptor.getValue();
            }
        }).when((Object)this.mockBigqueryJobsInsert)).execute();
        Mockito.when((Object)this.mockBigqueryJobsGet.execute()).thenReturn((Object)this.jobHandle);
        this.helper.importFromGcs(this.jobProjectId, this.tableRef, this.fakeTableSchema, null, "projects/google.com:foo-project/locations/us-west1/keyRings/ring-1/cryptoKeys/key-1", BigQueryFileFormat.NEWLINE_DELIMITED_JSON, (String)BigQueryConfiguration.OUTPUT_TABLE_CREATE_DISPOSITION.getDefault(), (String)BigQueryConfiguration.OUTPUT_TABLE_WRITE_DISPOSITION.getDefault(), (List)ImmutableList.of((Object)"test-import-path"), true);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)2))).jobs();
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.jobProjectId), (String)ArgumentMatchers.eq((Object)((Job)jobCaptor.getValue()).getJobReference().getJobId()));
        Job job = (Job)jobCaptor.getValue();
        Truth.assertThat((Iterable)job.getConfiguration().getLoad().getSourceUris()).contains((Object)"test-import-path");
        Truth.assertThat((Map)job.getConfiguration().getLoad().getDestinationTable()).isEqualTo((Object)this.tableRef);
        Truth.assertThat((String)job.getJobReference().getLocation()).isEqualTo((Object)"test_location");
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet)).setLocation((String)ArgumentMatchers.eq((Object)"test_location"));
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet, (VerificationMode)Mockito.times((int)1))).execute();
        ((Bigquery.Jobs.Insert)Mockito.verify((Object)this.mockBigqueryJobsInsert, (VerificationMode)Mockito.times((int)1))).execute();
        ((Bigquery)Mockito.verify((Object)this.mockBigquery)).datasets();
    }

    @Test
    public void testExportBigQueryToGcsSingleShardAwaitCompletion() throws Exception {
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenReturn((Object)this.fakeTable);
        final ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Bigquery.Jobs.Insert)Mockito.doAnswer((Answer)new Answer<Job>(){

            public Job answer(InvocationOnMock invocationOnMock) throws Throwable {
                ((Bigquery.Jobs)Mockito.verify((Object)BigQueryHelperTest.this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).insert((String)ArgumentMatchers.eq((Object)BigQueryHelperTest.this.jobProjectId), (Job)jobCaptor.capture());
                return (Job)jobCaptor.getValue();
            }
        }).when((Object)this.mockBigqueryJobsInsert)).execute();
        Mockito.when((Object)this.mockBigqueryJobsGet.execute()).thenReturn((Object)this.jobHandle);
        this.helper.exportBigQueryToGcs(this.jobProjectId, this.tableRef, (List)ImmutableList.of((Object)"test-export-path"), true);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)2))).jobs();
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.jobProjectId), (String)ArgumentMatchers.eq((Object)((Job)jobCaptor.getValue()).getJobReference().getJobId()));
        Job job = (Job)jobCaptor.getValue();
        Truth.assertThat((String)((String)job.getConfiguration().getExtract().getDestinationUris().get(0))).isEqualTo((Object)"test-export-path");
        Truth.assertThat((Map)job.getConfiguration().getExtract().getSourceTable()).isEqualTo((Object)this.tableRef);
        Truth.assertThat((String)job.getJobReference().getLocation()).isEqualTo((Object)"test_location");
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet)).setLocation((String)ArgumentMatchers.eq((Object)"test_location"));
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet, (VerificationMode)Mockito.times((int)1))).execute();
        ((Bigquery.Jobs.Insert)Mockito.verify((Object)this.mockBigqueryJobsInsert, (VerificationMode)Mockito.times((int)1))).execute();
        ((Bigquery)Mockito.verify((Object)this.mockBigquery)).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockBigqueryTables)).get((String)ArgumentMatchers.eq((Object)this.projectId), (String)ArgumentMatchers.eq((Object)this.datasetId), (String)ArgumentMatchers.eq((Object)this.tableId));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockBigqueryTablesGet)).execute();
    }

    @Test
    public void testGetTable() throws IOException {
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenReturn((Object)this.fakeTable);
        Table table = this.helper.getTable(this.tableRef);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockBigqueryTables, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.projectId), (String)ArgumentMatchers.eq((Object)this.datasetId), (String)ArgumentMatchers.eq((Object)this.tableId));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockBigqueryTablesGet, (VerificationMode)Mockito.times((int)1))).execute();
        Truth.assertThat((Map)this.fakeTable).isEqualTo((Object)table);
    }

    @Test
    public void testTableExistsTrue() throws IOException {
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenReturn((Object)this.fakeTable);
        boolean exists = this.helper.tableExists(this.tableRef);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockBigqueryTables, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.projectId), (String)ArgumentMatchers.eq((Object)this.datasetId), (String)ArgumentMatchers.eq((Object)this.tableId));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockBigqueryTablesGet, (VerificationMode)Mockito.times((int)1))).execute();
        Truth.assertThat((Boolean)exists).isTrue();
    }

    @Test
    public void testTableExistsFalse() throws IOException {
        IOException fakeNotFoundException = new IOException("Fake not found exception");
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenThrow(new Throwable[]{fakeNotFoundException});
        Mockito.when((Object)this.mockErrorExtractor.itemNotFound((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)true);
        boolean exists = this.helper.tableExists(this.tableRef);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockBigqueryTables, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.projectId), (String)ArgumentMatchers.eq((Object)this.datasetId), (String)ArgumentMatchers.eq((Object)this.tableId));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockBigqueryTablesGet, (VerificationMode)Mockito.times((int)1))).execute();
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)1))).itemNotFound((IOException)ArgumentMatchers.eq((Object)fakeNotFoundException));
        Truth.assertThat((Boolean)exists).isFalse();
    }

    @Test
    public void testTableExistsUnhandledException() throws IOException {
        IOException fakeUnhandledException = new IOException("Fake unhandled exception");
        Mockito.when((Object)this.mockBigqueryTablesGet.execute()).thenThrow(new Throwable[]{fakeUnhandledException});
        Mockito.when((Object)this.mockErrorExtractor.itemNotFound((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.helper.tableExists(this.tableRef));
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)fakeUnhandledException);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).tables();
        ((Bigquery.Tables)Mockito.verify((Object)this.mockBigqueryTables, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.projectId), (String)ArgumentMatchers.eq((Object)this.datasetId), (String)ArgumentMatchers.eq((Object)this.tableId));
        ((Bigquery.Tables.Get)Mockito.verify((Object)this.mockBigqueryTablesGet, (VerificationMode)Mockito.times((int)1))).execute();
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor, (VerificationMode)Mockito.times((int)1))).itemNotFound((IOException)ArgumentMatchers.eq((Object)fakeUnhandledException));
    }

    @Test
    public void testInsertJobOrFetchDuplicateBasicInsert() throws IOException {
        Mockito.when((Object)this.mockBigqueryJobsInsert.execute()).thenReturn((Object)this.jobHandle);
        Truth.assertThat((Map)this.helper.insertJobOrFetchDuplicate(this.jobProjectId, this.jobHandle)).isEqualTo((Object)this.jobHandle);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).jobs();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).insert((String)ArgumentMatchers.eq((Object)this.jobProjectId), (Job)jobCaptor.capture());
        Job job = (Job)jobCaptor.getValue();
        Truth.assertThat((Map)job).isEqualTo((Object)this.jobHandle);
        ((Bigquery.Jobs.Insert)Mockito.verify((Object)this.mockBigqueryJobsInsert, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void testInsertJobOrFetchDuplicateAlreadyExistsException() throws IOException {
        IOException fakeConflictException = new IOException("fake 409 conflict");
        Mockito.when((Object)this.mockBigqueryJobsInsert.execute()).thenThrow(new Throwable[]{fakeConflictException});
        Mockito.when((Object)this.mockErrorExtractor.itemAlreadyExists((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)true);
        Mockito.when((Object)this.mockBigqueryJobsGet.execute()).thenReturn((Object)this.jobHandle);
        Truth.assertThat((Map)this.helper.insertJobOrFetchDuplicate(this.jobProjectId, this.jobHandle)).isEqualTo((Object)this.jobHandle);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)2))).jobs();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).insert((String)ArgumentMatchers.eq((Object)this.jobProjectId), (Job)jobCaptor.capture());
        Job job = (Job)jobCaptor.getValue();
        Truth.assertThat((Map)job).isEqualTo((Object)this.jobHandle);
        ((Bigquery.Jobs.Insert)Mockito.verify((Object)this.mockBigqueryJobsInsert, (VerificationMode)Mockito.times((int)1))).execute();
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).get((String)ArgumentMatchers.eq((Object)this.jobProjectId), (String)ArgumentMatchers.eq((Object)this.jobId));
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet, (VerificationMode)Mockito.times((int)1))).setLocation((String)ArgumentMatchers.eq(null));
        ((Bigquery.Jobs.Get)Mockito.verify((Object)this.mockBigqueryJobsGet, (VerificationMode)Mockito.times((int)1))).execute();
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).itemAlreadyExists((IOException)ArgumentMatchers.eq((Object)fakeConflictException));
    }

    @Test
    public void testInsertJobOrFetchDuplicateUnhandledException() throws IOException {
        IOException unhandledException = new IOException("unhandled exception");
        Mockito.when((Object)this.mockBigqueryJobsInsert.execute()).thenThrow(new Throwable[]{unhandledException});
        Mockito.when((Object)this.mockErrorExtractor.itemAlreadyExists((IOException)ArgumentMatchers.any(IOException.class))).thenReturn((Object)false);
        IOException thrown = (IOException)Assert.assertThrows(IOException.class, () -> this.helper.insertJobOrFetchDuplicate(this.jobProjectId, this.jobHandle));
        Truth.assertThat((Throwable)thrown).hasMessageThat().contains((CharSequence)this.jobHandle.toString());
        Truth.assertThat((Throwable)thrown).hasCauseThat().isEqualTo((Object)unhandledException);
        ((Bigquery)Mockito.verify((Object)this.mockBigquery, (VerificationMode)Mockito.times((int)1))).jobs();
        ArgumentCaptor jobCaptor = ArgumentCaptor.forClass(Job.class);
        ((Bigquery.Jobs)Mockito.verify((Object)this.mockBigqueryJobs, (VerificationMode)Mockito.times((int)1))).insert((String)ArgumentMatchers.eq((Object)this.jobProjectId), (Job)jobCaptor.capture());
        Job job = (Job)jobCaptor.getValue();
        Truth.assertThat((Map)job).isEqualTo((Object)this.jobHandle);
        ((Bigquery.Jobs.Insert)Mockito.verify((Object)this.mockBigqueryJobsInsert, (VerificationMode)Mockito.times((int)1))).execute();
        ((ApiErrorExtractor)Mockito.verify((Object)this.mockErrorExtractor)).itemAlreadyExists((IOException)ArgumentMatchers.eq((Object)unhandledException));
    }
}

