/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.util.testing.CredentialConfigurationUtil;
import com.google.common.truth.Truth;
import org.apache.hadoop.conf.Configuration;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryFactoryTest {
    @Test
    public void getBigQuery_localDev() throws Exception {
        BigQueryFactory factory = new BigQueryFactory();
        Configuration configuration = CredentialConfigurationUtil.getTestConfiguration();
        Bigquery bigquery = factory.getBigQuery(configuration);
        Truth.assertThat((Object)bigquery).isNotNull();
        Truth.assertThat((String)bigquery.getRootUrl()).isEqualTo((Object)"https://bigquery.googleapis.com/");
    }

    @Test
    public void getBigQuery_customEndpoint() throws Exception {
        BigQueryFactory factory = new BigQueryFactory();
        Configuration configuration = CredentialConfigurationUtil.getTestConfiguration();
        configuration.set(BigQueryConfiguration.BQ_ROOT_URL.getKey(), "https://unit-test-bigquery.googleapis.com/");
        Bigquery bigquery = factory.getBigQuery(configuration);
        Truth.assertThat((Object)bigquery).isNotNull();
        Truth.assertThat((String)bigquery.getRootUrl()).isEqualTo((Object)"https://unit-test-bigquery.googleapis.com/");
    }

    @Test
    public void testVersionString() {
        Truth.assertThat((String)BigQueryFactory.VERSION).isNotNull();
        Truth.assertThat((Boolean)"0.0.0".equals(BigQueryFactory.VERSION)).isFalse();
    }
}

