/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.fs.gcs.InMemoryGoogleHadoopFileSystem;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.util.testing.HadoopConfigurationUtils;
import com.google.common.base.Preconditions;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobID;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class BigQueryConfigurationTest {
    private static final Map<String, Object> expectedDefaultConfiguration = new HashMap<String, Object>(){
        {
            this.put("mapred.bq.bigquery.root.url", "https://bigquery.googleapis.com/");
            this.put("mapred.bq.dynamic.file.list.record.reader.poll.interval", 10000);
            this.put("mapred.bq.dynamic.file.list.record.reader.poll.max.attempts", -1);
            this.put("mapred.bq.gcs.bucket", null);
            this.put("mapred.bq.input.dataset.id", null);
            this.put("mapred.bq.input.export.files.delete", true);
            this.put("mapred.bq.input.project.id", null);
            this.put("mapred.bq.input.selected.fields", null);
            this.put("mapred.bq.input.skew.limit", 1.5);
            this.put("mapred.bq.input.sql.filter", "");
            this.put("mapred.bq.input.table.id", null);
            this.put("mapred.bq.output.dataset.id", null);
            this.put("mapred.bq.output.gcs.cleanup", true);
            this.put("mapred.bq.output.gcs.fileformat", null);
            this.put("mapred.bq.output.gcs.outputformatclass", null);
            this.put("mapred.bq.output.location", "US");
            this.put("mapred.bq.output.project.id", null);
            this.put("mapred.bq.output.table.createdisposition", "CREATE_IF_NEEDED");
            this.put("mapred.bq.output.table.id", null);
            this.put("mapred.bq.output.table.kmskeyname", null);
            this.put("mapred.bq.output.table.partitioning", null);
            this.put("mapred.bq.output.table.schema", null);
            this.put("mapred.bq.output.table.writedisposition", "WRITE_APPEND");
            this.put("mapred.bq.project.id", null);
            this.put("mapred.bq.temp.gcs.path", null);
        }
    };
    private static final String JOB_PROJECT_ID = "google.com:foo-project";
    private static final String INPUT_PROJECT_ID = "google.com:input-project";
    private static final String INPUT_DATASET_ID = "test_input_dataset";
    private static final String INPUT_TABLE_ID = "test_input_table";
    private static final String OUTPUT_PROJECT_ID = "google.com:output-project";
    private static final String OUTPUT_DATASET_ID = "test_output_dataset";
    private static final String OUTPUT_TABLE_ID = "test_output_table";
    private static final String OUTPUT_TABLE_SCHEMA = "test_schema";
    private static final String GCS_BUCKET = "test";
    private static final String GCS_TEMP_PATH = "gs://test";
    private static JobConf conf;
    @Mock
    private JobID mockJobID;

    @Before
    public void setUp() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        Configuration config = InMemoryGoogleHadoopFileSystem.getSampleConfiguration();
        conf = new JobConf(config);
        new BigQueryConfiguration();
    }

    @Test
    public void testGetTemporaryPathRootSpecific() throws IOException {
        conf.set(BigQueryConfiguration.TEMP_GCS_PATH.getKey(), GCS_TEMP_PATH);
        Truth.assertThat((String)BigQueryConfiguration.getTemporaryPathRoot((Configuration)conf, (JobID)this.mockJobID)).isEqualTo((Object)GCS_TEMP_PATH);
    }

    @Test
    public void testGetTemporaryPathRootDefault() throws IOException {
        conf.set(BigQueryConfiguration.GCS_BUCKET.getKey(), GCS_BUCKET);
        Mockito.when((Object)this.mockJobID.toString()).thenReturn((Object)"test_job_id");
        Preconditions.checkNotNull((Object)BigQueryConfiguration.getTemporaryPathRoot((Configuration)conf, (JobID)this.mockJobID));
    }

    @Test
    public void testConfigureBigQueryInput() throws IOException {
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)INPUT_PROJECT_ID, (String)INPUT_DATASET_ID, (String)INPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_PROJECT_ID);
    }

    @Test
    public void testConfigureBigQueryOutput() throws IOException {
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)OUTPUT_PROJECT_ID, (String)OUTPUT_DATASET_ID, (String)OUTPUT_TABLE_ID, (String)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_PROJECT_ID);
    }

    @Test
    public void testConfigureBigQueryInputThenOutput() throws IOException {
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)INPUT_PROJECT_ID, (String)INPUT_DATASET_ID, (String)INPUT_TABLE_ID);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)OUTPUT_PROJECT_ID, (String)OUTPUT_DATASET_ID, (String)OUTPUT_TABLE_ID, (String)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_PROJECT_ID);
    }

    @Test
    public void testConfigureBigQueryInputThenOutputWithPresetJobProject() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), JOB_PROJECT_ID);
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)INPUT_PROJECT_ID, (String)INPUT_DATASET_ID, (String)INPUT_TABLE_ID);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)OUTPUT_PROJECT_ID, (String)OUTPUT_DATASET_ID, (String)OUTPUT_TABLE_ID, (String)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
    }

    @Test
    public void testConfigureBigQueryDefaultToJobProject() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), JOB_PROJECT_ID);
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)"", (String)INPUT_DATASET_ID, (String)INPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_TABLE_ID);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, null, (String)OUTPUT_DATASET_ID, (String)OUTPUT_TABLE_ID, (String)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
    }

    @Test
    public void testConfigureBigQueryDefaultToJobProjectFullyQualifiedNames() throws IOException {
        conf.set(BigQueryConfiguration.PROJECT_ID.getKey(), JOB_PROJECT_ID);
        BigQueryConfiguration.configureBigQueryInput((Configuration)conf, (String)String.format("%s.%s", INPUT_DATASET_ID, INPUT_TABLE_ID));
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.INPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)INPUT_TABLE_ID);
        BigQueryConfiguration.configureBigQueryOutput((Configuration)conf, (String)String.format("%s.%s", OUTPUT_DATASET_ID, OUTPUT_TABLE_ID), (String)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_DATASET_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_DATASET_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_ID);
        Truth.assertThat((String)((String)BigQueryConfiguration.OUTPUT_TABLE_SCHEMA.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)OUTPUT_TABLE_SCHEMA);
        Truth.assertThat((String)((String)BigQueryConfiguration.PROJECT_ID.get((Configuration)conf, (arg_0, arg_1) -> ((JobConf)conf).get(arg_0, arg_1)))).isEqualTo((Object)JOB_PROJECT_ID);
    }

    @Test
    public void defaultPropertiesValues() {
        Truth.assertThat((Map)HadoopConfigurationUtils.getDefaultProperties(BigQueryConfiguration.class)).containsExactlyEntriesIn(expectedDefaultConfiguration);
    }
}

