/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.hadoop.io.bigquery.AvroRecordReader;
import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AvroRecordReaderTest {
    private static final int RECORD_COUNT = 50;
    private static final int AUTO_SYNC_INTERVAL = 32;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File testAvroFile;
    private List<String> allAddedKeys;

    @Before
    public void setup() throws IOException {
        Schema schema = (Schema)((SchemaBuilder.IntDefault)((SchemaBuilder.StringDefault)((SchemaBuilder.StringDefault)SchemaBuilder.record((String)"BigQueryRecord").fields().name("key").type().stringBuilder().endString()).noDefault().name("value1").type().stringBuilder().endString()).noDefault().name("value2").type().intBuilder().endInt()).noDefault().endRecord();
        GenericDatumWriter recordWriter = new GenericDatumWriter(schema);
        this.testAvroFile = this.temporaryFolder.newFile("TestAvroFile");
        if (this.testAvroFile.exists()) {
            this.testAvroFile.delete();
        }
        DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)recordWriter).create(schema, this.testAvroFile);
        dataFileWriter.setSyncInterval(32);
        ImmutableList.Builder addedKeysBuilder = ImmutableList.builder();
        for (int idx = 0; idx < 50; ++idx) {
            GenericData.Record record = new GenericData.Record(schema);
            String key = String.format("key-%s", idx);
            record.put("key", (Object)key);
            record.put("value1", (Object)String.format("value-%s", idx));
            record.put("value2", (Object)(idx * 50));
            dataFileWriter.append((Object)record);
            addedKeysBuilder.add((Object)key);
        }
        dataFileWriter.close();
        this.allAddedKeys = addedKeysBuilder.build();
    }

    private static List<String> collectRecordKeys(AvroRecordReader recordReader) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        while (recordReader.nextKeyValue()) {
            result.add(recordReader.currentRecord.get("key").toString());
        }
        return result;
    }

    private static int remainingRecordCount(AvroRecordReader recordReader) throws IOException {
        return AvroRecordReaderTest.collectRecordKeys(recordReader).size();
    }

    @Test
    public void testSingleSplit() throws IOException {
        FileSplit fileSplit = new FileSplit(new Path("file", null, this.testAvroFile.getAbsolutePath()), 0L, this.testAvroFile.length(), new String[0]);
        AvroRecordReader recordReader = new AvroRecordReader();
        recordReader.initializeInternal((InputSplit)fileSplit, new Configuration());
        Truth.assertThat((Integer)AvroRecordReaderTest.remainingRecordCount(recordReader)).isEqualTo((Object)50);
        recordReader.close();
    }

    @Test
    public void testMultipleSplits() throws IOException {
        long fileLength = this.testAvroFile.length();
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        Path hadoopPath = new Path("file", null, this.testAvroFile.getAbsolutePath());
        int blockStart = 0;
        while ((long)blockStart < fileLength) {
            splits.add(new FileSplit(hadoopPath, (long)blockStart, 32L, new String[0]));
            blockStart += 32;
        }
        ArrayList<String> allRecordKeys = new ArrayList<String>();
        long totalFileRecords = 0L;
        for (FileSplit split : splits) {
            AvroRecordReader reader = new AvroRecordReader();
            Throwable throwable = null;
            try {
                reader.initializeInternal((InputSplit)split, new Configuration());
                List<String> keysInSplit = AvroRecordReaderTest.collectRecordKeys(reader);
                allRecordKeys.addAll(keysInSplit);
                int recordsInSplit = keysInSplit.size();
                totalFileRecords += (long)recordsInSplit;
                Truth.assertThat((Integer)recordsInSplit).isLessThan((Comparable)Integer.valueOf(50));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        Truth.assertThat(allRecordKeys).containsExactlyElementsIn(this.allAddedKeys);
        Truth.assertThat((Long)totalFileRecords).isEqualTo((Object)50);
    }
}

