/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystemIntegrationHelper;
import com.google.cloud.hadoop.gcsio.integration.GoogleCloudStorageTestHelper;
import com.google.cloud.hadoop.gcsio.testing.TestConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryFileFormat;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.cloud.hadoop.io.bigquery.GsonBigQueryInputFormat;
import com.google.cloud.hadoop.io.bigquery.GsonRecordReader;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryOutputConfiguration;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableFieldSchema;
import com.google.cloud.hadoop.io.bigquery.output.BigQueryTableSchema;
import com.google.cloud.hadoop.io.bigquery.output.IndirectBigQueryOutputFormat;
import com.google.cloud.hadoop.util.HadoopCredentialConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LoggerConfig;
import com.google.common.truth.Truth;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public abstract class AbstractBigQueryIoIntegrationTestBase<T> {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final String BIGQUERY_PROJECT_ID_ENVVARNAME = "BIGQUERY_PROJECT_ID";
    protected static final BigQueryTableFieldSchema COMPANY_NAME_FIELD = new BigQueryTableFieldSchema().setName("CompanyName").setType("STRING");
    protected static final BigQueryTableFieldSchema MARKET_CAP_FIELD = new BigQueryTableFieldSchema().setName("MarketCap").setType("INTEGER");
    private static final BigQueryTableSchema TABLE_SCHEMA = new BigQueryTableSchema().setFields((List)ImmutableList.of((Object)COMPANY_NAME_FIELD, (Object)MARKET_CAP_FIELD));
    private static final Text EMPTY_KEY = new Text("");
    private String projectIdValue;
    private GoogleCloudStorageTestHelper.TestBucketHelper bucketHelper;
    private String testDataset;
    private String testBucket;
    private Bigquery bigqueryInstance;
    private Configuration config;
    @Mock
    private TaskAttemptContext mockTaskAttemptContext;
    @Mock
    private JobContext mockJobContext;
    private final InputFormat inputFormat;
    private final OutputFormat<Text, JsonObject> outputFormat;
    private String testTable;

    public AbstractBigQueryIoIntegrationTestBase(InputFormat inputFormat) {
        this.inputFormat = inputFormat;
        this.outputFormat = new IndirectBigQueryOutputFormat();
    }

    protected abstract Map<String, Object> readRecord(RecordReader<?, T> var1) throws Exception;

    public static Configuration getConfigForGcsFromBigquerySettings(String projectIdValue) {
        String privateKeyFile;
        TestConfiguration testConf = TestConfiguration.getInstance();
        String serviceAccount = testConf.getServiceAccount();
        if (Strings.isNullOrEmpty((String)serviceAccount)) {
            serviceAccount = System.getenv("BIGQUERY_SERVICE_ACCOUNT");
        }
        if (Strings.isNullOrEmpty((String)(privateKeyFile = testConf.getPrivateKeyFile()))) {
            privateKeyFile = System.getenv("BIGQUERY_PRIVATE_KEY_FILE");
        }
        Configuration config = new Configuration();
        config.set("fs.gs.impl", "com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem");
        config.set(GoogleHadoopFileSystemConfiguration.GCS_PROJECT_ID.getKey(), projectIdValue);
        if (serviceAccount != null && privateKeyFile != null) {
            config.setBoolean("mapred.bq" + HadoopCredentialConfiguration.ENABLE_SERVICE_ACCOUNTS_SUFFIX.getKey(), true);
            config.set("mapred.bq" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), serviceAccount);
            config.set("mapred.bq" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), privateKeyFile);
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_EMAIL_SUFFIX.getKey(), serviceAccount);
            config.set("fs.gs" + HadoopCredentialConfiguration.SERVICE_ACCOUNT_KEYFILE_SUFFIX.getKey(), privateKeyFile);
        }
        return config;
    }

    private void setConfigForGcsFromBigquerySettings() {
        Configuration conf = AbstractBigQueryIoIntegrationTestBase.getConfigForGcsFromBigquerySettings(this.projectIdValue);
        for (Map.Entry entry : conf) {
            this.config.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Before
    public void setUp() throws IOException, GeneralSecurityException {
        MockitoAnnotations.initMocks((Object)this);
        LoggerConfig.getConfig(GsonBigQueryInputFormat.class).setLevel(Level.FINE);
        LoggerConfig.getConfig(BigQueryUtils.class).setLevel(Level.FINE);
        LoggerConfig.getConfig(GsonRecordReader.class).setLevel(Level.FINE);
        this.bucketHelper = new GoogleCloudStorageTestHelper.TestBucketHelper("bq_integration_test");
        String testId = this.bucketHelper.getUniqueBucketPrefix();
        this.projectIdValue = TestConfiguration.getInstance().getProjectId();
        if (Strings.isNullOrEmpty((String)this.projectIdValue)) {
            this.projectIdValue = System.getenv(BIGQUERY_PROJECT_ID_ENVVARNAME);
        }
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.projectIdValue) ? 1 : 0) != 0, (String)"Must provide %s", (Object)BIGQUERY_PROJECT_ID_ENVVARNAME);
        this.testDataset = testId + "_dataset";
        this.testBucket = testId + "_bucket";
        Dataset outputDataset = new Dataset();
        DatasetReference datasetReference = new DatasetReference();
        datasetReference.setProjectId(this.projectIdValue);
        datasetReference.setDatasetId(this.testDataset);
        this.config = AbstractBigQueryIoIntegrationTestBase.getConfigForGcsFromBigquerySettings(this.projectIdValue);
        BigQueryFactory factory = new BigQueryFactory();
        this.bigqueryInstance = factory.getBigQuery(this.config);
        Bigquery.Datasets datasets = this.bigqueryInstance.datasets();
        outputDataset.setDatasetReference(datasetReference);
        ((GoogleLogger.Api)logger.atInfo()).log("Creating temporary dataset '%s' for project '%s'", (Object)this.testDataset, (Object)this.projectIdValue);
        datasets.insert(this.projectIdValue, outputDataset).execute();
        Path toCreate = new Path(String.format("gs://%s", this.testBucket));
        FileSystem fs = toCreate.getFileSystem(this.config);
        ((GoogleLogger.Api)logger.atInfo()).log("Creating temporary test bucket '%s'", (Object)toCreate);
        fs.mkdirs(toCreate);
        this.config.clear();
        this.setConfigForGcsFromBigquerySettings();
        Mockito.when((Object)this.mockTaskAttemptContext.getConfiguration()).thenReturn((Object)this.config);
        Mockito.when((Object)this.mockJobContext.getConfiguration()).thenReturn((Object)this.config);
        int taskNumber = 3;
        int taskAttempt = 2;
        int jobNumber = 42;
        String jobIdString = "jobid" + System.currentTimeMillis();
        JobID jobId = new JobID(jobIdString, jobNumber);
        TaskAttemptID taskAttemptId = new TaskAttemptID(new TaskID(jobId, false, taskNumber), taskAttempt);
        Mockito.when((Object)this.mockTaskAttemptContext.getTaskAttemptID()).thenReturn((Object)taskAttemptId);
        Mockito.when((Object)this.mockJobContext.getJobID()).thenReturn((Object)jobId);
        this.testTable = testId + "_table_" + jobIdString;
    }

    @After
    public void tearDown() throws IOException {
        Bigquery.Datasets datasets = this.bigqueryInstance.datasets();
        ((GoogleLogger.Api)logger.atInfo()).log("Deleting temporary test dataset '%s' for project '%s'", (Object)this.testDataset, (Object)this.projectIdValue);
        datasets.delete(this.projectIdValue, this.testDataset).setDeleteContents(Boolean.valueOf(true)).execute();
        this.setConfigForGcsFromBigquerySettings();
        Path toDelete = new Path(String.format("gs://%s", this.testBucket));
        FileSystem fs = toDelete.getFileSystem(this.config);
        if ("gs".equals(fs.getScheme())) {
            this.bucketHelper.cleanup(GoogleCloudStorageFileSystemIntegrationHelper.createGcsFs((String)this.projectIdValue).getGcs());
        } else {
            ((GoogleLogger.Api)logger.atInfo()).log("Deleting temporary test bucket '%s'", (Object)toDelete);
            fs.delete(toDelete, true);
        }
    }

    @Test
    public void testBasicWriteAndRead() throws Exception {
        BigQueryOutputConfiguration.configure((Configuration)this.config, (String)String.format("%s:%s.%s", this.projectIdValue, this.testDataset, this.testTable), (BigQueryTableSchema)TABLE_SCHEMA, (String)String.format("gs://%s/%s/testBasicWriteAndRead/output/", this.testBucket, this.inputFormat.getClass().getSimpleName()), (BigQueryFileFormat)BigQueryFileFormat.NEWLINE_DELIMITED_JSON, TextOutputFormat.class);
        OutputCommitter committer = this.outputFormat.getOutputCommitter(this.mockTaskAttemptContext);
        committer.setupJob(this.mockJobContext);
        committer.setupTask(this.mockTaskAttemptContext);
        RecordWriter writer = this.outputFormat.getRecordWriter(this.mockTaskAttemptContext);
        JsonObject value = new JsonObject();
        value.addProperty(COMPANY_NAME_FIELD.getName(), "Google");
        value.addProperty(MARKET_CAP_FIELD.getName(), (Number)409);
        writer.write((Object)EMPTY_KEY, (Object)value);
        value = new JsonObject();
        value.addProperty(COMPANY_NAME_FIELD.getName(), "Microsoft");
        value.addProperty(MARKET_CAP_FIELD.getName(), (Number)314);
        writer.write((Object)EMPTY_KEY, (Object)value);
        value = new JsonObject();
        value.addProperty(COMPANY_NAME_FIELD.getName(), "Facebook");
        value.addProperty(MARKET_CAP_FIELD.getName(), (Number)175);
        writer.write((Object)EMPTY_KEY, (Object)value);
        writer.close(this.mockTaskAttemptContext);
        Truth.assertThat((Boolean)committer.needsTaskCommit(this.mockTaskAttemptContext)).isTrue();
        committer.commitTask(this.mockTaskAttemptContext);
        committer.commitJob(this.mockJobContext);
        this.config.clear();
        this.setConfigForGcsFromBigquerySettings();
        BigQueryConfiguration.configureBigQueryInput((Configuration)this.config, (String)this.projectIdValue, (String)this.testDataset, (String)this.testTable);
        this.config.set(BigQueryConfiguration.GCS_BUCKET.getKey(), this.testBucket);
        List splits = this.inputFormat.getSplits(this.mockJobContext);
        RecordReader reader = this.inputFormat.createRecordReader((InputSplit)splits.get(0), this.mockTaskAttemptContext);
        reader.initialize((InputSplit)splits.get(0), this.mockTaskAttemptContext);
        HashMap readValues = Maps.newHashMap();
        while (reader.nextKeyValue()) {
            Map<String, Object> record = this.readRecord(reader);
            Truth.assertThat(record).containsKey((Object)COMPANY_NAME_FIELD.getName());
            Truth.assertThat(record).containsKey((Object)MARKET_CAP_FIELD.getName());
            readValues.put((String)record.get(COMPANY_NAME_FIELD.getName()), (Integer)record.get(MARKET_CAP_FIELD.getName()));
        }
        Truth.assertThat((Map)readValues).hasSize(3);
        Truth.assertThat((Integer)((Integer)readValues.get("Google"))).isEqualTo((Object)409);
        Truth.assertThat((Integer)((Integer)readValues.get("Microsoft"))).isEqualTo((Object)314);
        Truth.assertThat((Integer)((Integer)readValues.get("Facebook"))).isEqualTo((Object)175);
    }
}

