/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TableName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/tables/{table}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String table;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TableName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
    }

    public static TableName of(String project, String dataset, String table) {
        return TableName.newBuilder().setProject(project).setDataset(dataset).setTable(table).build();
    }

    public static String format(String project, String dataset, String table) {
        return TableName.newBuilder().setProject(project).setDataset(dataset).setTable(table).build().toString();
    }

    public static TableName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TableName.parse: formattedString not in valid format");
        return TableName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("table"));
    }

    public static List<TableName> parseList(List<String> formattedStrings) {
        ArrayList<TableName> list = new ArrayList<TableName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TableName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TableName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TableName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TableName tableName = this;
            synchronized (tableName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"table", (Object)this.table);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "table", this.table});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TableName) {
            TableName that = (TableName)o;
            return this.project.equals(that.project) && this.dataset.equals(that.dataset) && this.table.equals(that.table);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        return h ^= this.table.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String table;

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getTable() {
            return this.table;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        private Builder() {
        }

        private Builder(TableName tableName) {
            this.project = tableName.project;
            this.dataset = tableName.dataset;
            this.table = tableName.table;
        }

        public TableName build() {
            return new TableName(this);
        }
    }
}

