/*
 * Decompiled with CFR 0.152.
 */
package com.google.pubsub.v1;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Empty;
import com.google.protobuf.MessageLite;
import com.google.pubsub.v1.DeleteTopicRequest;
import com.google.pubsub.v1.GetTopicRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsRequest;
import com.google.pubsub.v1.ListTopicSubscriptionsResponse;
import com.google.pubsub.v1.ListTopicsRequest;
import com.google.pubsub.v1.ListTopicsResponse;
import com.google.pubsub.v1.PublishRequest;
import com.google.pubsub.v1.PublishResponse;
import com.google.pubsub.v1.Topic;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;

public class PublisherGrpc {
    public static final String SERVICE_NAME = "google.pubsub.v1.Publisher";
    public static final MethodDescriptor<Topic, Topic> METHOD_CREATE_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"CreateTopic"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Topic.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Topic.getDefaultInstance()));
    public static final MethodDescriptor<PublishRequest, PublishResponse> METHOD_PUBLISH = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"Publish"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)PublishRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)PublishResponse.getDefaultInstance()));
    public static final MethodDescriptor<GetTopicRequest, Topic> METHOD_GET_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"GetTopic"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)GetTopicRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Topic.getDefaultInstance()));
    public static final MethodDescriptor<ListTopicsRequest, ListTopicsResponse> METHOD_LIST_TOPICS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"ListTopics"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListTopicsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListTopicsResponse.getDefaultInstance()));
    public static final MethodDescriptor<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse> METHOD_LIST_TOPIC_SUBSCRIPTIONS = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"ListTopicSubscriptions"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListTopicSubscriptionsRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)ListTopicSubscriptionsResponse.getDefaultInstance()));
    public static final MethodDescriptor<DeleteTopicRequest, Empty> METHOD_DELETE_TOPIC = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNARY, (String)MethodDescriptor.generateFullMethodName((String)"google.pubsub.v1.Publisher", (String)"DeleteTopic"), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)DeleteTopicRequest.getDefaultInstance()), (MethodDescriptor.Marshaller)ProtoUtils.marshaller((MessageLite)Empty.getDefaultInstance()));

    private PublisherGrpc() {
    }

    public static PublisherStub newStub(Channel channel) {
        return new PublisherStub(channel);
    }

    public static PublisherBlockingStub newBlockingStub(Channel channel) {
        return new PublisherBlockingStub(channel);
    }

    public static PublisherFutureStub newFutureStub(Channel channel) {
        return new PublisherFutureStub(channel);
    }

    public static ServerServiceDefinition bindService(final Publisher serviceImpl) {
        return ServerServiceDefinition.builder((String)SERVICE_NAME).addMethod(METHOD_CREATE_TOPIC, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<Topic, Topic>(){

            public void invoke(Topic request, StreamObserver<Topic> responseObserver) {
                serviceImpl.createTopic(request, responseObserver);
            }
        })).addMethod(METHOD_PUBLISH, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<PublishRequest, PublishResponse>(){

            public void invoke(PublishRequest request, StreamObserver<PublishResponse> responseObserver) {
                serviceImpl.publish(request, responseObserver);
            }
        })).addMethod(METHOD_GET_TOPIC, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<GetTopicRequest, Topic>(){

            public void invoke(GetTopicRequest request, StreamObserver<Topic> responseObserver) {
                serviceImpl.getTopic(request, responseObserver);
            }
        })).addMethod(METHOD_LIST_TOPICS, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<ListTopicsRequest, ListTopicsResponse>(){

            public void invoke(ListTopicsRequest request, StreamObserver<ListTopicsResponse> responseObserver) {
                serviceImpl.listTopics(request, responseObserver);
            }
        })).addMethod(METHOD_LIST_TOPIC_SUBSCRIPTIONS, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<ListTopicSubscriptionsRequest, ListTopicSubscriptionsResponse>(){

            public void invoke(ListTopicSubscriptionsRequest request, StreamObserver<ListTopicSubscriptionsResponse> responseObserver) {
                serviceImpl.listTopicSubscriptions(request, responseObserver);
            }
        })).addMethod(METHOD_DELETE_TOPIC, ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new ServerCalls.UnaryMethod<DeleteTopicRequest, Empty>(){

            public void invoke(DeleteTopicRequest request, StreamObserver<Empty> responseObserver) {
                serviceImpl.deleteTopic(request, responseObserver);
            }
        })).build();
    }

    public static class PublisherFutureStub
    extends AbstractStub<PublisherFutureStub>
    implements PublisherFutureClient {
        private PublisherFutureStub(Channel channel) {
            super(channel);
        }

        private PublisherFutureStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PublisherFutureStub build(Channel channel, CallOptions callOptions) {
            return new PublisherFutureStub(channel, callOptions);
        }

        @Override
        public ListenableFuture<Topic> createTopic(Topic request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_TOPIC, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<PublishResponse> publish(PublishRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PUBLISH, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Topic> getTopic(GetTopicRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_TOPIC, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<ListTopicsResponse> listTopics(ListTopicsRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPICS, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<ListTopicSubscriptionsResponse> listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPIC_SUBSCRIPTIONS, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListenableFuture<Empty> deleteTopic(DeleteTopicRequest request) {
            return ClientCalls.futureUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_TOPIC, this.getCallOptions()), (Object)request);
        }
    }

    public static class PublisherBlockingStub
    extends AbstractStub<PublisherBlockingStub>
    implements PublisherBlockingClient {
        private PublisherBlockingStub(Channel channel) {
            super(channel);
        }

        private PublisherBlockingStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PublisherBlockingStub build(Channel channel, CallOptions callOptions) {
            return new PublisherBlockingStub(channel, callOptions);
        }

        @Override
        public Topic createTopic(Topic request) {
            return (Topic)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_TOPIC, this.getCallOptions()), (Object)request);
        }

        @Override
        public PublishResponse publish(PublishRequest request) {
            return (PublishResponse)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PUBLISH, this.getCallOptions()), (Object)request);
        }

        @Override
        public Topic getTopic(GetTopicRequest request) {
            return (Topic)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_TOPIC, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListTopicsResponse listTopics(ListTopicsRequest request) {
            return (ListTopicsResponse)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPICS, this.getCallOptions()), (Object)request);
        }

        @Override
        public ListTopicSubscriptionsResponse listTopicSubscriptions(ListTopicSubscriptionsRequest request) {
            return (ListTopicSubscriptionsResponse)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPIC_SUBSCRIPTIONS, this.getCallOptions()), (Object)request);
        }

        @Override
        public Empty deleteTopic(DeleteTopicRequest request) {
            return (Empty)ClientCalls.blockingUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_TOPIC, this.getCallOptions()), (Object)request);
        }
    }

    public static class PublisherStub
    extends AbstractStub<PublisherStub>
    implements Publisher {
        private PublisherStub(Channel channel) {
            super(channel);
        }

        private PublisherStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
        }

        protected PublisherStub build(Channel channel, CallOptions callOptions) {
            return new PublisherStub(channel, callOptions);
        }

        @Override
        public void createTopic(Topic request, StreamObserver<Topic> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_CREATE_TOPIC, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void publish(PublishRequest request, StreamObserver<PublishResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_PUBLISH, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void getTopic(GetTopicRequest request, StreamObserver<Topic> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_GET_TOPIC, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void listTopics(ListTopicsRequest request, StreamObserver<ListTopicsResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPICS, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void listTopicSubscriptions(ListTopicSubscriptionsRequest request, StreamObserver<ListTopicSubscriptionsResponse> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_LIST_TOPIC_SUBSCRIPTIONS, this.getCallOptions()), (Object)request, responseObserver);
        }

        @Override
        public void deleteTopic(DeleteTopicRequest request, StreamObserver<Empty> responseObserver) {
            ClientCalls.asyncUnaryCall((ClientCall)this.getChannel().newCall(METHOD_DELETE_TOPIC, this.getCallOptions()), (Object)request, responseObserver);
        }
    }

    public static interface PublisherFutureClient {
        public ListenableFuture<Topic> createTopic(Topic var1);

        public ListenableFuture<PublishResponse> publish(PublishRequest var1);

        public ListenableFuture<Topic> getTopic(GetTopicRequest var1);

        public ListenableFuture<ListTopicsResponse> listTopics(ListTopicsRequest var1);

        public ListenableFuture<ListTopicSubscriptionsResponse> listTopicSubscriptions(ListTopicSubscriptionsRequest var1);

        public ListenableFuture<Empty> deleteTopic(DeleteTopicRequest var1);
    }

    public static interface PublisherBlockingClient {
        public Topic createTopic(Topic var1);

        public PublishResponse publish(PublishRequest var1);

        public Topic getTopic(GetTopicRequest var1);

        public ListTopicsResponse listTopics(ListTopicsRequest var1);

        public ListTopicSubscriptionsResponse listTopicSubscriptions(ListTopicSubscriptionsRequest var1);

        public Empty deleteTopic(DeleteTopicRequest var1);
    }

    public static interface Publisher {
        public void createTopic(Topic var1, StreamObserver<Topic> var2);

        public void publish(PublishRequest var1, StreamObserver<PublishResponse> var2);

        public void getTopic(GetTopicRequest var1, StreamObserver<Topic> var2);

        public void listTopics(ListTopicsRequest var1, StreamObserver<ListTopicsResponse> var2);

        public void listTopicSubscriptions(ListTopicSubscriptionsRequest var1, StreamObserver<ListTopicSubscriptionsResponse> var2);

        public void deleteTopic(DeleteTopicRequest var1, StreamObserver<Empty> var2);
    }
}

