/*
 * Decompiled with CFR 0.152.
 */
package com.github.stanfordfuturedata.momentsketch;

import com.github.stanfordfuturedata.momentsketch.MomentSolver;
import com.github.stanfordfuturedata.momentsketch.MomentStruct;

public class SimpleMomentSketch {
    public MomentStruct data;
    public boolean useArcSinh = true;

    public SimpleMomentSketch(int k) {
        this.data = new MomentStruct(k);
    }

    public SimpleMomentSketch(MomentStruct data) {
        this.data = data;
    }

    public void setCompressed(boolean flag) {
        this.useArcSinh = flag;
    }

    public boolean getCompressed() {
        return this.useArcSinh;
    }

    public int getK() {
        return this.data.power_sums.length;
    }

    public double[] getPowerSums() {
        return this.data.power_sums;
    }

    public double getMin() {
        return this.data.min;
    }

    public double getMax() {
        return this.data.max;
    }

    public void add(double rawX) {
        double x = rawX;
        if (this.useArcSinh) {
            x = Math.log(rawX + Math.sqrt(1.0 + rawX * rawX));
        }
        this.data.add(x);
    }

    public void merge(SimpleMomentSketch other) {
        this.data.merge(other.data);
    }

    public MomentSolver getSolver() {
        MomentSolver ms = new MomentSolver(this.data);
        return ms;
    }

    public double[] getQuantiles(double[] fractions) {
        MomentSolver ms = new MomentSolver(this.data);
        ms.setGridSize(1024);
        ms.setMaxIter(15);
        ms.solve();
        double[] quantiles = new double[fractions.length];
        for (int i = 0; i < fractions.length; ++i) {
            double rawQuantile = ms.getQuantile(fractions[i]);
            quantiles[i] = Math.sinh(rawQuantile);
        }
        return quantiles;
    }

    public String toString() {
        return this.data.toString();
    }
}

