/*
 * Decompiled with CFR 0.152.
 */
package com.github.stanfordfuturedata.momentsketch;

import java.util.Arrays;

public class MomentStruct {
    public double[] power_sums;
    public double min;
    public double max;

    public MomentStruct(double[] pSums, double min, double max) {
        this.power_sums = pSums;
        this.min = min;
        this.max = max;
    }

    public MomentStruct(int k) {
        this.power_sums = new double[k];
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    public void add(double x) {
        if (x < this.min) {
            this.min = x;
        }
        if (x > this.max) {
            this.max = x;
        }
        double curPow = 1.0;
        int k = this.power_sums.length;
        int i = 0;
        while (i < k) {
            int n = i++;
            this.power_sums[n] = this.power_sums[n] + curPow;
            curPow *= x;
        }
    }

    public void add(double[] xVals) {
        for (double x : xVals) {
            this.add(x);
        }
    }

    public void merge(MomentStruct other) {
        if (other.min < this.min) {
            this.min = other.min;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
        int k = this.power_sums.length;
        for (int i = 0; i < k; ++i) {
            int n = i;
            this.power_sums[n] = this.power_sums[n] + other.power_sums[i];
        }
    }

    public String toString() {
        return String.format("%g:%g:%s", this.min, this.max, Arrays.toString(this.power_sums));
    }
}

