/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.utils;

import com.github.rvesse.airline.utils.comparators.ByteComparator;
import com.github.rvesse.airline.utils.comparators.DoubleComparator;
import com.github.rvesse.airline.utils.comparators.FloatComparator;
import com.github.rvesse.airline.utils.comparators.IntegerComparator;
import com.github.rvesse.airline.utils.comparators.LongComparator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComparatorTests {
    @Test
    public void float_comparator_negatives_01() {
        FloatComparator comparator = new FloatComparator();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((new Float(-1.0f).floatValue() < new Float(0.0f).floatValue() ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(0.0f)), (int)-1);
    }

    @Test
    public void float_comparator_positives_01() {
        FloatComparator comparator = new FloatComparator();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((new Float(1.0f).floatValue() > new Float(0.0f).floatValue() ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(1.0f), (Object)Float.valueOf(0.0f)), (int)1);
    }

    @Test
    public void float_comparator_limits_01() {
        FloatComparator comparator = new FloatComparator();
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(0.0f)), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.MIN_VALUE)), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(Float.MIN_VALUE), (Object)Float.valueOf(Float.MIN_VALUE)), (int)0);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(0.0f)), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(0.0f), (Object)Float.valueOf(Float.MAX_VALUE)), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(Float.MAX_VALUE)), (int)0);
    }

    @Test
    public void double_comparator_negatives_01() {
        DoubleComparator comparator = new DoubleComparator();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((new Double(-1.0) < new Double(0.0) ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)-1.0, (Object)0.0), (int)-1);
    }

    @Test
    public void double_comparator_positives_01() {
        DoubleComparator comparator = new DoubleComparator();
        Assert.assertTrue((boolean)true);
        Assert.assertTrue((new Double(1.0) > new Double(0.0) ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)1.0, (Object)0.0), (int)1);
    }

    @Test
    public void double_comparator_limits_01() {
        DoubleComparator comparator = new DoubleComparator();
        Assert.assertEquals((int)comparator.compare((Object)Double.MIN_VALUE, (Object)0.0), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)0.0, (Object)Double.MIN_VALUE), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)Double.MIN_VALUE, (Object)Double.MIN_VALUE), (int)0);
        Assert.assertEquals((int)comparator.compare((Object)Double.MAX_VALUE, (Object)0.0), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)0.0, (Object)Double.MAX_VALUE), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)Double.MAX_VALUE, (Object)Double.MAX_VALUE), (int)0);
    }

    @Test
    public void byte_comparator_limits_01() {
        ByteComparator comparator = new ByteComparator();
        Assert.assertTrue((comparator.compare((Object)-128, (Object)0) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)0, (Object)-128) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)-128, (Object)-128), (int)0);
        Assert.assertTrue((comparator.compare((Object)127, (Object)0) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((comparator.compare((Object)0, (Object)127) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)comparator.compare((Object)127, (Object)127), (int)0);
    }

    @Test
    public void integer_comparator_limits_01() {
        IntegerComparator comparator = new IntegerComparator();
        Assert.assertEquals((int)comparator.compare((Object)Integer.MIN_VALUE, (Object)0), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)0, (Object)Integer.MIN_VALUE), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)Integer.MIN_VALUE, (Object)Integer.MIN_VALUE), (int)0);
        Assert.assertEquals((int)comparator.compare((Object)Integer.MAX_VALUE, (Object)0), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)0, (Object)Integer.MAX_VALUE), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)Integer.MAX_VALUE, (Object)Integer.MAX_VALUE), (int)0);
    }

    @Test
    public void long_comparator_limits_01() {
        LongComparator comparator = new LongComparator();
        Assert.assertEquals((int)comparator.compare((Object)Long.MIN_VALUE, (Object)0L), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)0L, (Object)Long.MIN_VALUE), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)Long.MIN_VALUE, (Object)Long.MIN_VALUE), (int)0);
        Assert.assertEquals((int)comparator.compare((Object)Long.MAX_VALUE, (Object)0L), (int)1);
        Assert.assertEquals((int)comparator.compare((Object)0L, (Object)Long.MAX_VALUE), (int)-1);
        Assert.assertEquals((int)comparator.compare((Object)Long.MAX_VALUE, (Object)Long.MAX_VALUE), (int)0);
    }
}

