/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.types;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import com.github.rvesse.airline.types.ArgsRadix;
import com.github.rvesse.airline.types.ConvertResult;
import com.github.rvesse.airline.types.numerics.DefaultNumericConverter;
import com.github.rvesse.airline.types.numerics.NumericTypeConverter;
import com.github.rvesse.airline.types.numerics.abbreviated.KiloAs1000;
import com.github.rvesse.airline.types.numerics.abbreviated.KiloAs1024;
import com.github.rvesse.airline.types.numerics.bases.Binary;
import com.github.rvesse.airline.types.numerics.bases.Hexadecimal;
import com.github.rvesse.airline.types.numerics.bases.Octal;
import java.util.Random;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypeConverters {
    private static final int NUMBER_RANDOM_TESTS = 25000;
    private static final Class<?>[] NUMERIC_TYPES = new Class[]{Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class};
    private static final Class<?>[] INTEGER_TYPES = new Class[]{Long.class, Integer.class, Short.class, Byte.class};

    @Test
    public void numeric_default_bad_01() {
        String badValue = "test";
        this.checkBadConversion(badValue);
    }

    @Test
    public void numeric_default_bad_02() {
        String badValue = "NaN";
        this.checkBadIntegerConversion(badValue);
    }

    private void checkBadConversion(String badValue) {
        this.checkBadConversion(badValue, NUMERIC_TYPES);
    }

    private void checkBadIntegerConversion(String badValue) {
        this.checkBadConversion(badValue, INTEGER_TYPES);
    }

    private void checkBadConversion(String badValue, Class<?> ... types) {
        for (Class<?> type : types) {
            DefaultNumericConverter converter = new DefaultNumericConverter();
            ConvertResult result = converter.tryConvertNumerics("test", type, badValue);
            Assert.assertFalse((boolean)result.wasSuccessfull());
            Assert.assertNull((Object)result.getConvertedValue());
        }
    }

    @Test
    public void numeric_case_insensitivity_01() {
        KiloAs1024 converter = new KiloAs1024();
        ConvertResult result = converter.tryConvertNumerics("test", Long.class, "4GB");
        Assert.assertTrue((boolean)result.wasSuccessfull());
        Assert.assertEquals((long)((Long)result.getConvertedValue()), (long)0x100000000L);
    }

    @Test
    public void numeric_default_int_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            int number = random.nextInt();
            ConvertResult result = converter.tryConvertNumerics("test", Integer.class, Integer.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((int)((Integer)result.getConvertedValue()), (int)number);
        }
    }

    @Test
    public void numeric_default_long_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            long number = random.nextLong();
            ConvertResult result = converter.tryConvertNumerics("test", Long.class, Long.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((long)((Long)result.getConvertedValue()), (long)number);
        }
    }

    @Test
    public void numeric_default_short_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            short number = (short)random.nextInt(32768);
            ConvertResult result = converter.tryConvertNumerics("test", Short.class, Short.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((short)((Short)result.getConvertedValue()), (short)number);
        }
    }

    @Test
    public void numeric_default_byte_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            byte number = (byte)random.nextInt(128);
            ConvertResult result = converter.tryConvertNumerics("test", Byte.class, Byte.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((byte)((Byte)result.getConvertedValue()), (byte)number);
        }
    }

    @Test
    public void numeric_default_float_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            float number = random.nextFloat();
            ConvertResult result = converter.tryConvertNumerics("test", Float.class, Float.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((Object)Float.valueOf(((Float)result.getConvertedValue()).floatValue()), (Object)Float.valueOf(number));
        }
    }

    @Test
    public void numeric_default_float_02() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        ConvertResult result = converter.tryConvertNumerics("test", Float.class, "NaN");
        Assert.assertTrue((boolean)result.wasSuccessfull());
        Assert.assertEquals((Object)result.getConvertedValue(), (Object)Float.valueOf(Float.NaN));
    }

    @Test
    public void numeric_default_double_01() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        Random random = new Random();
        for (int i = 0; i < 25000; ++i) {
            double number = random.nextDouble();
            ConvertResult result = converter.tryConvertNumerics("test", Double.class, Double.toString(number));
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((Object)((Double)result.getConvertedValue()), (Object)number);
        }
    }

    @Test
    public void numeric_default_double_02() {
        DefaultNumericConverter converter = new DefaultNumericConverter();
        ConvertResult result = converter.tryConvertNumerics("test", Double.class, "NaN");
        Assert.assertTrue((boolean)result.wasSuccessfull());
        Assert.assertEquals((Object)result.getConvertedValue(), (Object)Double.NaN);
    }

    private void checkIntegerAbbreviationKilo(NumericTypeConverter converter, long multiplier, long min, long max, Class<?> type, long divisor, String suffix) {
        Random random = new Random();
        int good = 0;
        int bad = 0;
        for (int i = 0; i < 25000; ++i) {
            long number = random.nextLong();
            if (number < divisor) {
                number += divisor;
            }
            if (number % divisor != 0L) {
                number -= number % divisor;
            }
            ConvertResult result = converter.tryConvertNumerics("test", type, String.format("%d%s", number / divisor, suffix));
            if (number < min || number > max) {
                Assert.assertFalse((boolean)result.wasSuccessfull());
                ++bad;
                continue;
            }
            if (!result.wasSuccessfull()) {
                System.out.println(String.format("Expected abbreviation %d%s to expand to %d but failed", number / divisor, suffix, number));
            }
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((Object)result.getConvertedValue(), (Object)number);
            ++good;
        }
        System.out.println(String.format("Ran %,d test cases for %s with settings (mult=%,d, min=%,d, max=%,d, type=%s, divisor=%,d, suffix=%s) with %,d good values and %,d bad values", 25000, converter.getClass(), multiplier, min, max, type, divisor, suffix, good, bad));
    }

    private ConvertResult doConversion(NumericTypeConverter converter, String value, Class<?> type) {
        return converter.tryConvertNumerics("test", type, value);
    }

    private void checkGoodConversion(NumericTypeConverter converter, String value, Class<?> type, Object expected) {
        ConvertResult result = this.doConversion(converter, value, type);
        Assert.assertTrue((boolean)result.wasSuccessfull());
        Assert.assertEquals((Object)result.getConvertedValue(), (Object)expected);
    }

    private void checkBadConversion(NumericTypeConverter converter, String value, Class<?> type) {
        ConvertResult result = this.doConversion(converter, value, type);
        Assert.assertFalse((boolean)result.wasSuccessfull());
    }

    @Test
    public void numeric_kilo_1000_specifics() {
        KiloAs1000 converter = new KiloAs1000();
        this.checkGoodConversion((NumericTypeConverter)converter, "1k", Short.class, (short)1000);
        this.checkGoodConversion((NumericTypeConverter)converter, "10k", Short.class, (short)10000);
        this.checkBadConversion((NumericTypeConverter)converter, "100k", Short.class);
    }

    @Test
    public void numeric_kilo_1000_long_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 1000L, "k");
    }

    @Test
    public void numeric_kilo_1000_long_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 1000000L, "m");
    }

    @Test
    public void numeric_kilo_1000_long_03() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 1000000000L, "b");
    }

    @Test
    public void numeric_kilo_1000_long_04() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 1000000000000L, "t");
    }

    @Test
    public void numeric_kilo_1000_integer_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 1000L, "k");
    }

    @Test
    public void numeric_kilo_1000_integer_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 1000000L, "m");
    }

    @Test
    public void numeric_kilo_1000_integer_03() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 1000000000L, "b");
    }

    @Test
    public void numeric_kilo_1000_short_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, -32768L, 32767L, Short.class, 1000L, "k");
    }

    @Test
    public void numeric_kilo_1000_short_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1000(), 1000L, -32768L, 32767L, Short.class, 1000000L, "m");
    }

    @Test
    public void numeric_kilo_1024_long_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 1024L, "k");
    }

    @Test
    public void numeric_kilo_1024_long_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 0x100000L, "m");
    }

    @Test
    public void numeric_kilo_1024_long_03() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 0x40000000L, "g");
    }

    @Test
    public void numeric_kilo_1024_long_04() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Long.MIN_VALUE, Long.MAX_VALUE, Long.class, 0x10000000000L, "t");
    }

    @Test
    public void numeric_kilo_1024_integer_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 1024L, "k");
    }

    @Test
    public void numeric_kilo_1024_integer_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 0x100000L, "m");
    }

    @Test
    public void numeric_kilo_1024_integer_03() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 0x40000000L, "g");
    }

    @Test
    public void numeric_kilo_1024_integer_04() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class, 0x40000000L, "G");
    }

    @Test
    public void numeric_kilo_1024_short_01() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, -32768L, 32767L, Short.class, 1024L, "k");
    }

    @Test
    public void numeric_kilo_1024_short_02() {
        this.checkIntegerAbbreviationKilo((NumericTypeConverter)new KiloAs1024(), 1024L, -32768L, 32767L, Short.class, 1024L, "k");
    }

    private void checkAlternateRadix(NumericTypeConverter converter, int radix, long min, long max, Class<?> type) {
        Random random = new Random();
        int good = 0;
        int bad = 0;
        for (int i = 0; i < 25000; ++i) {
            long number = random.nextLong();
            ConvertResult result = converter.tryConvertNumerics("test", type, String.format("%s", Long.toString(number, radix)));
            if (number < min || number > max) {
                Assert.assertFalse((boolean)result.wasSuccessfull());
                ++bad;
                continue;
            }
            if (!result.wasSuccessfull()) {
                System.out.println(String.format("Expected radix %d representation %s to expand to %d but failed", radix, Long.toString(number, radix), number));
            }
            Assert.assertTrue((boolean)result.wasSuccessfull());
            Assert.assertEquals((Object)result.getConvertedValue(), (Object)number);
            ++good;
        }
        System.out.println(String.format("Ran %,d test cases for %s with settings (radix=%,d, min=%,d, max=%,d, type=%s) with %,d good values and %,d bad values", 25000, converter.getClass(), radix, min, max, type, good, bad));
    }

    private void checkAlternateRadix(NumericTypeConverter converter, int radix) {
        this.checkAlternateRadix(converter, radix, Long.MIN_VALUE, Long.MAX_VALUE, Long.class);
        this.checkAlternateRadix(converter, radix, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.class);
        this.checkAlternateRadix(converter, radix, -32768L, 32767L, Short.class);
        this.checkAlternateRadix(converter, radix, -128L, 127L, Byte.class);
    }

    @Test
    public void numeric_radix_16() {
        Hexadecimal converter = new Hexadecimal();
        this.checkAlternateRadix((NumericTypeConverter)converter, 16);
    }

    @Test
    public void numeric_radix_8() {
        Octal converter = new Octal();
        this.checkAlternateRadix((NumericTypeConverter)converter, 8);
    }

    @Test
    public void numeric_radix_2() {
        Binary converter = new Binary();
        this.checkAlternateRadix((NumericTypeConverter)converter, 2);
    }

    @Test
    public void command_mixed_converters_01() {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsRadix.class);
        long value = 47000L;
        ArgsRadix radix = (ArgsRadix)cmd.parse(new String[]{"--normal", Long.toString(value), "--hex", Long.toString(value, 16), "--octal", Long.toString(value, 8), "--binary", Long.toString(value, 2), "--kilo", value / 1000L + "k"});
        Assert.assertEquals((long)radix.normal, (long)value);
        Assert.assertEquals((long)radix.hex, (long)value);
        Assert.assertEquals((long)radix.octal, (long)value);
        Assert.assertEquals((long)radix.binary, (long)value);
        Assert.assertEquals((long)radix.abbrev, (long)value);
    }

    @Test
    public void command_mixed_converters_02() {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsRadix.class);
        long value = 47000L;
        ArgsRadix radix = (ArgsRadix)cmd.parse(new String[]{"--normal", Long.toString(value), "--hex", Long.toString(value), "--octal", Long.toString(value)});
        Assert.assertEquals((long)radix.normal, (long)value);
        Assert.assertEquals((long)radix.hex, (long)Long.parseLong(Long.toString(value), 16));
        Assert.assertEquals((long)radix.octal, (long)Long.parseLong(Long.toString(value), 8));
    }

    @Test
    public void command_mixed_converters_03() {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsRadix.class);
        long value = 47000L;
        ArgsRadix radix = (ArgsRadix)cmd.parse(new String[]{"--kilo", Long.toString(value)});
        Assert.assertEquals((long)radix.abbrev, (long)value);
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void command_mixed_converters_04() {
        SingleCommand cmd = SingleCommand.singleCommand(ArgsRadix.class);
        long value = 47000L;
        cmd.parse(new String[]{"--binary", Long.toString(value)});
    }
}

