/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.ranges;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseOptionOutOfRangeException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.PositiveNegativeRestriction;
import com.github.rvesse.airline.restrictions.common.RangeRestriction;
import com.github.rvesse.airline.restrictions.ranges.OptionDoubleRangeInclusive;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeComplete;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeCompleteExclusive;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeInclusive;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeInclusiveMax;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeInclusiveMin;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeInvalid;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeInvalidSingleValue;
import com.github.rvesse.airline.restrictions.ranges.OptionIntegerRangeSingleValue;
import com.github.rvesse.airline.restrictions.ranges.OptionLexicalRangeInclusive;
import com.github.rvesse.airline.restrictions.ranges.OptionRangeBase;
import com.github.rvesse.airline.restrictions.ranges.OptionRangeNegative;
import com.github.rvesse.airline.restrictions.ranges.OptionRangeNegativeIncludesZero;
import com.github.rvesse.airline.restrictions.ranges.OptionRangePositive;
import com.github.rvesse.airline.restrictions.ranges.OptionRangePositiveExcludesZero;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRangeRestrictions {
    private void hasRangeRestriction(CommandMetadata metadata) {
        this.hasRestriction(metadata, RangeRestriction.class);
    }

    private void hasRestriction(CommandMetadata metadata, Class<?> restrictionType) {
        for (OptionMetadata option : metadata.getAllOptions()) {
            Iterator iterator = option.getRestrictions().iterator();
            if (!iterator.hasNext()) continue;
            OptionRestriction restriction = (OptionRestriction)iterator.next();
            if (restriction.getClass().isAssignableFrom(restrictionType)) {
                // empty if block
            }
            return;
        }
        Assert.fail((String)"No RangeRestriction found");
    }

    private void checkHelp(SingleCommand<? extends OptionRangeBase> parser, String[] included, String[] excluded) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((CommandMetadata)parser.getCommandMetadata(), (OutputStream)output);
        String usage = new String(output.toByteArray(), StandardCharsets.UTF_8);
        for (String include : included) {
            Assert.assertTrue((boolean)usage.contains(include));
        }
        for (String exclude : excluded) {
            Assert.assertFalse((boolean)usage.contains(exclude));
        }
    }

    @Test
    public void integer_range_inclusive() throws IOException {
        SingleCommand<OptionIntegerRangeInclusive> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        for (int i = 0; i <= 100; ++i) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
        }
        this.checkHelp(parser, new String[]{"0 <= value <= 100"}, new String[0]);
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 <= value <= 100).*")
    public void integer_range_inclusive_below_min() {
        SingleCommand<OptionIntegerRangeInclusive> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "-1"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 <= value <= 100).*")
    public void integer_range_inclusive_above_max() {
        SingleCommand<OptionIntegerRangeInclusive> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "101"});
    }

    @Test
    public void integer_range_inclusive_min() throws IOException {
        SingleCommand<OptionIntegerRangeInclusiveMin> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMin.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        for (int i = 0; i < 100; ++i) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
        }
        this.checkHelp(parser, new String[]{"0 <= value < 100"}, new String[0]);
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 <= value < 100).*")
    public void integer_range_inclusive_min_below_min() {
        SingleCommand<OptionIntegerRangeInclusiveMin> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMin.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "-1"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 <= value < 100).*")
    public void integer_range_inclusive_min_at_max() {
        SingleCommand<OptionIntegerRangeInclusiveMin> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMin.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "100"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 <= value < 100).*")
    public void integer_range_inclusive_min_above_max() {
        SingleCommand<OptionIntegerRangeInclusiveMin> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMin.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "101"});
    }

    @Test
    public void integer_range_inclusive_max() throws IOException {
        SingleCommand<OptionIntegerRangeInclusiveMax> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMax.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        for (int i = 1; i <= 100; ++i) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
        }
        this.checkHelp(parser, new String[]{"0 < value <= 100"}, new String[0]);
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 < value <= 100).*")
    public void integer_range_inclusive_max_below_min() {
        SingleCommand<OptionIntegerRangeInclusiveMax> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMax.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "-1"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 < value <= 100).*")
    public void integer_range_inclusive_max_at_min() {
        SingleCommand<OptionIntegerRangeInclusiveMax> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMax.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "0"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0 < value <= 100).*")
    public void integer_range_inclusive_max_above_max() {
        SingleCommand<OptionIntegerRangeInclusiveMax> parser = TestingUtil.singleCommandParser(OptionIntegerRangeInclusiveMax.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-i", "101"});
    }

    @Test
    public void integer_range_single_value() throws IOException {
        SingleCommand<OptionIntegerRangeSingleValue> parser = TestingUtil.singleCommandParser(OptionIntegerRangeSingleValue.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", "0"});
        Assert.assertEquals((long)cmd.i, (long)0L);
        this.checkHelp(parser, new String[]{"value == 0"}, new String[0]);
    }

    @Test
    public void integer_range_complete() throws IOException {
        SingleCommand<OptionIntegerRangeComplete> parser = TestingUtil.singleCommandParser(OptionIntegerRangeComplete.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Long.toString(Long.MAX_VALUE)});
        Assert.assertEquals((long)cmd.i, (long)Long.MAX_VALUE);
        this.checkHelp(parser, new String[0], new String[]{String.format("%s <= value <= %s", Long.MIN_VALUE, Long.MAX_VALUE)});
    }

    @Test
    public void integer_range_complete_exclusive() throws IOException {
        SingleCommand<OptionIntegerRangeCompleteExclusive> parser = TestingUtil.singleCommandParser(OptionIntegerRangeCompleteExclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Long.toString(0x7FFFFFFFFFFFFFFEL)});
        Assert.assertEquals((long)cmd.i, (long)0x7FFFFFFFFFFFFFFEL);
        this.checkHelp(parser, new String[]{String.format("%s < value < %s", Long.MIN_VALUE, Long.MAX_VALUE)}, new String[0]);
    }

    @Test(expectedExceptions={ParseInvalidRestrictionException.class})
    public void integer_range_invalid_01() {
        TestingUtil.singleCommandParser(OptionIntegerRangeInvalid.class);
    }

    @Test(expectedExceptions={ParseInvalidRestrictionException.class})
    public void integer_range_invalid_02() {
        TestingUtil.singleCommandParser(OptionIntegerRangeInvalidSingleValue.class);
    }

    @Test
    public void integer_range_positive_01() throws IOException {
        SingleCommand<OptionRangePositive> parser = TestingUtil.singleCommandParser(OptionRangePositive.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(0)});
        int i = 1;
        while ((double)i <= 32678.0) {
            cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
            i *= 2;
        }
        this.checkHelp(parser, new String[]{"positive value", "value >= 0"}, new String[]{"negative value"});
    }

    @Test
    public void integer_range_positive_02() throws IOException {
        SingleCommand<OptionRangePositiveExcludesZero> parser = TestingUtil.singleCommandParser(OptionRangePositiveExcludesZero.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        int i = 1;
        while ((double)i <= 32678.0) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
            i *= 2;
        }
        this.checkHelp(parser, new String[]{"positive value", "value > 0"}, new String[]{"negative value"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void integer_range_positive_03() throws IOException {
        SingleCommand<OptionRangePositiveExcludesZero> parser = TestingUtil.singleCommandParser(OptionRangePositiveExcludesZero.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        parser.parse(new String[]{"-i", Integer.toString(0)});
    }

    @Test
    public void integer_range_negative_01() throws IOException {
        SingleCommand<OptionRangeNegative> parser = TestingUtil.singleCommandParser(OptionRangeNegative.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        int i = -1;
        while ((double)i >= -32678.0) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
            i = -(i * -2);
        }
        this.checkHelp(parser, new String[]{"negative value", "value < 0"}, new String[]{"positive value"});
    }

    @Test
    public void integer_range_negative_02() throws IOException {
        SingleCommand<OptionRangeNegativeIncludesZero> parser = TestingUtil.singleCommandParser(OptionRangeNegativeIncludesZero.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(0)});
        int i = -1;
        while ((double)i >= -32678.0) {
            cmd = (OptionRangeBase)parser.parse(new String[]{"-i", Integer.toString(i)});
            Assert.assertEquals((long)cmd.i, (long)i);
            i = -(i * -2);
        }
        this.checkHelp(parser, new String[]{"negative value", "value <= 0"}, new String[]{"positive value"});
    }

    @Test
    public void double_range_inclusive() throws IOException {
        SingleCommand<OptionDoubleRangeInclusive> parser = TestingUtil.singleCommandParser(OptionDoubleRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        for (double d = 0.0; d <= 1.0; d += 0.01) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-d", Double.toString(d)});
            Assert.assertEquals((Object)cmd.d, (Object)d);
        }
        this.checkHelp(parser, new String[]{"0 <= value <= 1.0"}, new String[0]);
    }

    @Test
    public void double_range_positive() throws IOException {
        SingleCommand<OptionRangePositive> parser = TestingUtil.singleCommandParser(OptionRangePositive.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-d", Double.toString(0.0)});
        for (double d = 1.0; d <= 32678.0; d *= 2.0) {
            cmd = (OptionRangeBase)parser.parse(new String[]{"-d", Double.toString(d)});
            Assert.assertEquals((Object)cmd.d, (Object)d);
        }
        this.checkHelp(parser, new String[]{"positive value", "value >= 0"}, new String[]{"negative value"});
    }

    @Test
    public void double_range_negative() throws IOException {
        SingleCommand<OptionRangeNegative> parser = TestingUtil.singleCommandParser(OptionRangeNegative.class);
        this.hasRestriction(parser.getCommandMetadata(), PositiveNegativeRestriction.class);
        double d = -1.0;
        while (d >= -32678.0) {
            OptionRangeBase cmd = (OptionRangeBase)parser.parse(new String[]{"-d", Double.toString(d)});
            Assert.assertEquals((Object)cmd.d, (Object)d);
            d = -(d * -2.0);
        }
        this.checkHelp(parser, new String[]{"negative value", "value < 0"}, new String[]{"positive value"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0.0 <= value <= 1.0).*")
    public void double_range_inclusive_below_min() {
        SingleCommand<OptionDoubleRangeInclusive> parser = TestingUtil.singleCommandParser(OptionDoubleRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-d", "-1.0"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(0.0 <= value <= 1.0).*")
    public void double_range_inclusive_above_max() {
        SingleCommand<OptionDoubleRangeInclusive> parser = TestingUtil.singleCommandParser(OptionDoubleRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-d", "1.01"});
    }

    @Test
    public void lexical_range_inclusive() throws IOException {
        SingleCommand<OptionLexicalRangeInclusive> parser = TestingUtil.singleCommandParser(OptionLexicalRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-s", "aardvark"});
        parser.parse(new String[]{"-s", "bear"});
        parser.parse(new String[]{"-s", "coyote"});
        parser.parse(new String[]{"-s", "d"});
        this.checkHelp(parser, new String[]{"a <= value <= d"}, new String[0]);
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(a <= value <= d).*")
    public void lexical_range_inclusive_above_max() {
        SingleCommand<OptionLexicalRangeInclusive> parser = TestingUtil.singleCommandParser(OptionLexicalRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-s", "deer"});
    }

    @Test(expectedExceptions={ParseOptionOutOfRangeException.class}, expectedExceptionsMessageRegExp=".*(a <= value <= d).*")
    public void lexical_range_inclusive_below_max() {
        SingleCommand<OptionLexicalRangeInclusive> parser = TestingUtil.singleCommandParser(OptionLexicalRangeInclusive.class);
        this.hasRangeRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-s", "0"});
    }
}

