/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.ports;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.annotations.restrictions.PortType;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.errors.ParseInvalidRestrictionException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.PortRange;
import com.github.rvesse.airline.restrictions.common.PortRangeImpl;
import com.github.rvesse.airline.restrictions.common.PortRestriction;
import com.github.rvesse.airline.restrictions.ports.OptionPortAll;
import com.github.rvesse.airline.restrictions.ports.OptionPortAll2;
import com.github.rvesse.airline.restrictions.ports.OptionPortAny;
import com.github.rvesse.airline.restrictions.ports.OptionPortBase;
import com.github.rvesse.airline.restrictions.ports.OptionPortCustom;
import com.github.rvesse.airline.restrictions.ports.OptionPortCustomInvalid;
import com.github.rvesse.airline.restrictions.ports.OptionPortCustomMultiple;
import com.github.rvesse.airline.restrictions.ports.OptionPortEphemeral;
import com.github.rvesse.airline.restrictions.ports.OptionPortSeveral;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPortRestrictions {
    private void hasPortRestriction(CommandMetadata metadata) {
        for (OptionMetadata option : metadata.getAllOptions()) {
            for (OptionRestriction restriction : option.getRestrictions()) {
                if (!(restriction instanceof PortRestriction)) continue;
                return;
            }
        }
        Assert.fail((String)"No PortRestriction found");
    }

    private void checkPorts(SingleCommand<? extends OptionPortBase> parser, PortRange type) {
        this.checkPorts(parser, type.getMinimumPort(), type.getMaximumPort());
    }

    private void checkPorts(SingleCommand<? extends OptionPortBase> parser, int min, int max) {
        for (int i = min; i <= max; ++i) {
            OptionPortBase cmd = (OptionPortBase)parser.parse(new String[]{"-p", Integer.toString(i)});
            Assert.assertEquals((int)cmd.port, (int)i);
        }
    }

    private String checkHelp(SingleCommand<? extends OptionPortBase> parser, PortRange[] included) throws IOException {
        return this.checkHelp(parser, included, new PortRange[0]);
    }

    private String checkHelp(SingleCommand<? extends OptionPortBase> parser, PortRange[] included, PortRange[] excluded) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Help.help((CommandMetadata)parser.getCommandMetadata(), (OutputStream)output);
        String usage = new String(output.toByteArray(), StandardCharsets.UTF_8);
        for (PortRange range : included) {
            if (range.getMinimumPort() != range.getMaximumPort()) {
                Assert.assertTrue((boolean)usage.contains(String.format("%d-%d", range.getMinimumPort(), range.getMaximumPort())));
                continue;
            }
            Assert.assertTrue((boolean)usage.contains(String.format("%d", range.getMinimumPort())));
        }
        for (PortRange range : excluded) {
            if (range.getMinimumPort() != range.getMaximumPort()) {
                Assert.assertFalse((boolean)usage.contains(String.format("%d-%d", range.getMinimumPort(), range.getMaximumPort())));
                continue;
            }
            Assert.assertFalse((boolean)usage.contains(String.format("%d", range.getMinimumPort())));
        }
        return usage;
    }

    @Test
    public void port_any() {
        SingleCommand<OptionPortAny> parser = TestingUtil.singleCommandParser(OptionPortAny.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)PortType.ANY);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_any_below_min() {
        SingleCommand<OptionPortAny> parser = TestingUtil.singleCommandParser(OptionPortAny.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "-1"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_any_above_max() {
        SingleCommand<OptionPortAny> parser = TestingUtil.singleCommandParser(OptionPortAny.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "65536"});
    }

    @Test
    public void port_all() {
        SingleCommand<OptionPortAll> parser = TestingUtil.singleCommandParser(OptionPortAll.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)PortType.ANY);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_all_below_min() {
        SingleCommand<OptionPortAll> parser = TestingUtil.singleCommandParser(OptionPortAll.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "-1"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_all_above_max() {
        SingleCommand<OptionPortAll> parser = TestingUtil.singleCommandParser(OptionPortAll.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "65536"});
    }

    @Test
    public void port_all2() {
        SingleCommand<OptionPortAll2> parser = TestingUtil.singleCommandParser(OptionPortAll2.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)PortType.ANY);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_all2_below_min() {
        SingleCommand<OptionPortAll2> parser = TestingUtil.singleCommandParser(OptionPortAll2.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "-1"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_all2_above_max() {
        SingleCommand<OptionPortAll2> parser = TestingUtil.singleCommandParser(OptionPortAll2.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", "65536"});
    }

    @Test
    public void port_ephemeral() {
        SingleCommand<OptionPortEphemeral> parser = TestingUtil.singleCommandParser(OptionPortEphemeral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)PortType.DYNAMIC);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_ephemeral_bad_system() {
        SingleCommand<OptionPortEphemeral> parser = TestingUtil.singleCommandParser(OptionPortEphemeral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", Integer.toString(PortType.SYSTEM.getMinimumPort())});
    }

    @Test
    public void port_several() {
        SingleCommand<OptionPortSeveral> parser = TestingUtil.singleCommandParser(OptionPortSeveral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)PortType.SYSTEM);
        this.checkPorts(parser, (PortRange)PortType.DYNAMIC);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void port_several_user() {
        SingleCommand<OptionPortSeveral> parser = TestingUtil.singleCommandParser(OptionPortSeveral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        parser.parse(new String[]{"-p", Integer.toString(PortType.USER.getMinimumPort())});
    }

    @Test
    public void port_custom_single() {
        SingleCommand<OptionPortCustom> parser = TestingUtil.singleCommandParser(OptionPortCustom.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)new PortRangeImpl(1500, 1600));
    }

    @Test
    public void port_custom_mutliple() {
        SingleCommand<OptionPortCustomMultiple> parser = TestingUtil.singleCommandParser(OptionPortCustomMultiple.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkPorts(parser, (PortRange)new PortRangeImpl(1500, 1600));
        this.checkPorts(parser, (PortRange)new PortRangeImpl(3500, 3600));
    }

    @Test(expectedExceptions={ParseInvalidRestrictionException.class})
    public void port_custom_invalid() {
        TestingUtil.singleCommandParser(OptionPortCustomInvalid.class);
    }

    @Test
    public void port_help_any() throws IOException {
        SingleCommand<OptionPortAny> parser = TestingUtil.singleCommandParser(OptionPortAny.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkHelp(parser, new PortRange[]{PortType.ANY});
    }

    @Test
    public void port_help_ephermeral() throws IOException {
        SingleCommand<OptionPortEphemeral> parser = TestingUtil.singleCommandParser(OptionPortEphemeral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkHelp(parser, new PortRange[]{PortType.DYNAMIC});
    }

    @Test
    public void port_help_several() throws IOException {
        SingleCommand<OptionPortSeveral> parser = TestingUtil.singleCommandParser(OptionPortSeveral.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        String usage = this.checkHelp(parser, new PortRange[]{PortType.DYNAMIC, PortType.SYSTEM});
        Assert.assertTrue((boolean)usage.contains("1-1023, 49152-65535"));
    }

    @Test
    public void port_help_all() throws IOException {
        SingleCommand<OptionPortAll> parser = TestingUtil.singleCommandParser(OptionPortAll.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkHelp(parser, new PortRange[]{PortType.ANY}, new PortRange[]{PortType.SYSTEM, PortType.USER, PortType.DYNAMIC});
    }

    @Test
    public void port_help_all2() throws IOException {
        SingleCommand<OptionPortAll2> parser = TestingUtil.singleCommandParser(OptionPortAll2.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        this.checkHelp(parser, new PortRange[]{PortType.ANY}, new PortRange[]{PortType.SYSTEM, PortType.USER, PortType.DYNAMIC});
    }

    @Test
    public void port_help_custom_single() throws IOException {
        SingleCommand<OptionPortCustom> parser = TestingUtil.singleCommandParser(OptionPortCustom.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        String usage = this.checkHelp(parser, new PortRange[]{new PortRangeImpl(1500, 1600)});
        Assert.assertTrue((boolean)usage.contains("1500-1600"));
    }

    @Test
    public void port_help_custom_multiple() throws IOException {
        SingleCommand<OptionPortCustomMultiple> parser = TestingUtil.singleCommandParser(OptionPortCustomMultiple.class);
        this.hasPortRestriction(parser.getCommandMetadata());
        String usage = this.checkHelp(parser, new PortRange[]{new PortRangeImpl(1500, 1600), new PortRangeImpl(3500, 3600)});
        Assert.assertTrue((boolean)usage.contains("1500-1600, 3500-3600"));
    }
}

