/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.partial;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.annotations.OptionType;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.parser.ParseState;
import com.github.rvesse.airline.parser.errors.ParseArgumentsIllegalValueException;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.AllowedRawValuesRestriction;
import com.github.rvesse.airline.restrictions.common.AllowedValuesRestriction;
import com.github.rvesse.airline.restrictions.common.IsRequiredRestriction;
import com.github.rvesse.airline.restrictions.common.NotBlankRestriction;
import com.github.rvesse.airline.restrictions.common.PartialRestriction;
import com.github.rvesse.airline.restrictions.partial.PartialAnnotated;
import com.github.rvesse.airline.restrictions.partial.PartialUnannotated;
import com.github.rvesse.airline.restrictions.partial.PartialsAnnotated;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartialRestriction {
    @Test
    public void partial_notblank_01() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("not-blank");
        titles.add("blank");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new NotBlankRestriction());
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state = state.withArgument(arguments, "text");
        state = state.withArgument(arguments, "");
        restriction.finalValidate(state, arguments);
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*'not-blank' requires a non-blank value.*")
    public void partial_notblank_02() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("not-blank");
        titles.add("blank");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new NotBlankRestriction());
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state = state.withArgument(arguments, "");
    }

    @Test
    public void partial_allowed_values_01() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("set-values");
        titles.add("any");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new AllowedValuesRestriction(new String[]{"foo"}));
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state = state.withArgument(arguments, "foo");
        state = state.withArgument(arguments, "bar");
        restriction.finalValidate(state, arguments);
    }

    @Test(expectedExceptions={ParseArgumentsIllegalValueException.class}, expectedExceptionsMessageRegExp=".*set-values' was given as 'bar' which is not in the list of allowed values: \\[foo\\]")
    public void partial_allowed_values_02() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("set-values");
        titles.add("any");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new AllowedValuesRestriction(new String[]{"foo"}));
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state.withArgument(arguments, "bar");
    }

    @Test
    public void partial_allowed_raw_values_01() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("set-values");
        titles.add("any");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new AllowedRawValuesRestriction(false, Locale.ENGLISH, new String[]{"foo"}));
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state = state.withArgument(arguments, "foo");
        state = state.withArgument(arguments, "bar");
        restriction.finalValidate(state, arguments);
    }

    @Test(expectedExceptions={ParseArgumentsIllegalValueException.class}, expectedExceptionsMessageRegExp=".*set-values' was given as 'bar' which is not in the list of allowed values: \\[foo\\]")
    public void partial_allowed_raw_values_02() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("set-values");
        titles.add("any");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new AllowedRawValuesRestriction(false, Locale.ENGLISH, new String[]{"foo"}));
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state.withArgument(arguments, "bar");
    }

    @Test
    public void partial_allowed_raw_values_03() throws NoSuchFieldException, SecurityException {
        ArrayList<String> names = new ArrayList<String>();
        names.add("--kvp");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (OptionRestriction)new AllowedRawValuesRestriction(false, Locale.ENGLISH, new String[]{"a", "b", "c"}));
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("kvps"));
        OptionMetadata option = new OptionMetadata(OptionType.COMMAND, names, Arrays.asList("Key", "Value"), "", 2, false, false, false, restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        state = state.withOptionValue(option, "a");
        state = state.withOptionValue(option, "value");
        restriction.finalValidate(state, option);
    }

    @Test
    public void partial_required_01() throws NoSuchFieldException, SecurityException {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("not-blank");
        titles.add("blank");
        ArrayList<PartialRestriction> restrictions = new ArrayList<PartialRestriction>();
        PartialRestriction restriction = new PartialRestriction(new int[]{0}, (ArgumentsRestriction)new IsRequiredRestriction());
        restrictions.add(restriction);
        List<Field> fields = Collections.singletonList(PartialUnannotated.class.getField("args"));
        ArgumentsMetadata arguments = new ArgumentsMetadata(titles, "", restrictions, null, fields);
        ParseState state = ParseState.newInstance();
        restriction.finalValidate(state, arguments);
    }

    @Test
    public void partial_annotated_notblank_01() throws NoSuchFieldException, SecurityException {
        SingleCommand parser = SingleCommand.singleCommand(PartialAnnotated.class);
        PartialAnnotated cmd = (PartialAnnotated)parser.parse(new String[]{"--kvp", "text", ""});
        Assert.assertEquals((int)cmd.kvps.size(), (int)2);
        Assert.assertEquals((String)cmd.kvps.get(0), (String)"text");
        Assert.assertEquals((String)cmd.kvps.get(1), (String)"");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*--kvp value '<Key>' requires a non-blank value.*")
    public void partial_annotated_notblank_02() throws NoSuchFieldException, SecurityException {
        SingleCommand parser = SingleCommand.singleCommand(PartialAnnotated.class);
        parser.parse(new String[]{"--kvp", "", "text"});
    }

    @Test
    public void partials_annotated_01() {
        SingleCommand parser = SingleCommand.singleCommand(PartialsAnnotated.class);
        PartialsAnnotated cmd = (PartialsAnnotated)parser.parse(new String[]{"--kvp", "server", "remote.com"});
        Assert.assertEquals((int)cmd.kvps.size(), (int)2);
        Assert.assertEquals((String)cmd.kvps.get(0), (String)"server");
        Assert.assertEquals((String)cmd.kvps.get(1), (String)"remote.com");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void partials_annotated_02() {
        SingleCommand parser = SingleCommand.singleCommand(PartialsAnnotated.class);
        parser.parse(new String[]{"--kvp", "other", "remote.com"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void partials_annotated_03() {
        SingleCommand parser = SingleCommand.singleCommand(PartialsAnnotated.class);
        parser.parse(new String[]{"--kvp", "server", ""});
    }
}

