/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.TestingUtil;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.restrictions.Args1NotOptionLike;
import com.github.rvesse.airline.restrictions.NumbersNoOptionLike;
import com.github.rvesse.airline.restrictions.NumbersNoOptionLikeGlobal;
import com.github.rvesse.airline.restrictions.Strings;
import com.github.rvesse.airline.restrictions.StringsNotOptionLike;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStrings {
    private SingleCommand<Strings> parser() {
        return TestingUtil.singleCommandParser(Strings.class);
    }

    private SingleCommand<StringsNotOptionLike> parserNotOptionLike() {
        return TestingUtil.singleCommandParser(StringsNotOptionLike.class);
    }

    @Test
    public void not_empty_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--not-empty", "foo"});
        Assert.assertEquals((String)cmd.notEmpty, (String)"foo");
    }

    @Test
    public void not_empty_valid_blank() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--not-empty", " "});
        Assert.assertEquals((String)cmd.notEmpty, (String)" ");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void not_empty_invalid() {
        this.parser().parse(new String[]{"--not-empty", ""});
    }

    @Test
    public void not_blank_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--not-blank", "foo"});
        Assert.assertEquals((String)cmd.notBlank, (String)"foo");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void not_blank_invalid() {
        this.parser().parse(new String[]{"--not-blank", ""});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void not_blank_invalid_blank() {
        this.parser().parse(new String[]{"--not-blank", " "});
    }

    @Test
    public void pattern_tel_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--tel", "555-123-4567"});
        Assert.assertEquals((String)cmd.tel, (String)"555-123-4567");
    }

    @Test
    public void pattern_tel_valid_prefixed() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--tel", "+1-555-123-4567"});
        Assert.assertEquals((String)cmd.tel, (String)"+1-555-123-4567");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*standard US format.*")
    public void pattern_tel_invalid() {
        this.parser().parse(new String[]{"--tel", "foo"});
    }

    @Test
    public void min_length_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--min", "foobar"});
        Assert.assertEquals((String)cmd.minLength, (String)"foobar");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*below the minimum required length of 4.*")
    public void min_length_invalid() {
        this.parser().parse(new String[]{"--min", "foo"});
    }

    @Test
    public void max_length_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--max", "foo"});
        Assert.assertEquals((String)cmd.maxLength, (String)"foo");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*exceeds the maximum permitted length of 4.*")
    public void max_length_invalid() {
        this.parser().parse(new String[]{"--max", "foobar"});
    }

    @Test
    public void exact_length_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--exact", "fooba"});
        Assert.assertEquals((String)cmd.exact, (String)"fooba");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*required length of 5.*")
    public void exact_length_invalid_01() {
        this.parser().parse(new String[]{"--exact", "foobar"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*required length of 5.*")
    public void exact_length_invalid_02() {
        this.parser().parse(new String[]{"--exact", "foo"});
    }

    @Test
    public void range_exact_length_valid() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--range-exact", "foob"});
        Assert.assertEquals((String)cmd.rangeExact, (String)"foob");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*required length of 4.*")
    public void range_exact_length_invalid_01() {
        this.parser().parse(new String[]{"--range-exact", "foobar"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*required length of 4.*")
    public void range_exact_length_invalid_02() {
        this.parser().parse(new String[]{"--range-exact", "foo"});
    }

    @Test
    public void range_length_valid_01() {
        String test = "foobar";
        for (int i = 4; i <= 6; ++i) {
            Strings cmd = (Strings)this.parser().parse(new String[]{"--range", test.substring(0, i)});
            Assert.assertEquals((String)cmd.range, (String)test.substring(0, i));
        }
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*in the accepted length range of 4 to 6 characters.*")
    public void range_length_invalid_01() {
        this.parser().parse(new String[]{"--range", "foobartaz"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*in the accepted length range of 4 to 6 characters.*")
    public void range_length_invalid_02() {
        this.parser().parse(new String[]{"--range", "foo"});
    }

    @Test
    public void pattern_case_insensitive_01() {
        this.parser().parse(new String[]{"--other", "foo"});
    }

    @Test
    public void pattern_case_insensitive_02() {
        this.parser().parse(new String[]{"--other", "BaR"});
    }

    @Test
    public void pattern_case_insensitive_03() {
        this.parser().parse(new String[]{"--other", "fooBAR"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void pattern_case_insensitive_invalid() {
        this.parser().parse(new String[]{"--other", "test"});
    }

    @Test
    public void ends_with_01() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--images", "test.jpg"});
        Assert.assertEquals((int)cmd.images.size(), (int)1);
        Assert.assertEquals((String)cmd.images.get(0), (String)"test.jpg");
    }

    @Test
    public void ends_with_02() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--images", "test.jpg", "--images", "test.png", "--images", "test.gif"});
        Assert.assertEquals((int)cmd.images.size(), (int)3);
        Assert.assertEquals((String)cmd.images.get(0), (String)"test.jpg");
        Assert.assertEquals((String)cmd.images.get(1), (String)"test.png");
        Assert.assertEquals((String)cmd.images.get(2), (String)"test.gif");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void ends_with_03() {
        this.parser().parse(new String[]{"--images", "test.txt"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void ends_with_04() {
        this.parser().parse(new String[]{"--images", "test.JPG"});
    }

    @Test
    public void ends_with_case_insensitive_01() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--images-ci", "test.jpg"});
        Assert.assertEquals((int)cmd.imagesCaseInsensitive.size(), (int)1);
        Assert.assertEquals((String)cmd.imagesCaseInsensitive.get(0), (String)"test.jpg");
    }

    @Test
    public void ends_with_case_insensitive_02() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--images-ci", "test.jpg", "--images-ci", "test.PNG", "--images-ci", "test.GiF"});
        Assert.assertEquals((int)cmd.imagesCaseInsensitive.size(), (int)3);
        Assert.assertEquals((String)cmd.imagesCaseInsensitive.get(0), (String)"test.jpg");
        Assert.assertEquals((String)cmd.imagesCaseInsensitive.get(1), (String)"test.PNG");
        Assert.assertEquals((String)cmd.imagesCaseInsensitive.get(2), (String)"test.GiF");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void ends_with_case_insensitive_03() {
        this.parser().parse(new String[]{"--images-ci", "test.txt"});
    }

    @Test
    public void ends_with_case_insensitive_04() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--images-ci", "test.JPG"});
        Assert.assertEquals((int)cmd.imagesCaseInsensitive.size(), (int)1);
        Assert.assertEquals((String)cmd.imagesCaseInsensitive.get(0), (String)"test.JPG");
    }

    @Test
    public void starts_with_01() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--urls", "http://test.com"});
        Assert.assertEquals((int)cmd.urls.size(), (int)1);
        Assert.assertEquals((String)cmd.urls.get(0), (String)"http://test.com");
    }

    @Test
    public void starts_with_02() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--urls", "http://test.com", "--urls", "https://secure.com", "--urls", "ftp://uploads.com"});
        Assert.assertEquals((int)cmd.urls.size(), (int)3);
        Assert.assertEquals((String)cmd.urls.get(0), (String)"http://test.com");
        Assert.assertEquals((String)cmd.urls.get(1), (String)"https://secure.com");
        Assert.assertEquals((String)cmd.urls.get(2), (String)"ftp://uploads.com");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void starts_with_03() {
        this.parser().parse(new String[]{"--urls", "test.txt"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void starts_with_04() {
        this.parser().parse(new String[]{"--urls", "HTTP://test.com"});
    }

    @Test
    public void starts_with_case_insensitive_01() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--urls-ci", "http://test.com"});
        Assert.assertEquals((int)cmd.urlsCaseInsensitive.size(), (int)1);
        Assert.assertEquals((String)cmd.urlsCaseInsensitive.get(0), (String)"http://test.com");
    }

    @Test
    public void starts_with_case_insensitive_02() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--urls-ci", "http://test.com", "--urls-ci", "HTTPS://secure.com", "--urls-ci", "FtP://uploads.com"});
        Assert.assertEquals((int)cmd.urlsCaseInsensitive.size(), (int)3);
        Assert.assertEquals((String)cmd.urlsCaseInsensitive.get(0), (String)"http://test.com");
        Assert.assertEquals((String)cmd.urlsCaseInsensitive.get(1), (String)"HTTPS://secure.com");
        Assert.assertEquals((String)cmd.urlsCaseInsensitive.get(2), (String)"FtP://uploads.com");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class})
    public void starts_with_case_insensitive_03() {
        this.parser().parse(new String[]{"--urls-ci", "urn:foo"});
    }

    @Test
    public void starts_with_case_insensitive_04() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--urls-ci", "HTTP://test.com"});
        Assert.assertEquals((int)cmd.urlsCaseInsensitive.size(), (int)1);
        Assert.assertEquals((String)cmd.urlsCaseInsensitive.get(0), (String)"HTTP://test.com");
    }

    @Test
    public void no_option_like_01() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--not-option-like", "foo", "--not-option-like", "bar"});
        Assert.assertEquals((int)cmd.notOptionLike.size(), (int)2);
        Assert.assertEquals((String)cmd.notOptionLike.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.notOptionLike.get(1), (String)"bar");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_02() {
        this.parser().parse(new String[]{"--not-option-like", "--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_03() {
        this.parser().parse(new String[]{"--not-option-like", "-f"});
    }

    @Test
    public void no_option_like_04() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"--not-option-like-long", "-f"});
        Assert.assertEquals((int)cmd.notOptionLikeLong.size(), (int)1);
        Assert.assertEquals((String)cmd.notOptionLikeLong.get(0), (String)"-f");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_05() {
        this.parser().parse(new String[]{"--not-option-like-long", "--foo"});
    }

    @Test
    public void no_option_like_06() {
        Strings cmd = (Strings)this.parser().parse(new String[]{"foo", "bar"});
        Assert.assertEquals((int)cmd.args.size(), (int)2);
        Assert.assertEquals((String)cmd.args.get(0), (String)"foo");
        Assert.assertEquals((String)cmd.args.get(1), (String)"bar");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_07() {
        this.parser().parse(new String[]{"--unrecognized"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_08() {
        this.parser().parse(new String[]{"--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_01() {
        this.parserNotOptionLike().parse(new String[]{"--not-empty", "--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_02() {
        this.parserNotOptionLike().parse(new String[]{"--not-blank", "--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_03() {
        this.parserNotOptionLike().parse(new String[]{"--min", "--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_04() {
        this.parserNotOptionLike().parse(new String[]{"--not-option-like", "--foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_05() {
        this.parserNotOptionLike().parse(new String[]{"--not-option-like-long", "-foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_06() {
        this.parserNotOptionLike().parse(new String[]{"-foo"});
    }

    @Test
    public void no_option_like_global_07() {
        SingleCommand<Args1> parser = TestingUtil.singleCommandParser(Args1.class);
        Args1 cmd = (Args1)parser.parse(new String[]{"-foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"-foo");
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_global_08() {
        SingleCommand<Args1NotOptionLike> parser = TestingUtil.singleCommandParser(Args1NotOptionLike.class);
        parser.parse(new String[]{"-foo"});
    }

    @Test(expectedExceptions={ParseRestrictionViolatedException.class}, expectedExceptionsMessageRegExp=".*appears to be an option.*")
    public void no_option_like_numerics_01() {
        SingleCommand<NumbersNoOptionLike> parser = TestingUtil.singleCommandParser(NumbersNoOptionLike.class);
        parser.parse(new String[]{"--long", "-1"});
    }

    @Test
    public void no_option_like_numerics_02() {
        SingleCommand<NumbersNoOptionLikeGlobal> parser = TestingUtil.singleCommandParser(NumbersNoOptionLikeGlobal.class);
        NumbersNoOptionLikeGlobal cmd = (NumbersNoOptionLikeGlobal)parser.parse(new String[]{"--long", "-1"});
        Assert.assertEquals((long)cmd.l, (long)-1L);
    }
}

