/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.restrictions.global.CommandRequired;
import com.github.rvesse.airline.annotations.restrictions.global.NoMissingOptionValues;
import com.github.rvesse.airline.annotations.restrictions.global.NoUnexpectedArguments;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.parser.errors.ParseArgumentsUnexpectedException;
import com.github.rvesse.airline.parser.errors.ParseCommandMissingException;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.errors.ParseOptionMissingValueException;
import com.github.rvesse.airline.restrictions.global.CommandRequiredRestriction;
import com.github.rvesse.airline.restrictions.global.NoMissingOptionValuesRestriction;
import com.github.rvesse.airline.restrictions.global.NoUnexpectedArgumentsRestriction;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestGlobalRestrictions {
    @Test
    public void global_restrictions_unrestricted_no_command() {
        Cli parser = new Cli(UnrestrictedCli.class);
        Object cmd = parser.parse(new String[0]);
        Assert.assertNull((Object)cmd);
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void global_restrictions_unrestricted_missing_option_value() {
        Cli parser = new Cli(UnrestrictedCli.class);
        Object cmd = parser.parse(new String[]{"Args1", "-long"});
        Assert.assertTrue((boolean)(cmd instanceof Args1));
    }

    @Test
    public void global_restrictions_unrestricted_unexpected_arguments() {
        Cli parser = new Cli(UnrestrictedCli.class);
        Object cmd = parser.parse(new String[]{"empty", "test"});
        Assert.assertTrue((boolean)(cmd instanceof EmptyCommand));
    }

    @Test(expectedExceptions={ParseCommandMissingException.class})
    public void global_restrictions_command_required_01() {
        Cli parser = new Cli(CommandRequiredCli.class);
        parser.parse(new String[0]);
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void global_restrictions_command_required_02() {
        Cli parser = new Cli(CommandRequiredCli.class);
        parser.parse(new String[]{"foo"});
    }

    @Test(expectedExceptions={ParseCommandMissingException.class})
    public void global_restrictions_command_required_annotation_01() {
        Cli parser = new Cli(CommandRequiredAnnotationCli.class);
        parser.parse(new String[0]);
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void global_restrictions_command_required_annotation_02() {
        Cli parser = new Cli(CommandRequiredAnnotationCli.class);
        parser.parse(new String[]{"foo"});
    }

    @Test
    public void global_restrictions_no_unexpected_args_01() {
        Cli parser = new Cli(NoUnexpectedArgumentsCli.class);
        Object cmd = parser.parse(new String[]{"empty"});
        Assert.assertTrue((boolean)(cmd instanceof EmptyCommand));
    }

    @Test
    public void global_restrictions_no_unexpected_args_02() {
        Cli parser = new Cli(NoUnexpectedArgumentsCli.class);
        Object cmd = parser.parse(new String[]{"Args1", "test"});
        Assert.assertTrue((boolean)(cmd instanceof Args1));
        Args1 args = (Args1)cmd;
        Assert.assertEquals((int)args.parameters.size(), (int)1);
        Assert.assertEquals((String)args.parameters.get(0), (String)"test");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void global_restrictions_no_unexpected_args_03() {
        Cli parser = new Cli(NoUnexpectedArgumentsCli.class);
        parser.parse(new String[]{"empty", "test"});
    }

    @Test
    public void global_restrictions_no_unexpected_args_annotation_01() {
        Cli parser = new Cli(NoUnexpectedArgumentsAnnotationCli.class);
        Object cmd = parser.parse(new String[]{"empty"});
        Assert.assertTrue((boolean)(cmd instanceof EmptyCommand));
    }

    @Test
    public void global_restrictions_no_unexpected_args_annotation_02() {
        Cli parser = new Cli(NoUnexpectedArgumentsAnnotationCli.class);
        Object cmd = parser.parse(new String[]{"Args1", "test"});
        Assert.assertTrue((boolean)(cmd instanceof Args1));
        Args1 args = (Args1)cmd;
        Assert.assertEquals((int)args.parameters.size(), (int)1);
        Assert.assertEquals((String)args.parameters.get(0), (String)"test");
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void global_restrictions_no_unexpected_args_annotation_03() {
        Cli parser = new Cli(NoUnexpectedArgumentsAnnotationCli.class);
        parser.parse(new String[]{"empty", "test"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void global_restrictions_missing_option_values_01() {
        Cli parser = new Cli(NoMissingOptionValuesCli.class);
        parser.parse(new String[]{"Args1", "-long"});
    }

    @Test(expectedExceptions={ParseOptionMissingValueException.class})
    public void global_restrictions_missing_option_values_02() {
        Cli parser = new Cli(NoMissingOptionValuesAnnotationCli.class);
        parser.parse(new String[]{"Args1", "-long"});
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false)
    @NoMissingOptionValues
    private class NoMissingOptionValuesAnnotationCli {
        private NoMissingOptionValuesAnnotationCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false, restrictions={NoMissingOptionValuesRestriction.class})
    private class NoMissingOptionValuesCli {
        private NoMissingOptionValuesCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false)
    @NoUnexpectedArguments
    private class NoUnexpectedArgumentsAnnotationCli {
        private NoUnexpectedArgumentsAnnotationCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false, restrictions={NoUnexpectedArgumentsRestriction.class})
    private class NoUnexpectedArgumentsCli {
        private NoUnexpectedArgumentsCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false)
    @CommandRequired
    private class CommandRequiredAnnotationCli {
        private CommandRequiredAnnotationCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false, restrictions={CommandRequiredRestriction.class})
    private class CommandRequiredCli {
        private CommandRequiredCli() {
        }
    }

    @com.github.rvesse.airline.annotations.Cli(name="cli", description="Test CLI", commands={Args1.class, EmptyCommand.class}, includeDefaultRestrictions=false)
    private class UnrestrictedCli {
        private UnrestrictedCli() {
        }
    }

    @Command(name="empty", description="Empty Command")
    public static class EmptyCommand {
    }
}

