/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.help.cli.CliGlobalUsageGenerator;
import com.github.rvesse.airline.model.AliasMetadata;
import com.github.rvesse.airline.parser.aliases.Logs;
import com.github.rvesse.airline.parser.aliases.LogsWithParser;
import com.github.rvesse.airline.parser.errors.ParseAliasCircularReferenceException;
import com.github.rvesse.airline.parser.errors.ParseCommandUnrecognizedException;
import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import com.github.rvesse.airline.parser.resources.ClasspathLocator;
import com.github.rvesse.airline.parser.resources.EnvVarLocator;
import com.github.rvesse.airline.parser.resources.JvmSystemPropertyLocator;
import com.github.rvesse.airline.parser.resources.ResourceLocator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestAliases {
    private static final File f = new File("target/test.config");
    private static String homeDir;

    @BeforeClass
    public static void setup() {
        homeDir = System.getProperty("user.home");
        System.setProperty("user.home", new File("target/").getAbsolutePath());
    }

    @AfterClass
    public static void cleanup() {
        if (f.exists()) {
            f.delete();
        }
        System.setProperty("user.home", homeDir);
    }

    public static void prepareConfig(File f, String ... lines) throws IOException {
        FileWriter writer = new FileWriter(f);
        for (String line : lines) {
            writer.append(line);
            writer.append('\n');
        }
        writer.close();
    }

    public static void customEnvironment(Map<String, String> customEnvironment) throws Exception {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(customEnvironment);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(customEnvironment);
        }
        catch (NoSuchFieldException e) {
            Class<?>[] classes = Collections.class.getDeclaredClasses();
            Map<String, String> env = System.getenv();
            for (Class<?> cl : classes) {
                if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                Field field = cl.getDeclaredField("m");
                field.setAccessible(true);
                Object obj = field.get(env);
                Map map = (Map)obj;
                map.putAll(customEnvironment);
            }
        }
    }

    @Test
    public void user_aliases_default_01() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_default_02() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"other").withCommand(Args1.class);
        builder.withParser().withUserAliases().withProgramName("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)0);
    }

    @Test
    public void user_aliases_01() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_02() throws IOException {
        TestAliases.prepareConfig(f, "a.foo=Args1 bar", "b.foo=Args1 faz");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withPrefix("b.").withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"faz");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"faz");
    }

    @Test
    public void user_aliases_home_dir_01() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocations(new String[]{"~/", "~\\"});
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_home_dir_02() throws IOException {
        TestAliases.prepareConfig(f, "a.foo=Args1 bar", "b.foo=Args1 faz");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withPrefix("b.").withSearchLocations(new String[]{"~/", "~\\"});
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"faz");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"faz");
    }

    @Test
    public void user_aliases_home_dir_03() throws IOException {
        TestAliases.prepareConfig(f, "");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocations(new String[]{"~/", "~\\"});
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void user_aliases_working_dir_01() throws IOException {
        File workingDir = Paths.get("", new String[0]).toAbsolutePath().toFile();
        File config = new File(workingDir, "test.config");
        TestAliases.prepareConfig(config, "foo=Args1 bar");
        try {
            CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
            builder.withParser().withUserAliases().withFilename(config.getName()).withSearchLocations(new String[]{"./", ".\\"});
            Cli cli = builder.build();
            List aliases = cli.getMetadata().getParserConfiguration().getAliases();
            Assert.assertEquals((int)aliases.size(), (int)1);
            AliasMetadata alias = (AliasMetadata)aliases.get(0);
            Assert.assertEquals((String)alias.getName(), (String)"foo");
            List args = alias.getArguments();
            Assert.assertEquals((int)args.size(), (int)2);
            Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
            Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
            Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
            Assert.assertEquals((int)cmd.parameters.size(), (int)1);
            Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
        }
        finally {
            config.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void user_aliases_working_dir_02() throws IOException {
        File workingDir = Paths.get("", new String[0]).toAbsolutePath().toFile();
        File config = new File(workingDir, "test.config");
        TestAliases.prepareConfig(config, "");
        try {
            CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
            builder.withParser().withUserAliases().withFilename(config.getName()).withSearchLocations(new String[]{"./", ".\\"});
            Cli cli = builder.build();
            List aliases = cli.getMetadata().getParserConfiguration().getAliases();
            Assert.assertEquals((int)aliases.size(), (int)0);
        }
        finally {
            config.delete();
        }
    }

    @Test
    public void user_aliases_env_01() throws Exception {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("FOO", f.getParentFile().getAbsolutePath());
        TestAliases.customEnvironment(custom);
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO}/").withLocator((ResourceLocator)new EnvVarLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_env_02() throws Exception {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("FOO", f.getParentFile().getAbsolutePath());
        TestAliases.customEnvironment(custom);
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO/").withLocator((ResourceLocator)new EnvVarLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)0);
    }

    @Test
    public void user_aliases_env_03() throws Exception {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("FOO", new File(f.getAbsolutePath()).getParentFile().getParentFile().getAbsolutePath());
        custom.put("BAR", f.getParentFile().getName());
        TestAliases.customEnvironment(custom);
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO}/${BAR}/").withLocator((ResourceLocator)new EnvVarLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_env_04() throws Exception {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("FOO", new File(f.getAbsolutePath()).getParentFile().getParentFile().getAbsolutePath());
        TestAliases.customEnvironment(custom);
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO}/${UNDEF}/").withLocator((ResourceLocator)new EnvVarLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)0);
    }

    @Test
    public void user_aliases_sysprop_01() throws Exception {
        System.getProperties().put("FOO", f.getParentFile().getAbsolutePath());
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO}/").withLocator((ResourceLocator)new JvmSystemPropertyLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_sysprop_02() throws Exception {
        System.getProperties().put("FOO", f.getParentFile().getAbsolutePath());
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO/").withLocator((ResourceLocator)new JvmSystemPropertyLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)0);
    }

    @Test
    public void user_aliases_sysprop_03() throws Exception {
        System.getProperties().put("FOO", new File(f.getAbsolutePath()).getParentFile().getParentFile().getAbsolutePath());
        System.getProperties().put("BAR", f.getParentFile().getName());
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("${FOO}/${BAR}/").withLocator((ResourceLocator)new JvmSystemPropertyLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_classpath_01() throws Exception {
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename("aliases.config").withSearchLocation("/").withLocator((ResourceLocator)new ClasspathLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_classpath_02() throws Exception {
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename("aliases.config").withSearchLocation("classpath:/").withLocator((ResourceLocator)new ClasspathLocator());
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void user_aliases_positional_01() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 -long $1");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)3);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"-long");
        Assert.assertEquals((String)((String)args.get(2)), (String)"$1");
        cli.parse(new String[]{"foo"});
    }

    @Test
    public void user_aliases_positional_02() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 -long $1");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)3);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"-long");
        Assert.assertEquals((String)((String)args.get(2)), (String)"$1");
        Args1 cmd = (Args1)cli.parse(new String[]{"foo", "345"});
        Assert.assertEquals((long)cmd.l, (long)345L);
        Assert.assertEquals((int)cmd.parameters.size(), (int)0);
    }

    @Test
    public void user_aliases_positional_03() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAlias("foo").withArguments(new String[]{"Args1", "-long", "$1", "-float", "$3"});
        Cli cli = builder.build();
        Args1 cmd = (Args1)cli.parse(new String[]{"foo", "345", "bar", "1.23"});
        Assert.assertEquals((long)cmd.l, (long)345L);
        Assert.assertEquals((Object)Float.valueOf(cmd.floa), (Object)Float.valueOf(1.23f));
        List<String> args = cmd.parameters;
        Assert.assertEquals((int)args.size(), (int)1);
        Assert.assertEquals((String)args.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_positional_04() throws IOException {
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAlias("foo").withArguments(new String[]{"Args1", "-long", "$1", "-float", "$5"});
        Cli cli = builder.build();
        Args1 cmd = (Args1)cli.parse(new String[]{"foo", "345", "a", "b", "c", "1.23", "d", "e"});
        Assert.assertEquals((long)cmd.l, (long)345L);
        Assert.assertEquals((Object)Float.valueOf(cmd.floa), (Object)Float.valueOf(1.23f));
        List<String> args = cmd.parameters;
        Assert.assertEquals((int)args.size(), (int)5);
        int i = 0;
        int c = 97;
        while (i < args.size()) {
            Assert.assertEquals((String)args.get(i), (String)new String(new char[]{(char)c}));
            ++i;
            ++c;
        }
    }

    @Test
    public void user_aliases_override_01() throws IOException {
        TestAliases.prepareConfig(f, "Args1=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"Args1");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)0);
    }

    @Test
    public void user_aliases_override_02() throws IOException {
        TestAliases.prepareConfig(f, "Args1=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"Args1");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        Args1 cmd = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertEquals((String)cmd.parameters.get(0), (String)"bar");
    }

    @Test
    public void user_aliases_no_args() throws IOException {
        TestAliases.prepareConfig(f, "foo=Args1 bar");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class).withDefaultCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withSearchLocation("target/");
        Cli cli = builder.build();
        List aliases = cli.getMetadata().getParserConfiguration().getAliases();
        Assert.assertEquals((int)aliases.size(), (int)1);
        AliasMetadata alias = (AliasMetadata)aliases.get(0);
        Assert.assertEquals((String)alias.getName(), (String)"foo");
        List args = alias.getArguments();
        Assert.assertEquals((int)args.size(), (int)2);
        Assert.assertEquals((String)((String)args.get(0)), (String)"Args1");
        Assert.assertEquals((String)((String)args.get(1)), (String)"bar");
        cli.parse(new String[0]);
    }

    @Test
    public void user_aliases_help_01() throws IOException {
        TestAliases.prepareConfig(f, "a.foo=Args1 bar", "b.foo=Args1 faz");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withFilename(f.getName()).withPrefix("b.").withSearchLocation("target/");
        Cli cli = builder.build();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        new CliGlobalUsageGenerator().usage(cli.getMetadata(), (OutputStream)output);
        Assert.assertEquals((String)new String(output.toByteArray(), StandardCharsets.UTF_8), (String)StringUtils.join((Object[])new String[]{"NAME", "        test -", "", "SYNOPSIS", "        test <command> [ <args> ]", "", "COMMANDS", "        Args1", "            args1 description", "", "USER DEFINED ALIASES", "        This CLI supports user defined aliases which may be placed in a", "        test.config file located in the following location(s):", "", "            1) target/", "", "        This file contains aliases defined in Java properties file style e.g.", "", "            b.foo=bar --flag", "", "        Here an alias foo is defined which causes the bar command to be invoked", "        with the --flag option passed to it. Aliases are distinguished from", "        other properties in the file by the prefix 'b.' as seen in the example.", "", "        Alias definitions are subject to the following conditions:", "", "            - Aliases cannot override existing commands", "            - Aliases cannot be defined in terms of other aliases", ""}, (char)'\n'));
    }

    private String[] generateAliasesChain(int links, boolean circular, String terminal) {
        String[] aliases = new String[links];
        for (int i = 0; i < links; ++i) {
            aliases[i] = i < links - 1 ? String.format("%s=%s", Character.valueOf((char)(97 + i)), Character.valueOf((char)(97 + i + 1))) : (circular ? String.format("%s=a", Character.valueOf((char)(97 + i))) : String.format("%s=%s", Character.valueOf((char)(97 + i)), terminal));
        }
        return aliases;
    }

    @Test
    public void user_aliases_chained_01() throws IOException {
        String[] aliases = this.generateAliasesChain(2, false, "Args1");
        TestAliases.prepareConfig(f, aliases);
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        cli.parse(new String[]{aliases[0].substring(0, aliases[0].indexOf(61))});
    }

    @Test
    public void user_aliases_chained_02() throws IOException {
        for (int i = 1; i < 20; ++i) {
            String[] aliases = this.generateAliasesChain(i, false, "Args1");
            TestAliases.prepareConfig(f, aliases);
            CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
            builder.withParser().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
            Cli cli = builder.build();
            for (int j = 0; j < aliases.length; ++j) {
                cli.parse(new String[]{aliases[j].substring(0, aliases[j].indexOf(61))});
            }
        }
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void user_aliases_circular_01() throws IOException {
        String[] aliases = this.generateAliasesChain(2, true, null);
        TestAliases.prepareConfig(f, aliases);
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        cli.parse(new String[]{aliases[0].substring(0, aliases[0].indexOf(61))});
    }

    @Test
    public void user_aliases_circular_02() throws IOException {
        for (int i = 1; i < 20; ++i) {
            String[] aliases = this.generateAliasesChain(i, true, null);
            TestAliases.prepareConfig(f, aliases);
            CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
            builder.withParser().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
            Cli cli = builder.build();
            for (int j = 0; j < aliases.length; ++j) {
                try {
                    cli.parse(new String[]{aliases[j].substring(0, aliases[j].indexOf(61))});
                    Assert.fail((String)"Did not produce circular reference exception");
                    continue;
                }
                catch (ParseAliasCircularReferenceException parseAliasCircularReferenceException) {
                    // empty catch block
                }
            }
        }
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void user_aliases_chained_03() throws IOException {
        TestAliases.prepareConfig(f, "a=a");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        cli.parse(new String[]{"a"});
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void user_aliases_chained_04() throws IOException {
        TestAliases.prepareConfig(f, "Args1=a", "a=b", "b=Args1");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        cli.parse(new String[]{"a"});
    }

    @Test
    public void user_aliases_force_builtin_01() throws IOException {
        TestAliases.prepareConfig(f, "Args1=a", "a=b", "b=!Args1 -debug");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Args1 args = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertTrue((boolean)args.debug);
    }

    @Test(expectedExceptions={ParseCommandUnrecognizedException.class})
    public void user_aliases_force_builtin_02() throws IOException {
        TestAliases.prepareConfig(f, "Args1=a", "a=b", "b=!Args1 -debug");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withAliasForceBuiltInPrefix('@').withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Args1 args = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertTrue((boolean)args.debug);
    }

    @Test
    public void user_aliases_force_builtin_03() throws IOException {
        TestAliases.prepareConfig(f, "Args1=a", "a=b", "b=@Args1 -debug");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withAliasForceBuiltInPrefix('@').withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Args1 args = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertTrue((boolean)args.debug);
    }

    @Test
    public void user_aliases_force_builtin_04() throws IOException {
        TestAliases.prepareConfig(f, "Args1=!Args1 -debug");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Args1 args = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertTrue((boolean)args.debug);
        args = (Args1)cli.parse(new String[]{"!Args1"});
        Assert.assertFalse((boolean)args.debug);
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void user_aliases_force_builtin_05() throws IOException {
        TestAliases.prepareConfig(f, "logs=logs --format Json", "xml=logs --format Xml", "json=logs --format Json");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Logs.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        cli.parse(new String[]{"logs"});
    }

    @Test
    public void user_aliases_force_builtin_06() throws IOException {
        TestAliases.prepareConfig(f, "logs=!logs --format Json", "xml=!logs --format Xml", "json=!logs --format Json");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Logs.class);
        builder.withParser().withAliasesOverridingBuiltIns().withAliasesChaining().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Logs logs = (Logs)cli.parse(new String[]{"logs"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Json));
        logs = (Logs)cli.parse(new String[]{"json"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Json));
        logs = (Logs)cli.parse(new String[]{"xml"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Xml));
        logs = (Logs)cli.parse(new String[]{"logs", "--format", "Text"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Text));
        logs = (Logs)cli.parse(new String[]{"!logs"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Text));
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void user_aliases_force_builtin_08() throws IOException {
        TestAliases.prepareConfig(f, "logs=logs --format Json", "xml=logs --format Xml", "json=logs --format Json");
        Cli cli = new Cli(LogsWithParser.class);
        cli.parse(new String[]{"logs"});
    }

    @Test
    public void user_aliases_force_builtin_09() throws IOException {
        TestAliases.prepareConfig(f, "logs=@logs --format Json", "xml=@logs --format Xml", "json=@logs --format Json");
        Cli cli = new Cli(LogsWithParser.class);
        Logs logs = (Logs)cli.parse(new String[]{"logs"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Json));
        logs = (Logs)cli.parse(new String[]{"json"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Json));
        logs = (Logs)cli.parse(new String[]{"xml"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Xml));
        logs = (Logs)cli.parse(new String[]{"logs", "--format", "Text"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Text));
        logs = (Logs)cli.parse(new String[]{"@logs"});
        Assert.assertEquals((Object)((Object)logs.format), (Object)((Object)Logs.Format.Text));
    }

    @Test
    public void user_aliases_force_builtin_10() throws IOException {
        TestAliases.prepareConfig(f, "Args1=!Args1 -debug");
        CliBuilder builder = Cli.builder((String)"test").withCommand(Args1.class);
        builder.withParser().withUserAliases().withProgramName("test").withSearchLocation("target/");
        Cli cli = builder.build();
        Args1 args = (Args1)cli.parse(new String[]{"Args1"});
        Assert.assertFalse((boolean)args.debug);
    }
}

