/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.aliases;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.args.Args1;
import com.github.rvesse.airline.builder.CliBuilder;
import com.github.rvesse.airline.parser.errors.ParseAliasCircularReferenceException;
import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAliasResolver {
    private CliBuilder<Args1> prepareBuilder() {
        return Cli.builder((String)"test").withCommand(Args1.class).withDefaultCommand(Args1.class);
    }

    @Test
    public void alias_resolution_simple_01() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArgument("-debug");
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertTrue((boolean)cmd.debug);
    }

    @Test
    public void alias_resolution_simple_02() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "4"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertEquals((int)cmd.verbose, (int)4);
    }

    @Test
    public void alias_resolution_positional_01() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "$1"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a", "7"});
        Assert.assertEquals((int)cmd.verbose, (int)7);
    }

    @Test
    public void alias_resolution_positional_02() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "$2", "-long", "$1"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a", "3", "6"});
        Assert.assertEquals((int)cmd.verbose, (int)6);
        Assert.assertEquals((long)cmd.l, (long)3L);
    }

    @Test
    public void alias_resolution_positional_03() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "${1:-14}"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertEquals((int)cmd.verbose, (int)14);
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void alias_resolution_positional_04() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "${1:14}"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertNotEquals((Object)cmd.verbose, (Object)14);
    }

    @Test
    public void alias_resolution_positional_05() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"${1:14}"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertTrue((boolean)cmd.parameters.contains("${1:14}"));
    }

    @Test
    public void alias_resolution_positional_06() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"$1"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertTrue((boolean)cmd.parameters.contains("$1"));
    }

    @Test
    public void alias_resolution_positional_07() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"-verbose", "${1}"});
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a", "9"});
        Assert.assertEquals((int)cmd.verbose, (int)9);
    }

    @Test
    public void alias_resolution_chained_01() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"b"});
        builder.withParser().withAlias("b").withArgument("-debug");
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertFalse((boolean)cmd.debug);
        Assert.assertEquals((int)cmd.parameters.size(), (int)1);
        Assert.assertTrue((boolean)cmd.parameters.contains("b"));
    }

    @Test
    public void alias_resolution_chained_02() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"b"});
        builder.withParser().withAlias("b").withArgument("-debug");
        builder.withParser().withAliasesChaining();
        Args1 cmd = (Args1)builder.build().parse(new String[]{"a"});
        Assert.assertTrue((boolean)cmd.debug);
        Assert.assertEquals((int)cmd.parameters.size(), (int)0);
        Assert.assertFalse((boolean)cmd.parameters.contains("b"));
    }

    @Test(expectedExceptions={ParseAliasCircularReferenceException.class})
    public void alias_resolution_chained_03() {
        CliBuilder<Args1> builder = this.prepareBuilder();
        builder.withParser().withAlias("a").withArguments(new String[]{"b"});
        builder.withParser().withAlias("b").withArguments(new String[]{"c", "-debug"});
        builder.withParser().withAlias("c").withArgument("a");
        builder.withParser().withAliasesChaining();
        builder.build().parse(new String[]{"a"});
    }
}

