/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.SingleCommand;
import com.github.rvesse.airline.args.ArgsFlagNegation;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.errors.ParseArgumentsUnexpectedException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFlagNegation {
    @Test
    public void flagNegationConfigure() {
        ParserMetadata parserConfig = new ParserBuilder().withFlagNegationPrefix("--no-").build();
        SingleCommand parser = SingleCommand.singleCommand(ArgsFlagNegation.class, (ParserMetadata)parserConfig);
        ArgsFlagNegation args = (ArgsFlagNegation)parser.parse(new String[0]);
        Assert.assertFalse((boolean)args.falseFlag);
        Assert.assertTrue((boolean)args.trueFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--false"});
        Assert.assertTrue((boolean)args.falseFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--no-false"});
        Assert.assertFalse((boolean)args.falseFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--true"});
        Assert.assertTrue((boolean)args.trueFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--no-true"});
        Assert.assertFalse((boolean)args.trueFlag);
    }

    @Test
    public void flagNegationNotConfigured() {
        SingleCommand parser = SingleCommand.singleCommand(ArgsFlagNegation.class);
        ArgsFlagNegation args = (ArgsFlagNegation)parser.parse(new String[0]);
        Assert.assertFalse((boolean)args.falseFlag);
        Assert.assertTrue((boolean)args.trueFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--false"});
        Assert.assertTrue((boolean)args.falseFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--no-false"});
        Assert.assertTrue((boolean)args.falseFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--true"});
        Assert.assertTrue((boolean)args.trueFlag);
        args = (ArgsFlagNegation)parser.parse(new String[]{"--no-true"});
        Assert.assertTrue((boolean)args.trueFlag);
    }

    @Test(expectedExceptions={ParseArgumentsUnexpectedException.class})
    public void flagNegationUnregistedPrefixUsed() {
        ParserMetadata parserConfig = new ParserBuilder().withFlagNegationPrefix("--invert-").build();
        SingleCommand parser = SingleCommand.singleCommand(ArgsFlagNegation.class, (ParserMetadata)parserConfig);
        parser.parse(new String[]{"--invert-true"});
    }
}

