/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser;

import com.github.rvesse.airline.parser.errors.ParseOptionConversionException;
import com.github.rvesse.airline.types.DefaultTypeConverter;
import com.github.rvesse.airline.types.TypeConverter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDefaultTypeConverter {
    private static final String OPTION_NAME = "--test";
    private TypeConverter converter = new DefaultTypeConverter();

    @Test(expectedExceptions={NullPointerException.class})
    public void convert_null_value() {
        this.converter.convert(OPTION_NAME, String.class, null);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void convert_null_name() {
        this.converter.convert(null, String.class, "value");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void convert_null_type() {
        this.converter.convert(OPTION_NAME, null, "value");
    }

    private <T> T testConvert(Class<T> cls, String value) {
        return (T)this.converter.convert(OPTION_NAME, cls, value);
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void convert_unsupported_type_failure() {
        this.testConvert(Unconvertible.class, "test");
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void convert_out_of_range_byte_failure() {
        this.testConvert(Byte.class, Long.toString(128L));
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void convert_out_of_range_short_failure() {
        this.testConvert(Short.class, Long.toString(32768L));
    }

    @Test(expectedExceptions={ParseOptionConversionException.class})
    public void convert_out_of_range_int_failure() {
        this.testConvert(Integer.class, Long.toString(0x80000000L));
    }

    @Test
    public void convert_string() {
        String value = "test";
        String converted = this.testConvert(String.class, value);
        Assert.assertEquals((String)converted, (String)value);
    }

    @Test
    public void convert_boolean() {
        String value = "true";
        Boolean converted = this.testConvert(Boolean.class, value);
        Assert.assertEquals((Object)converted, (Object)Boolean.TRUE);
        value = "false";
        converted = this.testConvert(Boolean.class, value);
        Assert.assertEquals((Object)converted, (Object)Boolean.FALSE);
    }

    @Test
    public void convert_byte() {
        for (byte b = 0; b < 127; b = (byte)(b + 1)) {
            String value = Byte.toString(b);
            Byte converted = this.testConvert(Byte.class, value);
            Assert.assertEquals((byte)converted, (byte)b);
        }
    }

    @Test
    public void convert_short() {
        short s = 0;
        int increment = 0;
        while (s < Short.MAX_VALUE) {
            String value = Short.toString(s);
            Short converted = this.testConvert(Short.class, value);
            Assert.assertEquals((short)converted, (short)s);
            increment = (short)(increment + 1);
            s = (short)(s + increment);
        }
    }

    @Test
    public void convert_integer() {
        int i = 0;
        int increment = 1;
        while (i < Integer.MAX_VALUE) {
            String value = Integer.toString(i);
            Integer converted = this.testConvert(Integer.class, value);
            Assert.assertEquals((int)converted, (int)i);
            i += increment;
            increment *= 2;
        }
    }

    @Test
    public void convert_long() {
        long i = 0L;
        long increment = 1L;
        while (i < Long.MAX_VALUE) {
            String value = Long.toString(i);
            Long converted = this.testConvert(Long.class, value);
            Assert.assertEquals((long)converted, (long)i);
            i += increment;
            increment *= 2L;
        }
    }

    @Test
    public void convert_float() {
        float[] fs;
        for (float f : fs = new float[]{Float.MIN_VALUE, Float.MAX_VALUE, 0.0f, 123.456f, Float.NaN}) {
            String value = Float.toString(f);
            Float converted = this.testConvert(Float.class, value);
            Assert.assertEquals((Object)Float.valueOf(converted.floatValue()), (Object)Float.valueOf(f));
        }
    }

    @Test
    public void convert_double() {
        double[] ds;
        for (double d : ds = new double[]{1.4E-45f, 3.4028234663852886E38, 0.0, 123.456f, Double.NaN, Double.MIN_VALUE, Double.MAX_VALUE, Double.NaN, 0.0, 123.456}) {
            String value = Double.toString(d);
            Double converted = this.testConvert(Double.class, value);
            Assert.assertEquals((Object)converted, (Object)d);
        }
    }

    @Test
    public void convert_static_fromString() {
        String value = "test";
        FromStringable converted = this.testConvert(FromStringable.class, value);
        Assert.assertEquals((String)converted.value, (String)value);
    }

    @Test
    public void convert_constructor() {
        String value = "test";
        ConversionExample converted = this.testConvert(ConversionExample.class, value);
        Assert.assertEquals((String)converted.value, (String)value);
    }

    @Test
    public void convert_enum() {
        for (ConversionEnum item : ConversionEnum.values()) {
            String value = item.name();
            ConversionEnum converted = this.testConvert(ConversionEnum.class, value);
            Assert.assertEquals((Object)((Object)converted), (Object)((Object)item));
        }
    }

    public static enum ConversionEnum {
        FOO,
        BAR;

    }

    public static class FromStringable
    extends ConversionExample {
        private FromStringable(String value) {
            super(value);
        }

        public static FromStringable fromString(String value) {
            return new FromStringable(value);
        }
    }

    public static class ConversionExample {
        public final String value;

        public ConversionExample(String value) {
            this.value = value;
        }
    }

    private static class Unconvertible {
        private Unconvertible() {
        }
    }
}

